/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.netbeans.modules.schema2beans.Schema2Beans;
import org.netbeans.modules.schema2beansdev.GenBeans;

public class Schema2BeansProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(Schema2Beans.class.getCanonicalName(), Schema2Beans.Multiple.class.getCanonicalName()));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.errorRaised() || roundEnv.processingOver()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Schema2Beans.class)) {
            this.handle(element, element.getAnnotation(Schema2Beans.class));
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Schema2Beans.Multiple.class)) {
            for (Schema2Beans s2b : element.getAnnotation(Schema2Beans.Multiple.class).value()) {
                this.handle(element, s2b);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(final Element e, Schema2Beans s2b) {
        try {
            GenBeans.Config config = new GenBeans.Config();
            config.setAuto(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            config.setMessageOut(ps);
            final String pkg = ((PackageElement)e).getQualifiedName().toString();
            config.setPackagePath(pkg);
            config.setOutputStreamProvider(new GenBeans.OutputStreamProvider(){

                @Override
                public OutputStream getStream(String dir, String name, String extension) throws IOException {
                    if (!dir.replace('\\', '/').endsWith(pkg.replace('.', '/'))) {
                        throw new IOException("Unexpected dir: " + dir);
                    }
                    if (!extension.equals("java")) {
                        throw new IOException("Unexpected extension: " + extension);
                    }
                    String nameAndExt = name + "." + extension;
                    try {
                        return Schema2BeansProcessor.this.processingEnv.getFiler().createSourceFile(pkg + "." + name, e).openOutputStream();
                    }
                    catch (FilerException x) {
                        Schema2BeansProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "ignoring attempt to regenerate " + nameAndExt);
                        return new ByteArrayOutputStream();
                    }
                }

                @Override
                public boolean isOlderThan(String dir, String name, String extension, long time) throws IOException {
                    return true;
                }
            });
            FileObject schema = this.findResource(s2b.schema(), pkg);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "generating beans in " + pkg);
            config.setFileIn(schema.openInputStream());
            String inputUri = this.fileObjectToUri(schema).toString();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "parsing: " + inputUri);
            config.setInputURI(inputUri);
            config.setJava5(s2b.java5());
            switch (s2b.schemaType()) {
                case DTD: {
                    config.setSchemaType(1);
                    break;
                }
                case XML_SCHEMA: {
                    config.setSchemaType(0);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (s2b.mddFile().length() > 0) {
                try {
                    FileObject mdd = this.findResource(s2b.mddFile(), pkg);
                    config.setMddIn(mdd.openInputStream());
                }
                catch (FileNotFoundException ex) {
                    FileObject mdd = this.createResource(s2b.mddFile(), pkg);
                    File f = new File(this.fileObjectToUri(mdd));
                    f.getParentFile().mkdirs();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "going to create new MDD file at " + f.getAbsolutePath());
                    config.setMddFile(f);
                }
            }
            switch (s2b.outputType()) {
                case TRADITIONAL_BASEBEAN: {
                    config.setOutputType(0);
                    break;
                }
                case JAVABEANS: {
                    config.setOutputType(1);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            config.setGenerateValidate(s2b.validate());
            config.setRemoveUnreferencedNodes(s2b.removeUnreferencedNodes());
            config.setAttributesAsProperties(s2b.attrProp());
            config.setGenerateHasChanged(s2b.generateHasChanged());
            if (s2b.commonInterface().length() > 0) {
                config.setGenerateCommonInterface(s2b.commonInterface());
            }
            config.setUseInterfaces(s2b.useInterfaces());
            config.setExtendBaseBean(s2b.extendBaseBean());
            config.setFinder(s2b.finder());
            if (s2b.docRoot().length() > 0) {
                config.setDocRoot(s2b.docRoot());
            }
            config.setGenerateInterfaces(s2b.generateInterfaces());
            config.setStandalone(s2b.standalone());
            try {
                GenBeans.doIt(config);
            }
            finally {
                ps.flush();
                for (String line : baos.toString().split("\n")) {
                    if (line.length() <= 0) continue;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, line);
                }
            }
        }
        catch (Exception x) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to process", e);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            x.printStackTrace(ps);
            ps.close();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, baos.toString());
        }
    }

    private FileObject findResource(String path, String pkg) throws URISyntaxException, IOException {
        String abspath = path.startsWith("/") ? path.substring(1) : new URI(null, pkg.replace('.', '/') + "/", null).resolve(new URI(null, path, null)).getPath();
        FileObject f = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", abspath);
        try {
            f.openInputStream().close();
        }
        catch (FileNotFoundException x) {
            f = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", abspath);
        }
        return f;
    }

    private FileObject createResource(String path, String pkg) throws URISyntaxException, IOException {
        String abspath = path.startsWith("/") ? path.substring(1) : new URI(null, pkg.replace('.', '/') + "/", null).resolve(new URI(null, path, null)).getPath();
        return this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", abspath, new Element[0]);
    }

    private URI fileObjectToUri(FileObject f) throws URISyntaxException {
        URI u = f.toUri();
        if (u.getScheme() == null) {
            u = new URI("file", u.getPath(), u.getFragment());
        }
        return u;
    }
}

