/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.spi.java.queries.AnnotationProcessingQueryImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AnnotationProcessingQueryImpl
implements AnnotationProcessingQueryImplementation,
AntProjectListener {
    static final String EL_ANNOTATION_PROCESSING = "annotation-processing";
    static final String EL_PROCESSOR_PATH = "processor-path";
    private static final String EL_SCAN_TRIGGER = "scan-trigger";
    private static final String EL_EDITOR_TRIGGER = "editor-trigger";
    private static final String EL_PROCESSOR = "processor";
    private static final String EL_PROCESSOR_OPTION = "processor-option";
    private static final String EL_SOURCE_OUTPUT = "source-output";
    private static final Logger LOG = Logger.getLogger(AnnotationProcessingQueryImpl.class.getName());
    private final Object LCK = new Object();
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final AuxiliaryConfiguration aux;
    private Map<FileObject, R> results;

    public AnnotationProcessingQueryImpl(AntProjectHelper helper, PropertyEvaluator eval, AuxiliaryConfiguration aux) {
        assert (helper != null);
        assert (eval != null);
        assert (aux != null);
        this.helper = helper;
        this.eval = eval;
        this.aux = aux;
        this.helper.addAntProjectListener((AntProjectListener)this);
    }

    public AnnotationProcessingQuery.Result getAnnotationProcessingOptions(final FileObject file) {
        assert (file != null);
        return (AnnotationProcessingQuery.Result)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<AnnotationProcessingQuery.Result>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public AnnotationProcessingQuery.Result run() {
                Object object = AnnotationProcessingQueryImpl.this.LCK;
                synchronized (object) {
                    AnnotationProcessingQueryImpl.this.init(true);
                    assert (AnnotationProcessingQueryImpl.this.results != null);
                    for (Map.Entry entry : AnnotationProcessingQueryImpl.this.results.entrySet()) {
                        FileObject fo = (FileObject)entry.getKey();
                        if (!fo.equals(file) && !FileUtil.isParentOf((FileObject)fo, (FileObject)file)) continue;
                        return (AnnotationProcessingQuery.Result)entry.getValue();
                    }
                    return null;
                }
            }
        });
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.init(false);
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean force) {
        Object object = this.LCK;
        synchronized (object) {
            if (this.results == null) {
                if (force) {
                    this.results = new HashMap<FileObject, R>();
                } else {
                    return;
                }
            }
            HashMap<FileObject, R> added = new HashMap<FileObject, R>();
            HashMap<FileObject, R> retained = new HashMap<FileObject, R>();
            Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/5", true);
            if (java != null) {
                for (Element compilationUnit : XMLUtil.findSubElements((Element)java)) {
                    assert (compilationUnit.getLocalName().equals("compilation-unit")) : compilationUnit;
                    List<FileObject> packageRoots = Classpaths.findPackageRoots(this.helper, this.eval, compilationUnit);
                    for (FileObject source : packageRoots) {
                        R r = this.results.remove(source);
                        if (r == null) {
                            added.put(source, new R(compilationUnit));
                            continue;
                        }
                        retained.put(source, r);
                        r.update(compilationUnit);
                    }
                }
            }
            for (R r : this.results.values()) {
                r.update(null);
            }
            this.results.putAll(added);
            this.results.putAll(retained);
        }
    }

    private class R
    implements AnnotationProcessingQuery.Result {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private volatile Element ap;
        private volatile Set<AnnotationProcessingQuery.Trigger> triggerCache;
        private volatile Map<String, String> optionsCache;
        private volatile Collection<String> processorsCache;
        private volatile List<URL> sourceOutputCache;

        private R(Element cu) {
            assert (cu != null);
            this.ap = this.findAP(cu);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<? extends AnnotationProcessingQuery.Trigger> annotationProcessingEnabled() {
            Set<AnnotationProcessingQuery.Trigger> result = this.triggerCache;
            if (result != null) {
                return result;
            }
            result = EnumSet.noneOf(AnnotationProcessingQuery.Trigger.class);
            if (this.ap != null) {
                for (Element e : XMLUtil.findSubElements((Element)this.ap)) {
                    if (e.getLocalName().equals(AnnotationProcessingQueryImpl.EL_SCAN_TRIGGER)) {
                        result.add(AnnotationProcessingQuery.Trigger.ON_SCAN);
                        continue;
                    }
                    if (!e.getLocalName().equals(AnnotationProcessingQueryImpl.EL_EDITOR_TRIGGER)) continue;
                    result.add(AnnotationProcessingQuery.Trigger.IN_EDITOR);
                }
            }
            if (result.size() == 1 && result.contains(AnnotationProcessingQuery.Trigger.IN_EDITOR)) {
                result.add(AnnotationProcessingQuery.Trigger.ON_SCAN);
                LOG.log(Level.WARNING, "Project {0} project.xml contains annotation processing editor-trigger only. The scan-trigger is required as well, adding it into the APQ.Result.", FileUtil.getFileDisplayName((FileObject)AnnotationProcessingQueryImpl.this.helper.getProjectDirectory()));
            }
            Object object = AnnotationProcessingQueryImpl.this.LCK;
            synchronized (object) {
                if (this.triggerCache == null) {
                    this.triggerCache = result;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterable<? extends String> annotationProcessorsToRun() {
            Collection<String> result = this.processorsCache;
            if (result != null) {
                return result.isEmpty() ? null : result;
            }
            result = new ArrayList<String>();
            if (this.ap != null) {
                for (Element e : XMLUtil.findSubElements((Element)this.ap)) {
                    if (!e.getLocalName().equals(AnnotationProcessingQueryImpl.EL_PROCESSOR)) continue;
                    result.add(AnnotationProcessingQueryImpl.this.eval.evaluate(XMLUtil.findText((Node)e)));
                }
            }
            Object object = AnnotationProcessingQueryImpl.this.LCK;
            synchronized (object) {
                if (this.processorsCache == null) {
                    this.processorsCache = result;
                }
            }
            return result.isEmpty() ? null : result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL sourceOutputDirectory() {
            List<URL> result = this.sourceOutputCache;
            if (result != null) {
                return result.isEmpty() ? null : result.get(0);
            }
            result = new ArrayList<URL>(1);
            if (this.ap != null) {
                for (Element e : XMLUtil.findSubElements((Element)this.ap)) {
                    if (!e.getLocalName().equals(AnnotationProcessingQueryImpl.EL_SOURCE_OUTPUT)) continue;
                    try {
                        String path = AnnotationProcessingQueryImpl.this.eval.evaluate(XMLUtil.findText((Node)e));
                        result.add(Utilities.toURI((File)AnnotationProcessingQueryImpl.this.helper.resolveFile(path)).toURL());
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    break;
                }
            }
            Object object = AnnotationProcessingQueryImpl.this.LCK;
            synchronized (object) {
                if (this.sourceOutputCache == null) {
                    this.sourceOutputCache = result;
                }
            }
            return result.isEmpty() ? null : result.get(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<? extends String, ? extends String> processorOptions() {
            Map<String, String> result = this.optionsCache;
            if (result != null) {
                return result;
            }
            result = new HashMap<String, String>();
            if (this.ap != null) {
                for (Element e : XMLUtil.findSubElements((Element)this.ap)) {
                    if (!e.getLocalName().equals(AnnotationProcessingQueryImpl.EL_PROCESSOR_OPTION)) continue;
                    Element keyElement = XMLUtil.findElement((Element)e, (String)"key", (String)"http://www.netbeans.org/ns/freeform-project-java/5");
                    Element valueElement = XMLUtil.findElement((Element)e, (String)"value", (String)"http://www.netbeans.org/ns/freeform-project-java/5");
                    if (keyElement == null || valueElement == null) continue;
                    String key = XMLUtil.findText((Node)keyElement);
                    String value = XMLUtil.findText((Node)valueElement);
                    result.put(key, value == null ? null : AnnotationProcessingQueryImpl.this.eval.evaluate(value));
                }
            }
            Object object = AnnotationProcessingQueryImpl.this.LCK;
            synchronized (object) {
                if (this.optionsCache == null) {
                    this.optionsCache = result;
                }
            }
            return result;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(Element cu) {
            Object object = AnnotationProcessingQueryImpl.this.LCK;
            synchronized (object) {
                this.triggerCache = null;
                this.optionsCache = null;
                this.processorsCache = null;
                this.sourceOutputCache = null;
                this.ap = this.findAP(cu);
            }
            this.changeSupport.fireChange();
        }

        private Element findAP(Element cu) {
            return cu == null ? null : XMLUtil.findElement((Element)cu, (String)AnnotationProcessingQueryImpl.EL_ANNOTATION_PROCESSING, (String)"http://www.netbeans.org/ns/freeform-project-java/5");
        }
    }
}

