/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeGenerator;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.openide.filesystems.FileObject;

public final class ToStringGenerator
extends CodeGenerator {
    public static final String GENERATE_TO_STRING = "java.generate.toString";
    private final Set<String> commands = Collections.singleton("java.generate.toString");
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(CompilationInfo info, CodeActionParams params) {
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        int offset = ToStringGenerator.getOffset(info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement type = (TypeElement)info.getTrees().getElement(tp);
        if (type == null || !type.getKind().isClass()) {
            return Collections.emptyList();
        }
        ArrayList<QuickPickItem> fields = new ArrayList<QuickPickItem>();
        for (Element element : type.getEnclosedElements()) {
            switch (element.getKind()) {
                case METHOD: {
                    if (!element.getSimpleName().contentEquals("toString") || !((ExecutableElement)element).getParameters().isEmpty()) break;
                    return Collections.emptyList();
                }
                case FIELD: {
                    if ("<error>".contentEquals(element.getSimpleName()) || element.getModifiers().contains((Object)Modifier.STATIC)) break;
                    QuickPickItem item = new QuickPickItem(ToStringGenerator.createLabel(info, (VariableElement)element));
                    item.setUserData(new CodeGenerator.ElementData(element));
                    fields.add(item);
                }
            }
        }
        String uri = Utils.toUri(info.getFileObject());
        return Collections.singletonList(ToStringGenerator.createCodeAction(Bundle.DN_GenerateToString(), "source.generate", GENERATE_TO_STRING, uri, offset, fields));
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (arguments.size() > 2) {
            String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
            int offset = (Integer)this.gson.fromJson(this.gson.toJson(arguments.get(1)), Integer.class);
            List<Object> fields = Arrays.asList((Object[])this.gson.fromJson(this.gson.toJson(arguments.get(2)), QuickPickItem[].class));
            if (fields.isEmpty()) {
                this.generate(client, uri, offset, fields);
            } else {
                client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectToString(), true, fields)).thenAccept(selected -> {
                    if (selected != null) {
                        this.generate(client, uri, offset, (List<QuickPickItem>)selected);
                    }
                });
            }
        } else {
            client.logMessage(new MessageParams(MessageType.Error, String.format("Illegal number of arguments received for command: %s", command)));
        }
        return CompletableFuture.completedFuture(true);
    }

    private void generate(NbCodeLanguageClient client, String uri, int offset, List<QuickPickItem> fields) {
        try {
            FileObject file = Utils.fromUri(uri);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                TreePath tp = wc.getTreeUtilities().pathFor(offset);
                tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
                if (tp != null) {
                    ClassTree cls = (ClassTree)tp.getLeaf();
                    List selectedFields = fields.stream().map(item -> {
                        CodeGenerator.ElementData data = (CodeGenerator.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeGenerator.ElementData.class);
                        return (VariableElement)data.resolve((CompilationInfo)wc);
                    }).collect(Collectors.toList());
                    MethodTree method = org.netbeans.modules.java.editor.codegen.ToStringGenerator.createToStringMethod((WorkingCopy)wc, selectedFields, (String)cls.getSimpleName().toString(), (boolean)true);
                    wc.rewrite((Tree)cls, (Tree)GeneratorUtilities.get((WorkingCopy)wc).insertClassMember(cls, (Tree)method));
                }
            }));
            client.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(Collections.singletonMap(uri, edits))));
        }
        catch (IOException | IllegalArgumentException ex) {
            client.logMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }
}

