/**
 * The DOM Storage mechanism is a means through which string key/value pairs can be securely stored and later retrieved for use. The goal of this addition is to provide a comprehensive means through which interactive applications can be built (including advanced abilities, such as being able to work "offline" for extended periods of time).<br>DOM Storage is useful because no good browser-only methods exist for persisting reasonable amounts of data for any period of time. Browser cookies have limited capacity and provide no support for organizing persisted data, and other methods (such as Flash Local Storage) require an external plugin.<br>One of the first public applications to make use of the new DOM Storage functionality (in addition to Internet Explorer's userData Behavior) was halfnote (a note-taking application) written by Aaron Boodman. In his application, Aaron simultaneously saved notes back to a server (when Internet connectivity was available) and a local data store. This allowed the user to safely write backed-up notes even with sporadic Internet connectivity.<br>While the concept, and implementation, presented in halfnote was comparatively simple, its creation shows the possibility for a new breed of web applications that are usable both online and offline.
 */
var Storage = {
}
/**
 * @returns {undefined}
 */
Storage.prototype.clear = function() {};

/**
 * @returns {undefined}
 */
Storage.prototype.removeItem = function() {};

/**
 * @returns {DOMString}
 */
Storage.prototype.getItem = function() {};

/**
 * @returns {Number}
 */
Storage.prototype.length = new Number();

/**
 * @returns {undefined}
 */
Storage.prototype.setItem = function() {};

/**
 * @returns {DOMString}
 */
Storage.prototype.key = function() {};

/**
 * Represents the Storage prototype object.
 * @syntax Storage.prototype
 * @static
 */
Storage.prototype;

