/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api;

import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.parsing.api.Snapshot;

public class HtmlEditorUtils {
    public static OffsetRange getOffsetRange(Element element) {
        int from = element.from();
        int to = element.to();
        if (from < 0 || to < 0) {
            return OffsetRange.NONE;
        }
        if (from > to) {
            return OffsetRange.NONE;
        }
        return new OffsetRange(from, to);
    }

    public static OffsetRange getDocumentOffsetRange(Element element, Snapshot snapshot) {
        int from = element.from();
        int to = element.to();
        if (from < 0 || to < 0) {
            return OffsetRange.NONE;
        }
        if (from > to) {
            return OffsetRange.NONE;
        }
        int origFrom = snapshot.getOriginalOffset(from);
        int origTo = snapshot.getOriginalOffset(to);
        if (origFrom < 0 || origTo < 0) {
            return OffsetRange.NONE;
        }
        if (origFrom > origTo) {
            return OffsetRange.NONE;
        }
        return new OffsetRange(origFrom, origTo);
    }
}

