/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.ui.wizard.BaseWizardIterator;
import org.netbeans.modules.javascript.nodejs.ui.wizard.Bundle;
import org.netbeans.modules.javascript.nodejs.ui.wizard.ExistingProjectPanel;
import org.netbeans.modules.javascript.nodejs.ui.wizard.ProjectSetup;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.clientproject.createprojectapi.ClientSideProjectGenerator;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ExistingProjectWizardIterator
extends BaseWizardIterator {
    static final String SOURCE_ROOT = "SOURCE_ROOT";
    static final String SITE_ROOT = "SITE_ROOT";
    static final String TEST_ROOT = "TEST_ROOT";
    static final String[] MAIN_JS_FILE_NAMES = new String[]{"app.js", "main.js", "index.js"};
    private final String displayName;

    public ExistingProjectWizardIterator(String displayName) {
        assert (displayName != null);
        this.displayName = displayName;
    }

    public static ExistingProjectWizardIterator existingNodeJsProject() {
        return new ExistingProjectWizardIterator(Bundle.ExistingProjectWizardIterator_displayName());
    }

    @Override
    String getWizardTitle() {
        return this.displayName;
    }

    @Override
    WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
        return new WizardDescriptor.Panel[]{new ExistingProjectPanel()};
    }

    @Override
    String[] createSteps() {
        return new String[]{Bundle.ExistingProjectWizardIterator_nameLocation_title()};
    }

    @Override
    void uninitializeInternal() {
        this.wizardDescriptor.putProperty("PROJECT_DIRECTORY", null);
        this.wizardDescriptor.putProperty("NAME", null);
        this.wizardDescriptor.putProperty(SOURCE_ROOT, null);
        this.wizardDescriptor.putProperty(SITE_ROOT, null);
        this.wizardDescriptor.putProperty(TEST_ROOT, null);
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        CreateProjectProperties createProperties;
        Project project;
        FileObject mainJsFile;
        handle.start();
        handle.progress(Bundle.ExisitngProjectWizardIterator_progress_creating());
        HashSet<FileObject> files = new HashSet<FileObject>();
        FileObject projectDirectory = this.getDirectory("PROJECT_DIRECTORY", true);
        assert (projectDirectory != null);
        files.add(projectDirectory);
        FileObject sourceRoot = this.getDirectory(SOURCE_ROOT, true);
        assert (sourceRoot != null);
        files.add(sourceRoot);
        FileObject siteRoot = this.getDirectory(SITE_ROOT, false);
        if (siteRoot != null) {
            files.add(siteRoot);
        }
        if ((mainJsFile = this.findMainJsFile(project = ClientSideProjectGenerator.createProject((CreateProjectProperties)(createProperties = new CreateProjectProperties(projectDirectory, (String)this.wizardDescriptor.getProperty("NAME")).setSourceFolder(this.relativizePath(projectDirectory, sourceRoot)).setSiteRootFolder(this.relativizePath(projectDirectory, siteRoot)).setPlatformProvider("node.js"))), sourceRoot)) != null) {
            files.add(mainJsFile);
            NodeJsSupport.forProject(project).getPreferences().setStartFile(FileUtil.toFile((FileObject)mainJsFile).getAbsolutePath());
            if (siteRoot == null) {
                ProjectSetup.setupRun(project);
            }
        }
        handle.finish();
        return files;
    }

    @CheckForNull
    private FileObject getDirectory(String key, boolean compulsory) {
        File dir = (File)this.wizardDescriptor.getProperty(key);
        if (!compulsory && dir == null) {
            return null;
        }
        assert (dir != null);
        FileObject directory = FileUtil.toFileObject((File)dir);
        assert (directory != null) : "FileObject must be found for " + dir;
        return directory;
    }

    private String relativizePath(FileObject projectDir, @NullAllowed FileObject dir) {
        assert (projectDir != null);
        if (dir == null) {
            return null;
        }
        String relativePath = FileUtil.getRelativePath((FileObject)projectDir, (FileObject)dir);
        if (relativePath != null) {
            return relativePath;
        }
        relativePath = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)projectDir), (File)FileUtil.toFile((FileObject)dir));
        if (relativePath != null) {
            return relativePath;
        }
        return FileUtil.toFile((FileObject)dir).getAbsolutePath();
    }

    @CheckForNull
    private FileObject findMainJsFile(Project project, FileObject sourceRoot) {
        FileObject projectDir = project.getProjectDirectory();
        String main = NodeJsSupport.forProject(project).getPackageJson().getContentValue(String.class, "main");
        FileObject mainFile = this.getFileObject(projectDir, main);
        if (mainFile != null) {
            return mainFile;
        }
        String projectName = ProjectUtils.getInformation((Project)project).getName();
        mainFile = this.getFileObject(projectDir, projectName + ".js");
        if (mainFile != null) {
            return mainFile;
        }
        mainFile = this.getFileObject(projectDir, projectName.toLowerCase() + ".js");
        if (mainFile != null) {
            return mainFile;
        }
        HashSet<String> names = new HashSet<String>(Arrays.asList(MAIN_JS_FILE_NAMES));
        FileObject first = null;
        for (FileObject child : sourceRoot.getChildren()) {
            if (!FileUtils.isJavaScriptFile(child)) continue;
            if (first == null) {
                first = child;
            }
            if (!names.contains(child.getNameExt())) continue;
            return child;
        }
        return first;
    }

    @CheckForNull
    private FileObject getFileObject(FileObject dir, String name) {
        FileObject fo;
        if (StringUtilities.hasText((String)name) && (fo = dir.getFileObject(name)) != null && FileUtils.isJavaScriptFile(fo)) {
            return fo;
        }
        return null;
    }
}

