/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.foojay.api.discoclient.PropertyManager;
import io.foojay.api.discoclient.event.CacheEvt;
import io.foojay.api.discoclient.event.DCEvt;
import io.foojay.api.discoclient.event.DownloadEvt;
import io.foojay.api.discoclient.event.Evt;
import io.foojay.api.discoclient.event.EvtObserver;
import io.foojay.api.discoclient.event.EvtType;
import io.foojay.api.discoclient.pkg.Architecture;
import io.foojay.api.discoclient.pkg.ArchiveType;
import io.foojay.api.discoclient.pkg.Bitness;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.Latest;
import io.foojay.api.discoclient.pkg.LibCType;
import io.foojay.api.discoclient.pkg.MajorVersion;
import io.foojay.api.discoclient.pkg.OperatingSystem;
import io.foojay.api.discoclient.pkg.PackageType;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.pkg.ReleaseStatus;
import io.foojay.api.discoclient.pkg.Scope;
import io.foojay.api.discoclient.pkg.SemVer;
import io.foojay.api.discoclient.pkg.TermOfSupport;
import io.foojay.api.discoclient.pkg.VersionNumber;
import io.foojay.api.discoclient.util.Comparison;
import io.foojay.api.discoclient.util.Constants;
import io.foojay.api.discoclient.util.Helper;
import io.foojay.api.discoclient.util.OutputFormat;
import io.foojay.api.discoclient.util.PkgInfo;
import io.foojay.api.discoclient.util.ReadableConsumerByteChannel;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoClient.class);
    public final AtomicBoolean cacheReady = new AtomicBoolean(false);
    private final Queue<Pkg> pkgCache = new ConcurrentLinkedQueue<Pkg>();
    private final Queue<MajorVersion> majorVersionCache = new ConcurrentLinkedQueue<MajorVersion>();
    private final Map<String, List<EvtObserver>> observers = new ConcurrentHashMap<String, List<EvtObserver>>();
    private final ScheduledExecutorService service = Executors.newScheduledThreadPool(2);
    private final Runnable updateCache = () -> {
        this.cacheReady.set(false);
        this.fireEvt(new CacheEvt((Object)this, (EvtType<? extends CacheEvt>)CacheEvt.CACHE_UPDATING));
        this.pkgCache.clear();
        this.getAllPackagesAsync().thenAccept(r -> {
            LinkedList tmpList = new LinkedList(r);
            HashSet unique = new HashSet(tmpList);
            this.pkgCache.addAll(unique);
            this.cacheReady.set(true);
            this.fireEvt(new CacheEvt((Object)this, (EvtType<? extends CacheEvt>)CacheEvt.CACHE_READY));
        });
    };

    public DiscoClient() {
        this.getAllMajorVersionsAsync(true).thenAccept(r -> this.majorVersionCache.addAll((Collection<MajorVersion>)r));
        this.service.scheduleAtFixedRate(this.updateCache, 1L, 3600L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.service.shutdownNow()));
    }

    public Queue<Pkg> getAllPackages() {
        if (this.cacheReady.get()) {
            return this.pkgCache;
        }
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/packages").append("?release_status=ea").append("&release_status=ga");
        String query = queryBuilder.toString();
        if (query.isEmpty()) {
            return new ConcurrentLinkedQueue<Pkg>();
        }
        ConcurrentLinkedQueue<Pkg> pkgs = new ConcurrentLinkedQueue();
        ArrayList<Pkg> pkgsFound = new ArrayList<Pkg>();
        Gson gson = new Gson();
        String bodyText = Helper.get(query);
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject bundleJsonObj = jsonArray.get(i).getAsJsonObject();
                pkgsFound.add(new Pkg(bundleJsonObj.toString()));
            }
        }
        pkgs.addAll(pkgsFound);
        HashSet unique = new HashSet(pkgs);
        pkgs = new LinkedList(unique);
        return pkgs;
    }

    public CompletableFuture<Queue<Pkg>> getAllPackagesAsync() {
        if (this.cacheReady.get()) {
            CompletableFuture<Queue<Pkg>> future = new CompletableFuture<Queue<Pkg>>();
            future.complete(this.pkgCache);
            return future;
        }
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/packages").append("?release_status=ea").append("&release_status=ga");
        String query = queryBuilder.toString();
        CompletionStage future = Helper.getAsync(query).thenApply(response -> {
            if (this.cacheReady.get()) {
                return this.pkgCache;
            }
            ConcurrentLinkedQueue<Pkg> pkgsFound = new ConcurrentLinkedQueue<Pkg>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(response, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject bundleJsonObj = jsonArray.get(i).getAsJsonObject();
                    pkgsFound.add(new Pkg(bundleJsonObj.toString()));
                }
            }
            return pkgsFound;
        });
        return future;
    }

    public List<Pkg> getPkgs(Distribution distribution, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, LibCType libcType, Architecture architecture, Bitness bitness, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable, ReleaseStatus releaseStatus, TermOfSupport termOfSupport, Scope scope) {
        String query;
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/packages");
        int initialLength = queryBuilder.length();
        Distribution distributionCache = Distribution.NONE;
        if (null != distribution && Distribution.NONE != distribution && Distribution.NOT_FOUND != distribution) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("distro").append("=").append(distribution.getApiString());
            distributionCache = distribution;
        }
        if (null != versionNumber) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("version").append("=").append(versionNumber.toString());
        }
        Latest latestCache = Latest.NONE;
        if (null != latest && Latest.NONE != latest && Latest.NOT_FOUND != latest) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("latest").append("=").append(latest.getApiString());
            latestCache = latest;
        }
        OperatingSystem operatingSystemCache = OperatingSystem.NONE;
        if (null != operatingSystem && OperatingSystem.NONE != operatingSystem && OperatingSystem.NOT_FOUND != operatingSystem) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("operating_system").append("=").append(operatingSystem.getApiString());
            operatingSystemCache = operatingSystem;
        }
        LibCType libcTypeCache = LibCType.NONE;
        if (null != libcType && LibCType.NONE != libcType && LibCType.NOT_FOUND != libcType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("libc_type").append("=").append(libcType.getApiString());
            libcTypeCache = libcType;
        }
        Architecture architectureCache = Architecture.NONE;
        if (null != architecture && Architecture.NONE != architecture && Architecture.NOT_FOUND != architecture) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("architecture").append("=").append(architecture.getApiString());
            architectureCache = architecture;
        }
        Bitness bitnessCache = Bitness.NONE;
        if (null != bitness && Bitness.NONE != bitness && Bitness.NOT_FOUND != bitness) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("bitness").append("=").append(bitness.getApiString());
            bitnessCache = bitness;
        }
        ArchiveType archiveTypeCache = ArchiveType.NONE;
        if (null != archiveType && ArchiveType.NONE != archiveType && ArchiveType.NOT_FOUND != archiveType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("archive_type").append("=").append(archiveType.getApiString());
            archiveTypeCache = archiveType;
        }
        PackageType packageTypeCache = PackageType.NONE;
        if (null != packageType && PackageType.NONE != packageType && PackageType.NOT_FOUND != packageType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("package_type").append("=").append(packageType.getApiString());
            packageTypeCache = packageType;
        }
        Scope scopeCache = Scope.PUBLIC;
        if (null != scope && Scope.NONE != scope && Scope.NOT_FOUND != scope) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("discovery_scope_id").append("=").append(scope.getApiString());
            scopeCache = scope;
        }
        if (null != javafxBundled) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("javafx_bundled").append("=").append(javafxBundled);
        }
        if (null != directlyDownloadable) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("directly_downloadable").append("=").append(directlyDownloadable);
        }
        ReleaseStatus releaseStatusCache = ReleaseStatus.NONE;
        if (null != releaseStatus && ReleaseStatus.NONE != releaseStatus && ReleaseStatus.NOT_FOUND != releaseStatus) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("release_status").append("=").append(releaseStatus.getApiString());
            releaseStatusCache = releaseStatus;
        }
        TermOfSupport termOfSupportCache = TermOfSupport.NONE;
        if (null != termOfSupport && TermOfSupport.NONE != termOfSupport && TermOfSupport.NOT_FOUND != termOfSupport) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("term_of_support").append("=").append(termOfSupport.getApiString());
            termOfSupportCache = termOfSupport;
        }
        if ((query = queryBuilder.toString()).isEmpty()) {
            return new ArrayList<Pkg>();
        }
        if (this.cacheReady.get()) {
            return this.getPkgsFromCache(versionNumber, Comparison.EQUAL, Distribution.NONE == distributionCache ? new ArrayList() : Arrays.asList(distributionCache), Architecture.NONE == architectureCache ? new ArrayList() : Arrays.asList(architectureCache), ArchiveType.NONE == archiveTypeCache ? new ArrayList() : Arrays.asList(archiveTypeCache), packageTypeCache, OperatingSystem.NONE == operatingSystemCache ? new ArrayList() : Arrays.asList(operatingSystemCache), LibCType.NONE == libcTypeCache ? new ArrayList() : Arrays.asList(libcTypeCache), ReleaseStatus.NONE == releaseStatusCache ? new ArrayList() : Arrays.asList(releaseStatusCache), TermOfSupport.NONE == termOfSupportCache ? new ArrayList() : Arrays.asList(termOfSupportCache), bitnessCache, javafxBundled, directlyDownloadable, latestCache, Scope.NONE == scopeCache ? new ArrayList<Scope>() : Arrays.asList(scopeCache));
        }
        LinkedList<Pkg> pkgs = new LinkedList<Pkg>();
        String bodyText = Helper.get(query);
        ArrayList<Pkg> pkgsFound = new ArrayList<Pkg>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject pkgJsonObj = jsonArray.get(i).getAsJsonObject();
                pkgsFound.add(new Pkg(pkgJsonObj.toString()));
            }
        }
        pkgs.addAll(pkgsFound);
        HashSet unique = new HashSet(pkgs);
        pkgs = new LinkedList(unique);
        return pkgs;
    }

    public CompletableFuture<List<Pkg>> getPkgsAsync(Distribution distribution, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, LibCType libCType, Architecture architecture, Bitness bitness, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable, ReleaseStatus releaseStatus, TermOfSupport termOfSupport, Scope scope) {
        String query;
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/packages");
        int initialLength = queryBuilder.length();
        Distribution distributionCache = Distribution.NONE;
        if (null != distribution && Distribution.NONE != distribution && Distribution.NOT_FOUND != distribution) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("distro").append("=").append(distribution.getApiString());
            distributionCache = distribution;
        }
        if (null != versionNumber) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("version").append("=").append(versionNumber.toString(OutputFormat.REDUCED, true, true));
        }
        Latest latestCache = Latest.NONE;
        if (null != latest && Latest.NONE != latest && Latest.NOT_FOUND != latest) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("latest").append("=").append(latest.getApiString());
            latestCache = latest;
        }
        OperatingSystem operatingSystemCache = OperatingSystem.NONE;
        if (null != operatingSystem && OperatingSystem.NONE != operatingSystem && OperatingSystem.NOT_FOUND != operatingSystem) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("operating_system").append("=").append(operatingSystem.getApiString());
            operatingSystemCache = operatingSystem;
        }
        LibCType libcTypeCache = LibCType.NONE;
        if (null != libCType && LibCType.NONE != libCType && LibCType.NOT_FOUND != libCType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("libc_type").append("=").append(libCType.getApiString());
            libcTypeCache = libCType;
        }
        Architecture architectureCache = Architecture.NONE;
        if (null != architecture && Architecture.NONE != architecture && Architecture.NOT_FOUND != architecture) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("architecture").append("=").append(architecture.getApiString());
            architectureCache = architecture;
        }
        Bitness bitnessCache = Bitness.NONE;
        if (null != bitness && Bitness.NONE != bitness && Bitness.NOT_FOUND != bitness) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("bitness").append("=").append(bitness.getApiString());
            bitnessCache = bitness;
        }
        ArchiveType archiveTypeCache = ArchiveType.NONE;
        if (null != archiveType && ArchiveType.NONE != archiveType && ArchiveType.NOT_FOUND != archiveType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("archive_type").append("=").append(archiveType.getApiString());
            archiveTypeCache = archiveType;
        }
        PackageType packageTypeCache = PackageType.NONE;
        if (null != packageType && PackageType.NONE != packageType && PackageType.NOT_FOUND != packageType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("package_type").append("=").append(packageType.getApiString());
            packageTypeCache = packageType;
        }
        Scope scopeCache = Scope.PUBLIC;
        if (null != scope && Scope.NONE != scope && Scope.NOT_FOUND != scope) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("discovery_scope_id").append("=").append(scope.getApiString());
            scopeCache = scope;
        }
        if (null != javafxBundled) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("javafx_bundled").append("=").append(javafxBundled);
        }
        if (null != directlyDownloadable) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("directly_downloadable").append("=").append(directlyDownloadable);
        }
        ReleaseStatus releaseStatusCache = ReleaseStatus.NONE;
        if (null != releaseStatus && ReleaseStatus.NONE != releaseStatus && ReleaseStatus.NOT_FOUND != releaseStatus) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("release_status").append("=").append(releaseStatus.getApiString());
            releaseStatusCache = releaseStatus;
        }
        TermOfSupport termOfSupportCache = TermOfSupport.NONE;
        if (null != termOfSupport && TermOfSupport.NONE != termOfSupport && TermOfSupport.NOT_FOUND != termOfSupport) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("term_of_support").append("=").append(termOfSupport.getApiString());
            termOfSupportCache = termOfSupport;
        }
        if ((query = queryBuilder.toString()).isEmpty()) {
            return new CompletableFuture<List<Pkg>>();
        }
        if (this.cacheReady.get()) {
            CompletableFuture<List<Pkg>> future = new CompletableFuture<List<Pkg>>();
            future.complete(this.getPkgsFromCache(versionNumber, Comparison.EQUAL, Distribution.NONE == distributionCache ? new ArrayList() : Arrays.asList(distributionCache), Architecture.NONE == architectureCache ? new ArrayList() : Arrays.asList(architectureCache), ArchiveType.NONE == archiveTypeCache ? new ArrayList() : Arrays.asList(archiveTypeCache), packageTypeCache, OperatingSystem.NONE == operatingSystemCache ? new ArrayList() : Arrays.asList(operatingSystemCache), LibCType.NONE == libcTypeCache ? new ArrayList() : Arrays.asList(libcTypeCache), ReleaseStatus.NONE == releaseStatusCache ? new ArrayList() : Arrays.asList(releaseStatusCache), TermOfSupport.NONE == termOfSupportCache ? new ArrayList() : Arrays.asList(termOfSupportCache), bitnessCache, javafxBundled, directlyDownloadable, latestCache, Scope.NONE == scopeCache ? new ArrayList<Scope>() : Arrays.asList(scopeCache)));
            return future;
        }
        return Helper.getAsync(query).thenApply(bodyText -> {
            LinkedList pkgs = new LinkedList();
            ArrayList<Pkg> pkgsFound = new ArrayList<Pkg>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject pkgJsonObj = jsonArray.get(i).getAsJsonObject();
                    pkgsFound.add(new Pkg(pkgJsonObj.toString()));
                }
            }
            pkgs.addAll(pkgsFound);
            HashSet unique = new HashSet(pkgs);
            pkgs = new LinkedList(unique);
            return pkgs;
        });
    }

    public String getPkgsAsJson(Distribution distribution, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, LibCType libcType, Architecture architecture, Bitness bitness, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable, ReleaseStatus releaseStatus, TermOfSupport termOfSupport, Scope scope) {
        return this.getPkgs(distribution, versionNumber, latest, operatingSystem, libcType, architecture, bitness, archiveType, packageType, javafxBundled, directlyDownloadable, releaseStatus, termOfSupport, scope).toString();
    }

    public CompletableFuture<String> getPkgsAsJsonAsync(Distribution distribution, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, LibCType libcType, Architecture architecture, Bitness bitness, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable, ReleaseStatus releaseStatus, TermOfSupport termOfSupport, Scope scope) {
        return this.getPkgsAsync(distribution, versionNumber, latest, operatingSystem, libcType, architecture, bitness, archiveType, packageType, javafxBundled, directlyDownloadable, releaseStatus, termOfSupport, scope).thenApply(pkgs -> pkgs.toString());
    }

    public final MajorVersion getMajorVersion(String parameter) {
        String query;
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions");
        if (null != parameter || !parameter.isEmpty()) {
            queryBuilder.append("/").append(parameter);
        }
        if ((query = queryBuilder.toString()).isEmpty()) {
            LOGGER.debug("No major version found for given parameter {}.", (Object)parameter);
            return null;
        }
        Gson gson = new Gson();
        String bodyText = Helper.get(query);
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject json = element.getAsJsonObject();
            MajorVersion majorVersion = new MajorVersion(json.toString());
            return majorVersion;
        }
        return null;
    }

    public final CompletableFuture<MajorVersion> getMajorVersionAsync(String parameter) {
        String query;
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions");
        if (null != parameter || !parameter.isEmpty()) {
            queryBuilder.append("/").append(parameter);
        }
        if ((query = queryBuilder.toString()).isEmpty()) {
            LOGGER.debug("No major version found for given parameter {}.", (Object)parameter);
            return null;
        }
        return Helper.getAsync(query).thenApply(bodyText -> {
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject json = element.getAsJsonObject();
                MajorVersion majorVersion = new MajorVersion(json.toString());
                return majorVersion;
            }
            return null;
        });
    }

    public final Queue<MajorVersion> getAllMajorVersions() {
        return this.getAllMajorVersions(false);
    }

    public final Queue<MajorVersion> getAllMajorVersions(boolean include_ea) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions").append("?ea=").append(include_ea);
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query);
        ConcurrentLinkedQueue<MajorVersion> majorVersionsFound = new ConcurrentLinkedQueue<MajorVersion>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
            }
        }
        return majorVersionsFound;
    }

    public final List<MajorVersion> getAllMajorVersions(Optional<Boolean> maintained, Optional<Boolean> includingEA, Optional<Boolean> includingGA) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions");
        int initialLength = queryBuilder.length();
        if (null != maintained && maintained.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("maintained=").append(maintained.get());
        }
        if (null != includingEA && includingEA.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("ea=").append(includingEA.get());
        }
        if (null != includingGA && includingGA.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("ga=").append(includingGA.get());
        }
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query);
        ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
            }
        }
        return majorVersionsFound;
    }

    public final CompletableFuture<List<MajorVersion>> getAllMajorVersionsAsync() {
        return this.getAllMajorVersionsAsync(false);
    }

    public final CompletableFuture<List<MajorVersion>> getAllMajorVersionsAsync(boolean include_ea) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions").append("?ea=").append(include_ea);
        String query = queryBuilder.toString();
        return Helper.getAsync(query).thenApply(bodyText -> {
            CopyOnWriteArrayList<MajorVersion> majorVersionsFound = new CopyOnWriteArrayList<MajorVersion>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                    majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
                }
            }
            return majorVersionsFound;
        });
    }

    public final CompletableFuture<List<MajorVersion>> getAllMajorVersionsAsync(Optional<Boolean> maintained, Optional<Boolean> includingEA, Optional<Boolean> includingGA) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions");
        int initialLength = queryBuilder.length();
        if (null != maintained && maintained.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("maintained=").append(maintained.get());
        }
        if (null != includingEA && includingEA.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("ea=").append(includingEA.get());
        }
        if (null != includingGA && includingGA.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("ga=").append(includingGA.get());
        }
        String query = queryBuilder.toString();
        return Helper.getAsync(query).thenApply(bodyText -> {
            ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                    majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
                }
            }
            return majorVersionsFound;
        });
    }

    public final MajorVersion getMajorVersion(int featureVersion, boolean include_ea) {
        Gson gson = new Gson();
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions").append("?include_ea=").append(include_ea);
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query);
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject json = jsonArray.get(i).getAsJsonObject();
                MajorVersion majorVersion = new MajorVersion(json.toString());
                if (majorVersion.getAsInt() != featureVersion) continue;
                return majorVersion;
            }
            return null;
        }
        return null;
    }

    public final CompletableFuture<MajorVersion> getMajorVersionAsync(int featureVersion, boolean include_ea) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions").append("?include_ea=").append(include_ea);
        String query = queryBuilder.toString();
        return Helper.getAsync(query).thenApply(bodyText -> {
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject json = jsonArray.get(i).getAsJsonObject();
                    MajorVersion majorVersion = new MajorVersion(json.toString());
                    if (majorVersion.getAsInt() != featureVersion) continue;
                    return majorVersion;
                }
                return null;
            }
            return null;
        });
    }

    public final String getMajorVersionAsJson(String parameter) {
        MajorVersion majorVersion = this.getMajorVersion(parameter);
        if (null == majorVersion) {
            return "{" + "\n" + "  \"value\"" + ":" + "\"" + majorVersion + "\"" + "," + "\n" + "  \"detail\"" + ":" + "\"Requested release has wrong format or is null.\"" + "," + "\n" + "  \"supported\"" + ":" + "\"1 - next early access" + ",current, last, latest, next, prev, last_lts, latest_lts, last_mts, latest_mts, last_sts, latest_mts, next_lts, next_mts, next_sts\"" + "\n" + "}";
        }
        return majorVersion.toString();
    }

    public final CompletableFuture<String> getMajorVersionAsJsonAsync(String parameter) {
        return this.getMajorVersionAsync(parameter).thenApply(majorVersion -> {
            if (null == majorVersion) {
                return "{" + "\n" + "  \"value\"" + ":" + "\"" + majorVersion + "\"" + "," + "\n" + "  \"detail\"" + ":" + "\"Requested release has wrong format or is null.\"" + "," + "\n" + "  \"supported\"" + ":" + "\"1 - next early access" + ",current, last, latest, next, prev, last_lts, latest_lts, last_mts, latest_mts, last_sts, latest_mts, next_lts, next_mts, next_sts\"" + "\n" + "}";
            }
            return majorVersion.toString();
        });
    }

    public final List<MajorVersion> getMaintainedMajorVersions() {
        return this.getMaintainedMajorVersions(false);
    }

    public final List<MajorVersion> getMaintainedMajorVersions(boolean include_ea) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions").append("?maintained=true&ga=true").append(include_ea ? "&ea=true" : "").append(include_ea);
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query);
        ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
            }
        }
        return majorVersionsFound;
    }

    public final CompletableFuture<List<MajorVersion>> getMaintainedMajorVersionsAsync() {
        return this.getMaintainedMajorVersionsAsync(false);
    }

    public final CompletableFuture<List<MajorVersion>> getMaintainedMajorVersionsAsync(boolean include_ea) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions").append("?maintained=true&ga=true").append(include_ea ? "&ea=true" : "").append(include_ea);
        String query = queryBuilder.toString();
        return Helper.getAsync(query).thenApply(bodyText -> {
            ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                    majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
                }
            }
            return majorVersionsFound;
        });
    }

    public final List<MajorVersion> getUsefulMajorVersions() {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions").append("/useful");
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query);
        ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
            }
        }
        return majorVersionsFound;
    }

    public final CompletableFuture<List<MajorVersion>> getUsefulMajorVersionsAsync() {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/major_versions").append("/useful");
        String query = queryBuilder.toString();
        return Helper.getAsync(query).thenApply(bodyText -> {
            ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                    majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
                }
            }
            return majorVersionsFound;
        });
    }

    public final MajorVersion getLatestLts(boolean including_ea) {
        Queue<MajorVersion> majorVersions = this.getAllMajorVersions(including_ea);
        return majorVersions.stream().filter(majorVersion -> TermOfSupport.LTS == majorVersion.getTermOfSupport()).filter(majorVersion -> including_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get();
    }

    public final CompletableFuture<MajorVersion> getLatestLtsAsync(boolean including_ea) {
        return this.getAllMajorVersionsAsync(including_ea).thenApply(majorVersions -> majorVersions.stream().filter(majorVersion -> TermOfSupport.LTS == majorVersion.getTermOfSupport()).filter(majorVersion -> including_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get());
    }

    public final MajorVersion getLatestMts(boolean including_ea) {
        Queue<MajorVersion> majorVersions = this.getAllMajorVersions(including_ea);
        return majorVersions.stream().filter(majorVersion -> TermOfSupport.MTS == majorVersion.getTermOfSupport()).filter(majorVersion -> including_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get();
    }

    public final CompletableFuture<MajorVersion> getLatestMtsAsync(boolean including_ea) {
        return this.getAllMajorVersionsAsync(including_ea).thenApply(majorVersions -> majorVersions.stream().filter(majorVersion -> TermOfSupport.MTS == majorVersion.getTermOfSupport()).filter(majorVersion -> including_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get());
    }

    public final MajorVersion getLatestSts(boolean including_ea) {
        Queue<MajorVersion> majorVersions = this.getAllMajorVersions(including_ea);
        return majorVersions.stream().filter(majorVersion -> TermOfSupport.LTS != majorVersion.getTermOfSupport()).filter(majorVersion -> including_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get();
    }

    public final CompletableFuture<MajorVersion> getLatestStsAsync(boolean including_ea) {
        return this.getAllMajorVersionsAsync(including_ea).thenApply(majorVersions -> majorVersions.stream().filter(majorVersion -> TermOfSupport.LTS != majorVersion.getTermOfSupport()).filter(majorVersion -> including_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get());
    }

    public final List<Pkg> updateAvailableFor(Distribution distribution, SemVer semVer, Architecture architecture, Boolean javafxBundled) {
        List<Pkg> pkgs = this.getPkgs(distribution, semVer.getVersionNumber(), Latest.OVERALL, this.getOperatingSystem(), LibCType.NONE, architecture, Bitness.NONE, ArchiveType.NONE, PackageType.JDK, javafxBundled, Boolean.TRUE, semVer.getReleaseStatus(), TermOfSupport.NONE, Scope.PUBLIC);
        List<Pkg> updatesFound = new ArrayList<Pkg>();
        if (pkgs.isEmpty()) {
            return updatesFound;
        }
        Pkg firstEntry = pkgs.get(0);
        SemVer semVerFound = firstEntry.getJavaVersion();
        if (semVerFound.compareTo(semVer) > 0) {
            updatesFound = pkgs.stream().filter(pkg -> pkg.getJavaVersion().compareTo(semVerFound) == 0).collect(Collectors.toList());
        }
        return updatesFound;
    }

    public final CompletableFuture<List<Pkg>> updateAvailableForAsync(Distribution distribution, SemVer semVer, Architecture architecture, Boolean javafxBundled) {
        return this.getPkgsAsync(distribution, semVer.getVersionNumber(), Latest.OVERALL, this.getOperatingSystem(), LibCType.NONE, architecture, Bitness.NONE, ArchiveType.NONE, PackageType.JDK, javafxBundled, Boolean.TRUE, semVer.getReleaseStatus(), TermOfSupport.NONE, Scope.PUBLIC).thenApply(pkgs -> {
            List<Object> updatesFound = new ArrayList();
            if (pkgs.isEmpty()) {
                return updatesFound;
            }
            Pkg firstEntry = (Pkg)pkgs.get(0);
            SemVer semVerFound = firstEntry.getJavaVersion();
            if (semVerFound.compareTo(semVer) > 0) {
                updatesFound = pkgs.stream().filter(pkg -> pkg.getJavaVersion().compareTo(semVerFound) == 0).collect(Collectors.toList());
            }
            return updatesFound;
        });
    }

    public final List<Distribution> getDistributionsThatSupportVersion(String version) {
        SemVer semver = SemVer.fromText(version).getSemVer1();
        if (null == semver) {
            LOGGER.debug("Error parsing version string {} to semver", (Object)version);
            return new ArrayList<Distribution>();
        }
        return this.getDistributionsThatSupportVersion(semver);
    }

    public final List<Distribution> getDistributionsThatSupportVersion(SemVer semVer) {
        return this.getDistributionsForSemVer(semVer);
    }

    public final CompletableFuture<List<Distribution>> getDistributionsThatSupportSemVerAsync(SemVer semVer) {
        return this.getDistributionsForSemVerAsync(semVer);
    }

    public final CompletableFuture<List<Distribution>> getDistributionsThatSupportVersionAsync(String version) {
        return this.getDistributionsThatSupportVersionAsync(VersionNumber.fromText(version));
    }

    public final CompletableFuture<List<Distribution>> getDistributionsThatSupportVersionAsync(VersionNumber versionNumber) {
        return this.getDistributionsForVersionAsync(versionNumber);
    }

    public final List<Distribution> getDistributionsThatSupportVersion(VersionNumber versionNumber) {
        return this.getDistributionsForVersion(versionNumber);
    }

    public final List<Distribution> getDistributionsThatSupport(SemVer semVer, OperatingSystem operatingSystem, Architecture architecture, LibCType libcType, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable) {
        return this.getPkgs(Distribution.NONE, semVer.getVersionNumber(), Latest.NONE, operatingSystem, libcType, architecture, Bitness.NONE, archiveType, packageType, javafxBundled, directlyDownloadable, semVer.getReleaseStatus(), TermOfSupport.NONE, Scope.PUBLIC).stream().map(pkg -> pkg.getDistribution()).distinct().collect(Collectors.toList());
    }

    public final CompletableFuture<List<Distribution>> getDistributionsThatSupportAsync(SemVer semVer, OperatingSystem operatingSystem, Architecture architecture, LibCType libcType, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable) {
        return this.getPkgsAsync(Distribution.NONE, semVer.getVersionNumber(), Latest.NONE, operatingSystem, libcType, architecture, Bitness.NONE, archiveType, packageType, javafxBundled, directlyDownloadable, semVer.getReleaseStatus(), TermOfSupport.NONE, Scope.PUBLIC).thenApply(pkgs -> pkgs.stream().map(pkg -> pkg.getDistribution()).distinct().collect(Collectors.toList()));
    }

    public final List<Distribution> getDistributions() {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/distributions");
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query);
        LinkedList<Distribution> distributionsFound = new LinkedList<Distribution>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                distributionsFound.add(Distribution.fromText(api_parameter));
            }
        }
        return distributionsFound;
    }

    public final CompletableFuture<List<Distribution>> getDistributionsAsync() {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/distributions");
        String query = queryBuilder.toString();
        return Helper.getAsync(query).thenApply(bodyText -> {
            LinkedList<Distribution> distributionsFound = new LinkedList<Distribution>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                    String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                    distributionsFound.add(Distribution.fromText(api_parameter));
                }
            }
            return distributionsFound;
        });
    }

    public final List<Distribution> getDistributionsForSemVer(SemVer semVer) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/distributions").append("/versions/").append(semVer.toString());
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query);
        LinkedList<Distribution> distributionsFound = new LinkedList<Distribution>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                distributionsFound.add(Distribution.fromText(api_parameter));
            }
        }
        return distributionsFound;
    }

    public final CompletableFuture<List<Distribution>> getDistributionsForSemVerAsync(SemVer semVer) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/distributions").append("/versions/").append(semVer.toString());
        String query = queryBuilder.toString();
        return Helper.getAsync(query).thenApply(bodyText -> {
            LinkedList<Distribution> distributionsFound = new LinkedList<Distribution>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                    String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                    distributionsFound.add(Distribution.fromText(api_parameter));
                }
            }
            return distributionsFound;
        });
    }

    public final List<Distribution> getDistributionsForVersion(VersionNumber versionNumber) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/distributions").append("/versions/").append(versionNumber.toString());
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query);
        LinkedList<Distribution> distributionsFound = new LinkedList<Distribution>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                distributionsFound.add(Distribution.fromText(api_parameter));
            }
        }
        return distributionsFound;
    }

    public final CompletableFuture<List<Distribution>> getDistributionsForVersionAsync(VersionNumber versionNumber) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/distributions").append("/versions/").append(versionNumber.toString());
        String query = queryBuilder.toString();
        return Helper.getAsync(query).thenApply(bodyText -> {
            LinkedList<Distribution> distributionsFound = new LinkedList<Distribution>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                    String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                    distributionsFound.add(Distribution.fromText(api_parameter));
                }
            }
            return distributionsFound;
        });
    }

    public static Map<Distribution, List<VersionNumber>> getVersionsPerDistribution() {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/distributions");
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query);
        LinkedHashMap<Distribution, List<VersionNumber>> distributionsFound = new LinkedHashMap<Distribution, List<VersionNumber>>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonArray) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                Distribution distribution = Distribution.fromText(api_parameter);
                LinkedList<VersionNumber> versions = new LinkedList<VersionNumber>();
                JsonArray versionsArray = distributionJsonObj.get("versions").getAsJsonArray();
                for (int j = 0; j < versionsArray.size(); ++j) {
                    VersionNumber versionNumber = VersionNumber.fromText(versionsArray.get(j).getAsString());
                    versions.add(versionNumber);
                }
                distributionsFound.put(distribution, versions);
            }
        }
        return distributionsFound;
    }

    public static CompletableFuture<Map<Distribution, List<VersionNumber>>> getVersionsPerDistributionAsync() {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/distributions");
        String query = queryBuilder.toString();
        return Helper.getAsync(query).thenApply(bodyText -> {
            LinkedHashMap distributionsFound = new LinkedHashMap();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
            if (element instanceof JsonArray) {
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                    String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                    Distribution distribution = Distribution.fromText(api_parameter);
                    LinkedList<VersionNumber> versions = new LinkedList<VersionNumber>();
                    JsonArray versionsArray = distributionJsonObj.get("versions").getAsJsonArray();
                    for (int j = 0; j < versionsArray.size(); ++j) {
                        VersionNumber versionNumber = VersionNumber.fromText(versionsArray.get(j).getAsString());
                        versions.add(versionNumber);
                    }
                    distributionsFound.put(distribution, versions);
                }
            }
            return distributionsFound;
        });
    }

    public List<Distribution> getDistributionsBasedOnOpenJDK() {
        return Distribution.getDistributionsBasedOnOpenJDK();
    }

    public List<Distribution> getDistributionsBasedOnGraalVm() {
        return Distribution.getDistributionsBasedOnGraalVm();
    }

    public final String getPkgDirectDownloadUri(String id, SemVer javaVersion) {
        return this.getPkgInfo(id, javaVersion).getDirectDownloadUri();
    }

    public final CompletableFuture<String> getPkgDirectDownloadUriAsync(String id, SemVer javaVersion) {
        return this.getPkgInfoAsync(id, javaVersion).thenApply(pkgInfo -> pkgInfo.getDirectDownloadUri());
    }

    public PkgInfo getPkgInfo(String ephemeralId, SemVer javaVersion) {
        Gson packageInfoGson = new Gson();
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/ephemeral_ids").append("/").append(ephemeralId);
        String query = queryBuilder.toString();
        String packageInfoBody = Helper.get(query);
        JsonElement packageInfoElement = (JsonElement)packageInfoGson.fromJson(packageInfoBody, JsonElement.class);
        if (packageInfoElement instanceof JsonObject) {
            JsonObject packageInfoJson = packageInfoElement.getAsJsonObject();
            String filename = packageInfoJson.get("filename").getAsString();
            String directDownloadUri = packageInfoJson.get("direct_download_uri").getAsString();
            String downloadSiteUri = packageInfoJson.get("download_site_uri").getAsString();
            return new PkgInfo(filename, javaVersion, directDownloadUri, downloadSiteUri);
        }
        return null;
    }

    public CompletableFuture<PkgInfo> getPkgInfoAsync(String ephemeralId, SemVer javaVersion) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/ephemeral_ids").append("/").append(ephemeralId);
        String query = queryBuilder.toString();
        return Helper.getAsync(query).thenApply(packageInfoBody -> {
            Gson packageInfoGson = new Gson();
            JsonElement packageInfoElement = (JsonElement)packageInfoGson.fromJson(packageInfoBody, JsonElement.class);
            if (packageInfoElement instanceof JsonObject) {
                JsonObject packageInfoJson = packageInfoElement.getAsJsonObject();
                String filename = packageInfoJson.get("filename").getAsString();
                String directDownloadUri = packageInfoJson.get("direct_download_uri").getAsString();
                String downloadSiteUri = packageInfoJson.get("download_site_uri").getAsString();
                return new PkgInfo(filename, javaVersion, directDownloadUri, downloadSiteUri);
            }
            return null;
        });
    }

    public final Future<?> downloadPkg(String pkgId, String targetFileName) {
        Pkg pkg = this.getPkg(pkgId);
        if (null == pkg) {
            return null;
        }
        SemVer javaVersion = pkg.getJavaVersion();
        String ephemeralId = pkg.getEphemeralId();
        return this.downloadPkg(ephemeralId, javaVersion, targetFileName);
    }

    public final Future<?> downloadPkg(String ephemeralId, SemVer javaVersion, String targetFileName) {
        String url = this.getPkgInfo(ephemeralId, javaVersion).getDirectDownloadUri();
        FutureTask<Boolean> task = this.createTask(targetFileName, url);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(task);
        executor.shutdown();
        return future;
    }

    public final Future<?> downloadPkg(PkgInfo pkgInfo, String targetFileName) {
        FutureTask<Boolean> task = this.createTask(targetFileName, pkgInfo.getDirectDownloadUri());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(task);
        executor.shutdown();
        return future;
    }

    public Pkg getPkg(String pkgId) {
        if (this.cacheReady.get()) {
            return this.pkgCache.stream().filter(pkg -> pkg.getId().equals(pkgId)).findFirst().orElse(null);
        }
        Gson pkgGson = new Gson();
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/packages").append("/").append(pkgId);
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query);
        JsonElement pkgElement = (JsonElement)pkgGson.fromJson(bodyText, JsonElement.class);
        if (pkgElement instanceof JsonObject) {
            return new Pkg(pkgElement.getAsJsonObject().toString());
        }
        return null;
    }

    public CompletableFuture<Pkg> getPkgAsync(String pkgId) {
        StringBuilder queryBuilder = new StringBuilder().append(DiscoClient.getDiscoApiUrl()).append("/disco/v1.0/packages").append("/").append(pkgId);
        String query = queryBuilder.toString();
        if (this.cacheReady.get()) {
            CompletableFuture<Pkg> future = new CompletableFuture<Pkg>();
            future.complete(this.pkgCache.stream().filter(pkg -> pkg.getId().equals(pkgId)).findFirst().orElse(null));
            return future;
        }
        return Helper.getAsync(query).thenApply(bodyText -> {
            Gson pkgGson = new Gson();
            JsonElement pkgElement = (JsonElement)pkgGson.fromJson(bodyText, JsonElement.class);
            if (pkgElement instanceof JsonObject) {
                return new Pkg(pkgElement.getAsJsonObject().toString());
            }
            return null;
        });
    }

    public final OperatingSystem getOperatingSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            return OperatingSystem.WINDOWS;
        }
        if (os.indexOf("mac") >= 0) {
            return OperatingSystem.MACOS;
        }
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            return OperatingSystem.LINUX;
        }
        if (os.indexOf("sunos") >= 0) {
            return OperatingSystem.SOLARIS;
        }
        return OperatingSystem.NONE;
    }

    public final List<ArchiveType> getArchiveTypes(OperatingSystem os) {
        switch (os) {
            case WINDOWS: {
                return Arrays.asList(ArchiveType.CAB, ArchiveType.MSI, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case MACOS: {
                return Arrays.asList(ArchiveType.DMG, ArchiveType.PKG, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case LINUX: {
                return Arrays.asList(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case LINUX_MUSL: {
                return Arrays.asList(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case ALPINE_LINUX: {
                return Arrays.asList(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case SOLARIS: {
                return Arrays.asList(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case AIX: {
                return Arrays.asList(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case QNX: {
                return Arrays.asList(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
        }
        return Arrays.stream(ArchiveType.values()).filter(ext -> ArchiveType.NONE != ext).filter(ext -> ArchiveType.NOT_FOUND != ext).collect(Collectors.toList());
    }

    private final FutureTask<Boolean> createTask(String fileName, String url) {
        return new FutureTask<Boolean>(() -> {
            try {
                URLConnection connection = new URL(url).openConnection();
                int fileSize = connection.getContentLength();
                this.fireEvt(new DownloadEvt((Object)this, DownloadEvt.DOWNLOAD_STARTED, fileSize));
                ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
                ReadableConsumerByteChannel rcbc = new ReadableConsumerByteChannel(rbc, b -> this.fireEvt(new DownloadEvt((Object)this, DownloadEvt.DOWNLOAD_PROGRESS, (long)fileSize, b)));
                FileOutputStream fos = new FileOutputStream(fileName);
                fos.getChannel().transferFrom(rcbc, 0L, Long.MAX_VALUE);
                fos.close();
                rcbc.close();
                rbc.close();
                this.fireEvt(new DownloadEvt((Object)this, DownloadEvt.DOWNLOAD_FINISHED, fileSize));
                return true;
            }
            catch (IOException ex) {
                this.fireEvt(new DownloadEvt((Object)this, DownloadEvt.DOWNLOAD_FAILED, 0L));
                return false;
            }
        });
    }

    private static final String getDiscoApiUrl() {
        try {
            String url = PropertyManager.INSTANCE.getString("url");
            return null == url ? "https://api.foojay.io" : url;
        }
        catch (Exception e) {
            return "https://api.foojay.io";
        }
    }

    public List<Pkg> getPkgsFromCache(VersionNumber versionNumber, Comparison comparison, List<Distribution> distributions, List<Architecture> architectures, List<ArchiveType> archiveTypes, PackageType packageType, List<OperatingSystem> operatingSystems, List<LibCType> libCTypes, List<ReleaseStatus> releaseStatus, List<TermOfSupport> termsOfSupport, Bitness bitness, Boolean javafxBundled, Boolean directlyDownloadable, Latest latest, List<Scope> scopes) {
        List<Object> pkgsFound;
        if (Comparison.EQUAL == comparison) {
            switch (latest) {
                case OVERALL: {
                    VersionNumber maxNumber;
                    if (null == versionNumber || !versionNumber.getFeature().isPresent()) {
                        Optional<Pkg> pkgWithMaxVersionNumber = this.pkgCache.stream().filter(pkg -> distributions.isEmpty() ? pkg.getDistribution() != null && pkg.getDistribution() != Distribution.GRAALVM_CE8 && pkg.getDistribution() != Distribution.GRAALVM_CE11 && pkg.getDistribution() != Distribution.LIBERICA_NATIVE && pkg.getDistribution() != Distribution.MANDREL : distributions.contains(pkg.getDistribution())).filter(pkg -> Constants.SCOPE_LOOKUP.get(pkg.getDistribution()).stream().anyMatch(scopes.stream().collect(Collectors.toSet())::contains)).filter(pkg -> architectures.isEmpty() ? pkg.getArchitecture() != null : architectures.contains(pkg.getArchitecture())).filter(pkg -> archiveTypes.isEmpty() ? pkg.getArchiveType() != null : archiveTypes.contains(pkg.getArchiveType())).filter(pkg -> operatingSystems.isEmpty() ? pkg.getOperatingSystem() != null : operatingSystems.contains(pkg.getOperatingSystem())).filter(pkg -> libCTypes.isEmpty() ? pkg.getLibCType() != null : libCTypes.contains(pkg.getLibCType())).filter(pkg -> termsOfSupport.isEmpty() ? pkg.getTermOfSupport() != null : termsOfSupport.contains(pkg.getTermOfSupport())).filter(pkg -> PackageType.NONE == packageType ? pkg.getPackageType() != packageType : pkg.getPackageType() == packageType).filter(pkg -> releaseStatus.isEmpty() ? pkg.getReleaseStatus() != null : releaseStatus.contains(pkg.getReleaseStatus())).filter(pkg -> Bitness.NONE == bitness ? pkg.getBitness() != bitness : pkg.getBitness() == bitness).filter(pkg -> null == javafxBundled ? pkg.isJavaFXBundled() != null : pkg.isJavaFXBundled() == javafxBundled).filter(pkg -> null == directlyDownloadable ? pkg.isDirectlyDownloadable() != null : pkg.isDirectlyDownloadable() == directlyDownloadable).max(Comparator.comparing(pkg -> pkg.getJavaVersion().getVersionNumber()));
                        maxNumber = pkgWithMaxVersionNumber.isPresent() ? pkgWithMaxVersionNumber.get().getJavaVersion().getVersionNumber() : versionNumber;
                    } else {
                        int featureVersion = versionNumber.getFeature().getAsInt();
                        Optional<Pkg> pkgWithMaxVersionNumber = this.pkgCache.stream().filter(pkg -> distributions.isEmpty() ? pkg.getDistribution() != null : distributions.contains(pkg.getDistribution())).filter(pkg -> Constants.SCOPE_LOOKUP.get(pkg.getDistribution()).stream().anyMatch(scopes.stream().collect(Collectors.toSet())::contains)).filter(pkg -> architectures.isEmpty() ? pkg.getArchitecture() != null : architectures.contains(pkg.getArchitecture())).filter(pkg -> archiveTypes.isEmpty() ? pkg.getArchiveType() != null : archiveTypes.contains(pkg.getArchiveType())).filter(pkg -> operatingSystems.isEmpty() ? pkg.getOperatingSystem() != null : operatingSystems.contains(pkg.getOperatingSystem())).filter(pkg -> libCTypes.isEmpty() ? pkg.getLibCType() != null : libCTypes.contains(pkg.getLibCType())).filter(pkg -> termsOfSupport.isEmpty() ? pkg.getTermOfSupport() != null : termsOfSupport.contains(pkg.getTermOfSupport())).filter(pkg -> PackageType.NONE == packageType ? pkg.getPackageType() != packageType : pkg.getPackageType() == packageType).filter(pkg -> releaseStatus.isEmpty() ? pkg.getReleaseStatus() != null : releaseStatus.contains(pkg.getReleaseStatus())).filter(pkg -> Bitness.NONE == bitness ? pkg.getBitness() != bitness : pkg.getBitness() == bitness).filter(pkg -> null == javafxBundled ? pkg.isJavaFXBundled() != null : pkg.isJavaFXBundled() == javafxBundled).filter(pkg -> null == directlyDownloadable ? pkg.isDirectlyDownloadable() != null : pkg.isDirectlyDownloadable() == directlyDownloadable).filter(pkg -> featureVersion == pkg.getJavaVersion().getVersionNumber().getFeature().getAsInt()).max(Comparator.comparing(pkg -> pkg.getJavaVersion().getVersionNumber()));
                        maxNumber = pkgWithMaxVersionNumber.isPresent() ? pkgWithMaxVersionNumber.get().getJavaVersion().getVersionNumber() : versionNumber;
                    }
                    pkgsFound = this.pkgCache.stream().filter(pkg -> distributions.isEmpty() ? pkg.getDistribution() != null : distributions.contains(pkg.getDistribution())).filter(pkg -> Constants.SCOPE_LOOKUP.get(pkg.getDistribution()).stream().anyMatch(scopes.stream().collect(Collectors.toSet())::contains)).filter(pkg -> architectures.isEmpty() ? pkg.getArchitecture() != null : architectures.contains(pkg.getArchitecture())).filter(pkg -> archiveTypes.isEmpty() ? pkg.getArchiveType() != null : archiveTypes.contains(pkg.getArchiveType())).filter(pkg -> operatingSystems.isEmpty() ? pkg.getOperatingSystem() != null : operatingSystems.contains(pkg.getOperatingSystem())).filter(pkg -> libCTypes.isEmpty() ? pkg.getLibCType() != null : libCTypes.contains(pkg.getLibCType())).filter(pkg -> termsOfSupport.isEmpty() ? pkg.getTermOfSupport() != null : termsOfSupport.contains(pkg.getTermOfSupport())).filter(pkg -> PackageType.NONE == packageType ? pkg.getPackageType() != packageType : pkg.getPackageType() == packageType).filter(pkg -> releaseStatus.isEmpty() ? pkg.getReleaseStatus() != null : releaseStatus.contains(pkg.getReleaseStatus())).filter(pkg -> Bitness.NONE == bitness ? pkg.getBitness() != bitness : pkg.getBitness() == bitness).filter(pkg -> null == javafxBundled ? pkg.isJavaFXBundled() != null : pkg.isJavaFXBundled() == javafxBundled).filter(pkg -> null == directlyDownloadable ? pkg.isDirectlyDownloadable() != null : pkg.isDirectlyDownloadable() == directlyDownloadable).filter(pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(maxNumber) == 0).sorted(Comparator.comparing(Pkg::getDistributionName).reversed().thenComparing(Comparator.comparing(pkg1 -> pkg1.getJavaVersion().getVersionNumber()).reversed())).collect(Collectors.toList());
                    break;
                }
                case PER_DISTRIBUTION: {
                    List<Distribution> distributionsToCheck = distributions.isEmpty() ? Distribution.getAsList().stream().filter(distribution -> Constants.SCOPE_LOOKUP.get(distribution).stream().anyMatch(scopes.stream().collect(Collectors.toSet())::contains)).collect(Collectors.toList()) : distributions.stream().filter(distribution -> Constants.SCOPE_LOOKUP.get(distribution).stream().anyMatch(scopes.stream().collect(Collectors.toSet())::contains)).collect(Collectors.toList());
                    ArrayList pkgsTmp = new ArrayList();
                    ConcurrentHashMap maxVersionPerDistribution = new ConcurrentHashMap();
                    distributionsToCheck.forEach(distro -> {
                        Optional<Pkg> pkgFound = this.pkgCache.stream().filter(pkg -> pkg.getDistribution().equals(distro)).filter(pkg -> architectures.isEmpty() ? pkg.getArchitecture() != null : architectures.contains(pkg.getArchitecture())).filter(pkg -> archiveTypes.isEmpty() ? pkg.getArchiveType() != null : archiveTypes.contains(pkg.getArchiveType())).filter(pkg -> operatingSystems.isEmpty() ? pkg.getOperatingSystem() != null : operatingSystems.contains(pkg.getOperatingSystem())).filter(pkg -> libCTypes.isEmpty() ? pkg.getLibCType() != null : libCTypes.contains(pkg.getLibCType())).filter(pkg -> termsOfSupport.isEmpty() ? pkg.getTermOfSupport() != null : termsOfSupport.contains(pkg.getTermOfSupport())).filter(pkg -> PackageType.NONE == packageType ? pkg.getPackageType() != packageType : pkg.getPackageType() == packageType).filter(pkg -> releaseStatus.isEmpty() ? pkg.getReleaseStatus() != null : releaseStatus.contains(pkg.getReleaseStatus())).filter(pkg -> Bitness.NONE == bitness ? pkg.getBitness() != bitness : pkg.getBitness() == bitness).filter(pkg -> null == javafxBundled ? pkg.isJavaFXBundled() != null : pkg.isJavaFXBundled() == javafxBundled).filter(pkg -> null == directlyDownloadable ? pkg.isDirectlyDownloadable() != null : pkg.isDirectlyDownloadable() == directlyDownloadable).max(Comparator.comparing(pkg -> pkg.getJavaVersion().getVersionNumber()));
                        if (pkgFound.isPresent()) {
                            maxVersionPerDistribution.put(distro, pkgFound.get().getJavaVersion().getVersionNumber());
                        }
                    });
                    distributionsToCheck.forEach(distro -> pkgsTmp.addAll(this.pkgCache.stream().filter(pkg -> pkg.getDistribution().equals(distro)).filter(pkg -> Constants.SCOPE_LOOKUP.get(pkg.getDistribution()).stream().anyMatch(scopes.stream().collect(Collectors.toSet())::contains)).filter(pkg -> architectures.isEmpty() ? pkg.getArchitecture() != null : architectures.contains(pkg.getArchitecture())).filter(pkg -> archiveTypes.isEmpty() ? pkg.getArchiveType() != null : archiveTypes.contains(pkg.getArchiveType())).filter(pkg -> operatingSystems.isEmpty() ? pkg.getOperatingSystem() != null : operatingSystems.contains(pkg.getOperatingSystem())).filter(pkg -> libCTypes.isEmpty() ? pkg.getLibCType() != null : libCTypes.contains(pkg.getLibCType())).filter(pkg -> termsOfSupport.isEmpty() ? pkg.getTermOfSupport() != null : termsOfSupport.contains(pkg.getTermOfSupport())).filter(pkg -> PackageType.NONE == packageType ? pkg.getPackageType() != packageType : pkg.getPackageType() == packageType).filter(pkg -> releaseStatus.isEmpty() ? pkg.getReleaseStatus() != null : releaseStatus.contains(pkg.getReleaseStatus())).filter(pkg -> Bitness.NONE == bitness ? pkg.getBitness() != bitness : pkg.getBitness() == bitness).filter(pkg -> null == javafxBundled ? pkg.isJavaFXBundled() != null : pkg.isJavaFXBundled() == javafxBundled).filter(pkg -> null == directlyDownloadable ? pkg.isDirectlyDownloadable() != null : pkg.isDirectlyDownloadable() == directlyDownloadable).filter(pkg -> pkg.getJavaVersion().getVersionNumber().equals(maxVersionPerDistribution.get(distro))).sorted(Comparator.comparing(Pkg::getDistributionName).reversed().thenComparing(Comparator.comparing(pkg1 -> pkg1.getJavaVersion().getVersionNumber()).reversed())).collect(Collectors.toList())));
                    pkgsFound = pkgsTmp;
                    break;
                }
                case PER_VERSION: {
                    pkgsFound = this.pkgCache.stream().filter(pkg -> distributions.isEmpty() ? pkg.getDistribution() != null : distributions.contains(pkg.getDistribution())).filter(pkg -> Constants.SCOPE_LOOKUP.get(pkg.getDistribution()).stream().anyMatch(scopes.stream().collect(Collectors.toSet())::contains)).filter(pkg -> architectures.isEmpty() ? pkg.getArchitecture() != null : architectures.contains(pkg.getArchitecture())).filter(pkg -> archiveTypes.isEmpty() ? pkg.getArchiveType() != null : archiveTypes.contains(pkg.getArchiveType())).filter(pkg -> operatingSystems.isEmpty() ? pkg.getOperatingSystem() != null : operatingSystems.contains(pkg.getOperatingSystem())).filter(pkg -> libCTypes.isEmpty() ? pkg.getLibCType() != null : libCTypes.contains(pkg.getLibCType())).filter(pkg -> termsOfSupport.isEmpty() ? pkg.getTermOfSupport() != null : termsOfSupport.contains(pkg.getTermOfSupport())).filter(pkg -> PackageType.NONE == packageType ? pkg.getPackageType() != packageType : pkg.getPackageType() == packageType).filter(pkg -> releaseStatus.isEmpty() ? pkg.getReleaseStatus() != null : releaseStatus.contains(pkg.getReleaseStatus())).filter(pkg -> Bitness.NONE == bitness ? pkg.getBitness() != bitness : pkg.getBitness() == bitness).filter(pkg -> null == javafxBundled ? pkg.isJavaFXBundled() != null : pkg.isJavaFXBundled() == javafxBundled).filter(pkg -> null == directlyDownloadable ? pkg.isDirectlyDownloadable() != null : pkg.isDirectlyDownloadable() == directlyDownloadable).filter(pkg -> pkg.getJavaVersion().getVersionNumber().getFeature().getAsInt() == versionNumber.getFeature().getAsInt()).filter(pkg -> pkg.isLatestBuildAvailable()).sorted(Comparator.comparing(Pkg::getDistributionName).reversed().thenComparing(Comparator.comparing(pkg1 -> pkg1.getJavaVersion().getVersionNumber()).reversed())).collect(Collectors.toList());
                    break;
                }
                default: {
                    pkgsFound = this.pkgCache.stream().filter(pkg -> distributions.isEmpty() ? pkg.getDistribution() != null : distributions.contains(pkg.getDistribution())).filter(pkg -> Constants.SCOPE_LOOKUP.get(pkg.getDistribution()).stream().anyMatch(scopes.stream().collect(Collectors.toSet())::contains)).filter(pkg -> null != versionNumber ? pkg.getJavaVersion().getVersionNumber().compareTo(versionNumber) == 0 : null != pkg.getJavaVersion().getVersionNumber()).filter(pkg -> architectures.isEmpty() ? pkg.getArchitecture() != null : architectures.contains(pkg.getArchitecture())).filter(pkg -> archiveTypes.isEmpty() ? pkg.getArchiveType() != null : archiveTypes.contains(pkg.getArchiveType())).filter(pkg -> operatingSystems.isEmpty() ? pkg.getOperatingSystem() != null : operatingSystems.contains(pkg.getOperatingSystem())).filter(pkg -> libCTypes.isEmpty() ? pkg.getLibCType() != null : libCTypes.contains(pkg.getLibCType())).filter(pkg -> termsOfSupport.isEmpty() ? pkg.getTermOfSupport() != null : termsOfSupport.contains(pkg.getTermOfSupport())).filter(pkg -> PackageType.NONE == packageType ? pkg.getPackageType() != packageType : pkg.getPackageType() == packageType).filter(pkg -> releaseStatus.isEmpty() ? pkg.getReleaseStatus() != null : releaseStatus.contains(pkg.getReleaseStatus())).filter(pkg -> Bitness.NONE == bitness ? pkg.getBitness() != bitness : pkg.getBitness() == bitness).filter(pkg -> null == javafxBundled ? pkg.isJavaFXBundled() != null : pkg.isJavaFXBundled() == javafxBundled).filter(pkg -> null == directlyDownloadable ? pkg.isDirectlyDownloadable() != null : pkg.isDirectlyDownloadable() == directlyDownloadable).sorted(Comparator.comparing(Pkg::getDistributionName).reversed().thenComparing(Comparator.comparing(pkg1 -> pkg1.getJavaVersion().getVersionNumber()).reversed())).collect(Collectors.toList());
                    if (null != versionNumber) {
                        int featureVersion = versionNumber.getFeature().getAsInt();
                        int interimVersion = versionNumber.getInterim().getAsInt();
                        int updateVersion = versionNumber.getUpdate().getAsInt();
                        int patchVersion = versionNumber.getPatch().getAsInt();
                        if (0 != patchVersion) {
                            pkgsFound = pkgsFound.stream().filter(pkg -> pkg.getJavaVersion().getVersionNumber().getFeature().getAsInt() == featureVersion).filter(pkg -> pkg.getJavaVersion().getVersionNumber().getInterim().getAsInt() == interimVersion).filter(pkg -> pkg.getJavaVersion().getVersionNumber().getUpdate().getAsInt() == updateVersion).filter(pkg -> pkg.getJavaVersion().getVersionNumber().getPatch().getAsInt() == patchVersion).collect(Collectors.toList());
                            break;
                        }
                        if (0 != updateVersion) {
                            pkgsFound = pkgsFound.stream().filter(pkg -> pkg.getJavaVersion().getVersionNumber().getFeature().getAsInt() == featureVersion).filter(pkg -> pkg.getJavaVersion().getVersionNumber().getInterim().getAsInt() == interimVersion).filter(pkg -> pkg.getJavaVersion().getVersionNumber().getUpdate().getAsInt() == updateVersion).collect(Collectors.toList());
                            break;
                        }
                        if (0 != interimVersion) {
                            pkgsFound = pkgsFound.stream().filter(pkg -> pkg.getJavaVersion().getVersionNumber().getFeature().getAsInt() == featureVersion).filter(pkg -> pkg.getJavaVersion().getVersionNumber().getInterim().getAsInt() == interimVersion).collect(Collectors.toList());
                            break;
                        }
                        pkgsFound = pkgsFound.stream().filter(pkg -> pkg.getJavaVersion().getVersionNumber().getFeature().getAsInt() == featureVersion).collect(Collectors.toList());
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            Predicate<Pkg> smallerCheck;
            Predicate<Pkg> greaterCheck;
            Queue<MajorVersion> majorVersions = this.majorVersionCache.isEmpty() ? this.getAllMajorVersions(true) : this.majorVersionCache;
            switch (comparison) {
                case EQUAL: {
                    VersionNumber minVersionNumber = versionNumber;
                    VersionNumber maxVersionNumber = versionNumber;
                    greaterCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(minVersionNumber) >= 0;
                    smallerCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(maxVersionNumber) <= 0;
                    break;
                }
                case LESS_THAN: {
                    VersionNumber minVersionNumber = new VersionNumber(6);
                    VersionNumber maxVersionNumber = versionNumber;
                    greaterCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(minVersionNumber) >= 0;
                    smallerCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(maxVersionNumber) < 0;
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    VersionNumber minVersionNumber = new VersionNumber(6);
                    VersionNumber maxVersionNumber = versionNumber;
                    greaterCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(minVersionNumber) >= 0;
                    smallerCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(maxVersionNumber) <= 0;
                    break;
                }
                case GREATER_THAN: {
                    VersionNumber minVersionNumber = versionNumber;
                    VersionNumber maxVersionNumber = new VersionNumber(majorVersions.peek().getAsInt());
                    greaterCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(minVersionNumber) > 0;
                    smallerCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(maxVersionNumber) <= 0;
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    VersionNumber minVersionNumber = versionNumber;
                    VersionNumber maxVersionNumber = new VersionNumber(majorVersions.peek().getAsInt());
                    greaterCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(minVersionNumber) >= 0;
                    smallerCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(maxVersionNumber) <= 0;
                    break;
                }
                default: {
                    VersionNumber minVersionNumber = new VersionNumber(6);
                    VersionNumber maxVersionNumber = new VersionNumber(majorVersions.peek().getAsInt());
                    greaterCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(minVersionNumber) >= 0;
                    smallerCheck = pkg -> pkg.getJavaVersion().getVersionNumber().compareTo(maxVersionNumber) <= 0;
                }
            }
            pkgsFound = this.pkgCache.stream().filter(pkg -> distributions.isEmpty() ? pkg.getDistribution() != null : distributions.contains(pkg.getDistribution())).filter(pkg -> Constants.SCOPE_LOOKUP.get(pkg.getDistribution()).stream().anyMatch(scopes.stream().collect(Collectors.toSet())::contains)).filter(pkg -> architectures.isEmpty() ? pkg.getArchitecture() != null : architectures.contains(pkg.getArchitecture())).filter(pkg -> archiveTypes.isEmpty() ? pkg.getArchiveType() != null : archiveTypes.contains(pkg.getArchiveType())).filter(pkg -> operatingSystems.isEmpty() ? pkg.getOperatingSystem() != null : operatingSystems.contains(pkg.getOperatingSystem())).filter(pkg -> libCTypes.isEmpty() ? pkg.getLibCType() != null : libCTypes.contains(pkg.getLibCType())).filter(pkg -> termsOfSupport.isEmpty() ? pkg.getTermOfSupport() != null : termsOfSupport.contains(pkg.getTermOfSupport())).filter(pkg -> PackageType.NONE == packageType ? pkg.getPackageType() != packageType : pkg.getPackageType() == packageType).filter(pkg -> releaseStatus.isEmpty() ? pkg.getReleaseStatus() != null : releaseStatus.contains(pkg.getReleaseStatus())).filter(pkg -> Bitness.NONE == bitness ? pkg.getBitness() != bitness : pkg.getBitness() == bitness).filter(pkg -> null == javafxBundled ? pkg.isJavaFXBundled() != null : pkg.isJavaFXBundled() == javafxBundled).filter(pkg -> null == directlyDownloadable ? pkg.isDirectlyDownloadable() != null : pkg.isDirectlyDownloadable() == directlyDownloadable).filter(greaterCheck).filter(smallerCheck).sorted(Comparator.comparing(Pkg::getDistributionName).reversed().thenComparing(Comparator.comparing(pkg1 -> pkg1.getJavaVersion().getVersionNumber()).reversed())).collect(Collectors.toList());
        }
        return pkgsFound;
    }

    public final void setOnEvt(EvtType<? extends Evt> type, EvtObserver observer) {
        if (!this.observers.keySet().contains(type.getName())) {
            this.observers.put(type.getName(), new CopyOnWriteArrayList());
        }
        if (!this.observers.get(type.getName()).contains(observer)) {
            this.observers.get(type.getName()).add(observer);
        }
    }

    public final void removeOnEvt(EvtType<? extends Evt> type, EvtObserver observer) {
        if (!this.observers.keySet().contains(type.getName())) {
            return;
        }
        if (this.observers.get(type.getName()).contains(observer)) {
            this.observers.get(type.getName()).remove(observer);
        }
    }

    public final void removeAllObservers() {
        this.observers.entrySet().forEach(entry -> ((List)entry.getValue()).clear());
    }

    public final void fireEvt(Evt evt) {
        EvtType<? extends Evt> type = evt.getEvtType();
        if (this.observers.containsKey(type.getName())) {
            this.observers.get(type.getName()).forEach(observer -> observer.handle(evt));
        }
        if (this.observers.keySet().contains(DCEvt.ANY.getName())) {
            this.observers.get(DCEvt.ANY.getName()).forEach(observer -> observer.handle(evt));
        }
    }
}

