/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.renderer;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.Chart;
import org.primefaces.component.chart.renderer.BasePlotRenderer;
import org.primefaces.model.chart.MeterGaugeChartModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeterGaugeRenderer
extends BasePlotRenderer {
    @Override
    protected void encodeData(FacesContext context, Chart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MeterGaugeChartModel model = (MeterGaugeChartModel)chart.getModel();
        writer.write(",data:[[" + model.getValue() + "]]");
    }

    @Override
    protected void encodeOptions(FacesContext context, Chart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        MeterGaugeChartModel model = (MeterGaugeChartModel)chart.getModel();
        String gaugeLabel = model.getGaugeLabel();
        double min = model.getMin();
        double max = model.getMax();
        this.encodeNumberList(context, "intervals", model.getIntervals());
        this.encodeNumberList(context, "ticks", model.getTicks());
        if (gaugeLabel != null) {
            writer.write(",gaugeLabel:'" + gaugeLabel + "'");
            writer.write(",gaugeLabelPosition:'" + model.getGaugeLabelPosition() + "'");
        }
        writer.write(",showTickLabels:" + model.isShowTickLabels());
        writer.write(",labelHeightAdjust:" + model.getLabelHeightAdjust());
        writer.write(",intervalOuterRadius:" + model.getIntervalOuterRadius());
        if (min != Double.MIN_VALUE) {
            writer.write(",min:" + min);
        }
        if (max != Double.MAX_VALUE) {
            writer.write(",max:" + max);
        }
    }

    private void encodeNumberList(FacesContext context, String name, List<Number> values) throws IOException {
        if (values != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.write("," + name + ":[");
            Iterator<Number> it = values.iterator();
            while (it.hasNext()) {
                Number number = it.next();
                writer.write(number.toString());
                if (!it.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
    }
}

