/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.persistence;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.gradle.java.api.ProjectSourcesClassPathProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.support.EntityMappingsMetadataModelHelper;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PersistenceScopeImpl
implements PersistenceScopeImplementation {
    private PersistenceLocationProvider locationProvider = null;
    private final EntityMappingsMetadataModelHelper modelHelper;
    private final ProjectSourcesClassPathProvider cpProvider;
    private ClassPath projectSourcesClassPath;

    public PersistenceScopeImpl(PersistenceLocationProvider locProvider, ProjectSourcesClassPathProvider imp) {
        this.locationProvider = locProvider;
        this.cpProvider = imp;
        this.modelHelper = this.createEntityMappingsHelper();
    }

    public FileObject getPersistenceXml() {
        FileObject location = this.locationProvider.getLocation();
        return location != null ? location.getFileObject("persistence.xml") : null;
    }

    public ClassPath getClassPath() {
        return this.getProjectSourcesClassPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getProjectSourcesClassPath() {
        PersistenceScopeImpl persistenceScopeImpl = this;
        synchronized (persistenceScopeImpl) {
            if (this.projectSourcesClassPath == null) {
                this.projectSourcesClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.cpProvider.getProjectSourcesClassPath("classpath/source"), this.cpProvider.getProjectSourcesClassPath("classpath/compile")});
            }
            return this.projectSourcesClassPath;
        }
    }

    public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(String persistenceUnitName) {
        FileObject puFo;
        MetadataModel metadataModel = this.modelHelper.getEntityMappingsModel(persistenceUnitName);
        if (metadataModel == null && (puFo = this.getPersistenceXml()) != null) {
            this.modelHelper.changePersistenceXml(FileUtil.toFile((FileObject)puFo));
            metadataModel = this.modelHelper.getEntityMappingsModel(persistenceUnitName);
        }
        return metadataModel;
    }

    private EntityMappingsMetadataModelHelper createEntityMappingsHelper() {
        return EntityMappingsMetadataModelHelper.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"));
    }
}

