/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.ui.picker;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.UIManager;
import org.netbeans.modules.web.browser.ui.picker.BrowserMenu;
import org.netbeans.modules.web.browser.ui.picker.ListItem;
import org.netbeans.modules.web.browser.ui.picker.RendererImpl;

class SelectionListImpl
extends JList<ListItem> {
    private int mouseOverRow = -1;

    SelectionListImpl() {
        Color foreground;
        this.setSelectionMode(0);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.setBackground(new Color(0, 0, 0, 0));
        if (BrowserMenu.GTK && null != (foreground = UIManager.getColor("MenuItem.foreground"))) {
            this.setForeground(new Color(foreground.getRGB()));
        }
        this.setCellRenderer(new RendererImpl());
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SelectionListImpl.this.getSelectedIndex() < 0 && SelectionListImpl.this.isShowing() && SelectionListImpl.this.getModel().getSize() > 0) {
                    SelectionListImpl.this.setSelectedIndex(0);
                }
            }
        });
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.mouseMoved(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SelectionListImpl.this.setMouseOver(-1);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = SelectionListImpl.this.locationToIndex(e.getPoint());
                SelectionListImpl.this.setMouseOver(row);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getButton() == 1 && (row = SelectionListImpl.this.locationToIndex(e.getPoint())) >= 0 && row == SelectionListImpl.this.getSelectedIndex()) {
                    e.consume();
                    SelectionListImpl.this.clearSelection();
                    SelectionListImpl.this.setSelectedIndex(row);
                }
            }
        };
        this.addMouseMotionListener(adapter);
        this.addMouseListener(adapter);
    }

    int getMouseOverRow() {
        return this.mouseOverRow;
    }

    private void setMouseOver(int newRow) {
        int oldRow = this.mouseOverRow;
        this.mouseOverRow = newRow;
        this.repaintRow(oldRow);
        this.repaintRow(this.mouseOverRow);
    }

    private void repaintRow(int row) {
        Rectangle rect;
        if (row >= 0 && row < this.getModel().getSize() && null != (rect = this.getCellBounds(row, row))) {
            this.repaint(rect);
        }
    }
}

