/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.bridge.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.Util;
import org.netbeans.modules.bugtracking.bridge.nodes.BugtrackingRootNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RepositoryNode
extends AbstractNode
implements PropertyChangeListener {
    private final Repository repository;

    public RepositoryNode(Repository repository) {
        super(Children.LEAF);
        this.repository = repository;
        this.setName(repository.getDisplayName());
        repository.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public Image getIcon(int type) {
        return this.repository.getIcon();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"CTL_QueryAction")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.createNewQuery((Repository)RepositoryNode.this.repository);
            }
        }, new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"CTL_IssueAction")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.createNewIssue((Repository)RepositoryNode.this.repository);
            }
        }, new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_EditRepository")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.edit((Repository)RepositoryNode.this.repository);
            }
        }, new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_RemoveRepository")){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RepositoryNode.class, (String)"MSG_RemoveRepository", (Object[])new Object[]{RepositoryNode.this.repository.getDisplayName()}), NbBundle.getMessage(RepositoryNode.class, (String)"CTL_RemoveRepository"), 2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            RepositoryNode.this.repository.remove();
                        }
                    });
                }
            }
        }};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("bugtracking.repository.attributes.changed")) {
            super.setDisplayName(this.repository.getDisplayName());
        }
    }
}

