/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.node;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.truffle.node.Bundle;
import org.netbeans.modules.debugger.jpda.truffle.node.JPDAStart;
import org.netbeans.modules.javascript.nodejs.api.NodeJsSupport;
import org.netbeans.spi.extexecution.startup.StartupExtenderImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class GraalVmStartupExtender
implements StartupExtenderImplementation {
    public List<String> getArguments(Lookup context, StartupExtender.StartMode mode) {
        Project p = (Project)context.lookup(Project.class);
        if (p == null) {
            return Collections.emptyList();
        }
        NodeJsSupport s = NodeJsSupport.getInstance();
        if (!s.isEnabled(p)) {
            return Collections.emptyList();
        }
        if (mode != StartupExtender.StartMode.DEBUG) {
            return Collections.emptyList();
        }
        String node = s.getNode(p);
        File nodeFile = new File(node);
        FileObject nodeFO = FileUtil.toFileObject((File)(nodeFile = FileUtil.normalizeFile((File)nodeFile)));
        if (nodeFO == null) {
            return Collections.emptyList();
        }
        FileObject bin = nodeFO.getParent();
        if (bin == null || !GraalVmStartupExtender.isJavaPlatformBinDir(bin)) {
            return Collections.emptyList();
        }
        String debugName = Bundle.CTL_DebugName();
        InputOutput io = IOProvider.getDefault().getIO(debugName, false);
        FileObject jdk = bin.getParent();
        if (jdk.getName().equals("jre")) {
            jdk = jdk.getParent();
        }
        JPDAStart start = new JPDAStart(io, debugName, jdk);
        String res = null;
        try {
            res = start.execute(p);
        }
        catch (Throwable ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Arrays.asList("--jvm.agentlib:jdwp=transport=dt_socket,address=" + res + ",server=n,suspend=y");
    }

    private static boolean isJavaPlatformBinDir(FileObject dir) {
        if (!"bin".equals(dir.getNameExt())) {
            return false;
        }
        FileObject file = dir.getFileObject("java", BaseUtilities.isWindows() ? "exe" : null);
        if (file == null) {
            return false;
        }
        file = dir.getFileObject("node", BaseUtilities.isWindows() ? "exe" : null);
        return file != null;
    }
}

