/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cloud.oracle.DatabaseNode;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.items.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.DatabaseItem;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class CompartmentNode
extends AbstractNode {
    private static final String COMPARTMENT_ICON = "org/netbeans/modules/cloud/oracle/resources/compartment.svg";

    public CompartmentNode(CompartmentItem compartment) {
        super(Children.create((ChildFactory)new CompartmentChildFactory(compartment), (boolean)true), Lookups.fixed((Object[])new Object[]{compartment}));
        this.setName(compartment.getName());
        this.setDisplayName(compartment.getName());
        this.setIconBaseWithExtension(COMPARTMENT_ICON);
    }

    public Action[] getActions(boolean context) {
        return Utilities.actionsForPath((String)"Cloud/Oracle/Compartment/Actions").toArray(new Action[0]);
    }

    public static class CompartmentChildFactory
    extends ChildFactory<DatabaseItem>
    implements ChangeListener {
        private final String compartmentId;

        public CompartmentChildFactory(CompartmentItem compartment) {
            this.compartmentId = compartment.getId();
            compartment.addChangeListener(this);
        }

        protected boolean createKeys(List<DatabaseItem> toPopulate) {
            toPopulate.addAll(OCIManager.getDefault().getDatabases(this.compartmentId));
            return true;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }

        protected Node createNodeForKey(DatabaseItem key) {
            DatabaseNode node = new DatabaseNode(key);
            return node;
        }
    }
}

