/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.database.DatabaseClient;
import com.oracle.bmc.database.model.AutonomousDatabaseSummary;
import com.oracle.bmc.database.model.CreateAutonomousDatabaseBase;
import com.oracle.bmc.database.model.CreateAutonomousDatabaseDetails;
import com.oracle.bmc.database.model.DatabaseConnectionStringProfile;
import com.oracle.bmc.database.model.GenerateAutonomousDatabaseWalletDetails;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.GenerateAutonomousDatabaseWalletRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabasesRequest;
import com.oracle.bmc.database.responses.CreateAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.GenerateAutonomousDatabaseWalletResponse;
import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.Tenancy;
import com.oracle.bmc.identity.requests.GetTenancyRequest;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.responses.GetTenancyResponse;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.model.BmcException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.cloud.oracle.Bundle;
import org.netbeans.modules.cloud.oracle.items.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.DatabaseItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public final class OCIManager {
    private ConfigFileReader.ConfigFile configFile;
    private ConfigFileAuthenticationDetailsProvider provider;
    private ConfigFileAuthenticationDetailsProvider configProvider;
    private static OCIManager instance;

    private OCIManager() {
        this.init();
    }

    private void init() {
        try {
            this.configFile = ConfigFileReader.parseDefault();
            this.provider = new ConfigFileAuthenticationDetailsProvider(this.configFile);
            this.configProvider = new ConfigFileAuthenticationDetailsProvider(this.configFile);
        }
        catch (Throwable ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static synchronized OCIManager getDefault() {
        if (instance == null) {
            instance = new OCIManager();
        }
        return instance;
    }

    public Optional<OCIItem> getTenancy() {
        if (this.provider == null) {
            return Optional.empty();
        }
        try {
            IdentityClient identityClient = new IdentityClient((BasicAuthenticationDetailsProvider)this.provider);
            identityClient.setRegion(this.configProvider.getRegion());
            GetTenancyRequest gtr = GetTenancyRequest.builder().tenancyId(this.provider.getTenantId()).build();
            GetTenancyResponse response = identityClient.getTenancy(gtr);
            Tenancy tenancy = response.getTenancy();
            OCIItem item = new OCIItem(tenancy.getId(), tenancy.getName());
            item.setDescription(Bundle.LBL_HomeRegion(tenancy.getHomeRegionKey()));
            return Optional.of(item);
        }
        catch (Throwable t) {
            Exceptions.printStackTrace((Throwable)t);
            return Optional.empty();
        }
    }

    public List<CompartmentItem> getCompartments(String tenancyId) {
        ListCompartmentsResponse response;
        IdentityClient identityClient = new IdentityClient((BasicAuthenticationDetailsProvider)this.provider);
        identityClient.setRegion(this.configProvider.getRegion());
        ArrayList<CompartmentItem> compartments = new ArrayList<CompartmentItem>();
        String nextPageToken = null;
        do {
            response = identityClient.listCompartments(ListCompartmentsRequest.builder().limit(Integer.valueOf(30)).compartmentId(tenancyId).accessLevel(ListCompartmentsRequest.AccessLevel.Accessible).compartmentIdInSubtree(Boolean.TRUE).page(nextPageToken).build());
            response.getItems().stream().map(c -> new CompartmentItem(c.getId(), c.getName())).collect(Collectors.toCollection(() -> compartments));
        } while ((nextPageToken = response.getOpcNextPage()) != null);
        return compartments;
    }

    public List<DatabaseItem> getDatabases(String compartmentId) {
        DatabaseClient client = new DatabaseClient((BasicAuthenticationDetailsProvider)this.configProvider);
        ListAutonomousDatabasesRequest listAutonomousDatabasesRequest = ListAutonomousDatabasesRequest.builder().compartmentId(compartmentId).limit(Integer.valueOf(88)).build();
        return client.listAutonomousDatabases(listAutonomousDatabasesRequest).getItems().stream().map(d -> {
            DatabaseItem item = new DatabaseItem(d.getId(), d.getDbName(), d.getServiceConsoleUrl(), this.getConnectionName((AutonomousDatabaseSummary)d));
            StringBuilder sb = new StringBuilder();
            sb.append(Bundle.LBL_WorkloadType(d.getDbWorkload().getValue()));
            sb.append(Bundle.LBL_DatabaseVersion(d.getDbVersion()));
            sb.append(Bundle.LBL_Storage(d.getDataStorageSizeInTBs()));
            item.setDescription(sb.toString());
            return item;
        }).collect(Collectors.toList());
    }

    private String getConnectionName(AutonomousDatabaseSummary summary) {
        List profiles = summary.getConnectionStrings().getProfiles();
        if (profiles != null) {
            for (DatabaseConnectionStringProfile profile : profiles) {
                if (!profile.getDisplayName().contains("high")) continue;
                return profile.getDisplayName();
            }
        }
        return null;
    }

    public Optional<String> createAutonomousDatabase(String compartmentId, String dbName, char[] password) {
        DatabaseClient client = new DatabaseClient((BasicAuthenticationDetailsProvider)this.configProvider);
        CreateAutonomousDatabaseDetails createAutonomousDatabaseBase = CreateAutonomousDatabaseDetails.builder().compartmentId(compartmentId).dbName(dbName).adminPassword(new String(password)).cpuCoreCount(Integer.valueOf(1)).dataStorageSizeInTBs(Integer.valueOf(1)).build();
        CreateAutonomousDatabaseRequest createAutonomousDatabaseRequest = CreateAutonomousDatabaseRequest.builder().createAutonomousDatabaseDetails((CreateAutonomousDatabaseBase)createAutonomousDatabaseBase).build();
        try {
            CreateAutonomousDatabaseResponse createAutonomousDatabaseResponse = client.createAutonomousDatabase(createAutonomousDatabaseRequest);
        }
        catch (BmcException e) {
            return Optional.of(e.getMessage());
        }
        return Optional.empty();
    }

    public Path downloadWallet(OCIItem dbInstance, String password, String parentPath) throws FileNotFoundException, IOException {
        ZipEntry entry;
        DatabaseClient client = new DatabaseClient((BasicAuthenticationDetailsProvider)this.configProvider);
        GenerateAutonomousDatabaseWalletDetails details = GenerateAutonomousDatabaseWalletDetails.builder().password(password).build();
        GenerateAutonomousDatabaseWalletRequest generateAutonomousDatabaseWalletRequest = GenerateAutonomousDatabaseWalletRequest.builder().autonomousDatabaseId(dbInstance.getId()).generateAutonomousDatabaseWalletDetails(details).build();
        GenerateAutonomousDatabaseWalletResponse response = client.generateAutonomousDatabaseWallet(generateAutonomousDatabaseWalletRequest);
        Path walletPath = null;
        int i = 1;
        while (Files.exists(walletPath = walletPath == null ? Paths.get(parentPath, dbInstance.getName()) : Paths.get(parentPath, dbInstance.getName() + "_" + i++), new LinkOption[0])) {
        }
        Files.createDirectory(walletPath, new FileAttribute[0]);
        ZipInputStream zin = new ZipInputStream(response.getInputStream());
        while ((entry = zin.getNextEntry()) != null) {
            Path entryPath = walletPath.resolve(entry.getName());
            Files.copy(zin, entryPath, new CopyOption[0]);
        }
        return walletPath;
    }
}

