/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.modules.cloud.oracle.Bundle;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class OracleCloudWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator {
    private static final String TENANCY = "TENANCY";
    private Panel panel;

    public Set instantiate() throws IOException {
        return Collections.emptySet();
    }

    public void initialize(WizardDescriptor wizard) {
        wizard.putProperty(TENANCY, CompletableFuture.supplyAsync(() -> OCIManager.getDefault().getTenancy()));
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public WizardDescriptor.Panel current() {
        if (this.panel == null) {
            this.panel = new Panel();
        }
        return this.panel;
    }

    public String name() {
        return Bundle.LBL_OC();
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
    }

    public void previousPanel() {
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private class Panel
    implements WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor> {
        private JTextPane text = new JTextPane();
        private boolean valid = false;
        private final JPanel panel;
        private final ChangeSupport changeSupport;

        public Panel() {
            this.text.setContentType("text/html");
            this.text.setText(Bundle.MSG_CheckingSetup());
            this.panel = new JPanel(new BorderLayout());
            this.text.setEditable(false);
            this.text.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hle) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                        Desktop desktop = Desktop.getDesktop();
                        try {
                            desktop.browse(hle.getURL().toURI());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
            this.panel.add((Component)this.text, "Center");
            this.panel.setName(Bundle.LBL_OC());
            this.panel.putClientProperty("WizardPanel_contentData", new String[]{Bundle.LBL_OC()});
            this.panel.putClientProperty("WizardPanel_contentSelectedIndex", 0);
            this.text.setText(Bundle.MSG_CheckingSetup());
            this.changeSupport = new ChangeSupport((Object)this);
        }

        public Component getComponent() {
            return this.panel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public void readSettings(WizardDescriptor settings) {
            Object o = settings.getProperty(OracleCloudWizardIterator.TENANCY);
            if (o == null) {
                return;
            }
            CompletionStage cs = (CompletionStage)o;
            cs.thenAccept(t -> {
                if (t.isPresent()) {
                    if (!this.valid) {
                        this.valid = true;
                        this.changeSupport.fireChange();
                    }
                    this.text.setText(Bundle.MSG_TenancyFound(((OCIItem)t.get()).getName()));
                } else {
                    this.text.setText(Bundle.MSG_OCI_Setup(Bundle.URL_OCI_Setup()));
                }
            });
        }

        public void storeSettings(WizardDescriptor settings) {
        }

        public boolean isValid() {
            return this.valid;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public void prepareValidation() {
        }

        public void validate() throws WizardValidationException {
        }
    }
}

