/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.HttpProxySettings;
import org.netbeans.modules.welcome.content.RSSEntityResolver;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.content.WebLink;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.modules.Places;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class RSSFeed
extends JPanel
implements Constants,
PropertyChangeListener {
    private String url;
    private boolean showProxyButton = true;
    private RequestProcessor.Task reloadTimer;
    protected long lastReload = 0L;
    public static final String FEED_CONTENT_PROPERTY = "feedContent";
    private static DateFormat parsingDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private static DateFormat parsingDateFormatShort = new SimpleDateFormat("EEE, dd MMM yyyy", Locale.ENGLISH);
    private static DateFormat parsingDateFormatLong = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
    private static DateFormat printingDateFormatShort = DateFormat.getDateInstance(3);
    private boolean isCached = false;
    private final Logger LOGGER = Logger.getLogger(RSSFeed.class.getName());
    private int maxDescriptionChars = -1;
    private static final RequestProcessor RP = new RequestProcessor("StartPage");
    private static final long serialVersionUID = 1L;

    private static File initCacheStore(String path) throws IOException {
        File cacheStore = Places.getCacheSubfile((String)("welcome/" + path));
        cacheStore.createNewFile();
        return cacheStore;
    }

    public RSSFeed(String url, boolean showProxyButton) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.url = url;
        this.showProxyButton = showProxyButton;
        this.setBorder(null);
        this.add((Component)this.buildContentLoadingLabel(), "Center");
        HttpProxySettings.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)HttpProxySettings.getDefault()));
    }

    public RSSFeed(boolean showProxyButton) {
        this((String)null, showProxyButton);
    }

    public void setContent(Component content) {
        this.removeAll();
        Dimension d = new Dimension();
        this.add(content, "Center");
        this.firePropertyChange(FEED_CONTENT_PROPERTY, null, content);
        this.revalidate();
        this.invalidate();
        this.repaint();
    }

    public Component getContent() {
        return this;
    }

    public void reload() {
        new Reload().start();
    }

    protected int getMaxItemCount() {
        return 5;
    }

    protected List<FeedItem> buildItemList() throws SAXException, ParserConfigurationException, IOException {
        XMLReader reader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
        FeedHandler handler = new FeedHandler(this.getMaxItemCount());
        reader.setContentHandler(handler);
        reader.setEntityResolver(new RSSEntityResolver());
        reader.setErrorHandler(new ErrorCatcher());
        InputSource is = this.findInputSource(new URL(this.url));
        reader.parse(is);
        return handler.getItemList();
    }

    protected final String url2path(URL u) {
        StringBuilder pathSB = new StringBuilder(u.getHost());
        if (u.getPort() != -1) {
            pathSB.append(u.getPort());
        }
        pathSB.append(u.getPath());
        if (null != u.getQuery()) {
            pathSB.append(u.getQuery());
        }
        return pathSB.toString();
    }

    protected InputSource findInputSource(URL u) throws IOException {
        HttpURLConnection httpCon = (HttpURLConnection)u.openConnection();
        httpCon.setUseCaches(true);
        httpCon.setRequestProperty("Accept-Encoding", "gzip, deflate");
        Preferences prefs = NbPreferences.forModule(RSSFeed.class);
        String path = this.url2path(u);
        String lastModified = prefs.get(path, null);
        if (lastModified != null) {
            httpCon.addRequestProperty("If-Modified-Since", lastModified);
        }
        if (httpCon instanceof HttpsURLConnection) {
            RSSFeed.initSSL(httpCon);
        }
        httpCon.connect();
        if (httpCon.getResponseCode() == 304) {
            File cacheFile = RSSFeed.initCacheStore(path);
            this.LOGGER.log(Level.FINE, "Reading content of {0} from {1}", new Object[]{u.toString(), cacheFile.getAbsolutePath()});
            this.isCached = true;
            return new InputSource(new BufferedInputStream(new FileInputStream(cacheFile)));
        }
        if (httpCon.getResponseCode() == 302) {
            String newUrl = httpCon.getHeaderField("Location");
            if (null != newUrl && !newUrl.isEmpty()) {
                return this.findInputSource(new URL(newUrl));
            }
            throw new IOException("Invalid redirection");
        }
        String encoding = httpCon.getContentEncoding();
        this.LOGGER.log(Level.FINER, "Connection encoding: {0}", encoding);
        this.LOGGER.log(Level.FINER, "ETag: {0}", httpCon.getHeaderField("ETag"));
        InputStream is = null;
        is = "gzip".equalsIgnoreCase(encoding) ? new GZIPInputStream(httpCon.getInputStream()) : ("deflate".equalsIgnoreCase(encoding) ? new InflaterInputStream(httpCon.getInputStream(), new Inflater(true)) : httpCon.getInputStream());
        this.LOGGER.log(Level.FINE, "Reading {0} from original source and caching", this.url);
        return new InputSource(new CachingInputStream(is, path, httpCon.getHeaderField("Last-Modified")));
    }

    protected void clearCache() {
        try {
            NbPreferences.forModule(RSSFeed.class).remove(this.url2path(new URL(this.url)));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected Component createFeedItemComponent(FeedItem item) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        int row = 0;
        if (item.dateTime != null) {
            JLabel label = new JLabel();
            label.setFont(RSS_DESCRIPTION_FONT);
            label.setForeground(Utils.getRssDateColor());
            label.setText(this.formatDateTime(item.dateTime));
            panel.add((Component)label, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 15, 2, 10), 0, 0));
        }
        WebLink linkButton = new WebLink(this.stripHtml(item.title), item.link, Utils.getRssHeaderColor(), false);
        linkButton.getAccessibleContext().setAccessibleName(BundleSupport.getAccessibilityName("WebLink", item.title));
        linkButton.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("WebLink", item.link));
        linkButton.setFont(BUTTON_FONT);
        panel.add((Component)linkButton, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 10), 0, 0));
        if (item.description != null) {
            JLabel label = new JLabel("<html>" + this.trimHtml(item.description));
            label.setFont(RSS_DESCRIPTION_FONT);
            label.setForeground(Utils.getRssDetailsColor());
            panel.add((Component)label, new GridBagConstraints(0, row++, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 0, 0));
        }
        return panel;
    }

    protected static String getTextContent(Node node) {
        Node child = node.getFirstChild();
        if (null == child) {
            return null;
        }
        return child.getNodeValue();
    }

    protected String formatDateTime(String strDateTime) {
        try {
            Date date = parsingDateFormat.parse(strDateTime);
            return printingDateFormatShort.format(date);
        }
        catch (NumberFormatException date) {
        }
        catch (ParseException pE) {
            try {
                Date date = parsingDateFormatShort.parse(strDateTime);
                return printingDateFormatShort.format(date);
            }
            catch (NumberFormatException date) {
            }
            catch (ParseException otherPE) {
                try {
                    Date date = parsingDateFormatLong.parse(strDateTime);
                    return printingDateFormatShort.format(date);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return strDateTime;
    }

    @Override
    public void removeNotify() {
        this.stopReloading();
        this.maxDescriptionChars = -1;
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getMaxDecsriptionLength();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                RSSFeed.this.startReloading();
            }
        });
    }

    protected void startReloading() {
        if (null == this.reloadTimer && !Boolean.getBoolean("netbeans.full.hack")) {
            if (System.currentTimeMillis() - this.lastReload >= 3600000L) {
                this.reload();
            } else {
                this.reloadTimer = RP.post((Runnable)new Reload(), Math.max(1, (int)(3600000L - (System.currentTimeMillis() - this.lastReload))));
            }
        }
    }

    protected void stopReloading() {
        if (null != this.reloadTimer) {
            this.reloadTimer.cancel();
            this.reloadTimer = null;
        }
    }

    private String trimHtml(String htmlSnippet) {
        String res = this.stripHtml(htmlSnippet);
        int maxLen = this.getMaxDecsriptionLength();
        if (maxLen > 0 && res.length() > maxLen) {
            res = res.substring(0, maxLen) + "...";
        }
        return res;
    }

    private String stripHtml(String htmlSnippet) {
        return htmlSnippet.replaceAll("<[^>]*>", "").replace("&nbsp;", " ").trim();
    }

    protected int getMaxDecsriptionLength() {
        if (this.maxDescriptionChars < 0 && this.getWidth() > 0) {
            if (this.getWidth() <= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.getMaxDecsriptionLength();
                    }
                });
                return 200;
            }
            try {
                Graphics2D g = (Graphics2D)this.getGraphics();
                FontMetrics fm = g.getFontMetrics(RSS_DESCRIPTION_FONT);
                double charWidth = fm.getStringBounds("Ab c", g).getWidth() / 4.0;
                double feedWidth = this.getWidth() - 30;
                this.maxDescriptionChars = (int)(1.8 * feedWidth / charWidth);
            }
            catch (Throwable e) {
                this.maxDescriptionChars = 200;
            }
        }
        return this.maxDescriptionChars;
    }

    protected Component getContentHeader() {
        return null;
    }

    private JComponent buildProxyPanel() {
        Component header = this.getContentHeader();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        int row = 0;
        if (null != header) {
            panel.add(header, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        panel.add((Component)new JLabel(BundleSupport.getLabel("ErrCannotConnect")), new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        if (this.showProxyButton) {
            JButton button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)button, (String)BundleSupport.getLabel("ProxyConfig"));
            button.setOpaque(false);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HttpProxySettings.getDefault().showConfigurationDialog();
                }
            });
            panel.add((Component)button, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        }
        return panel;
    }

    private JComponent buildContentLoadingLabel() {
        JLabel label = new JLabel(BundleSupport.getLabel("ContentLoading"));
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setOpaque(false);
        Component header = this.getContentHeader();
        if (null != header) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(false);
            panel.add(header, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.setBorder(BorderFactory.createEmptyBorder(40, 0, 40, 0));
            return panel;
        }
        label.setBorder(BorderFactory.createEmptyBorder(40, 0, 40, 0));
        return label;
    }

    private JComponent buildErrorLabel() {
        Component header = this.getContentHeader();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        int row = 0;
        if (null != header) {
            panel.add(header, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        panel.add((Component)new JLabel(BundleSupport.getLabel("ErrLoadingFeed")), new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        JButton button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)BundleSupport.getLabel("Reload"));
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RSSFeed.this.lastReload = 0L;
                RSSFeed.this.reload();
            }
        });
        panel.add((Component)button, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        return panel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ProxySettings".equals(evt.getPropertyName())) {
            this.removeAll();
            this.add((Component)this.buildContentLoadingLabel(), "Center");
            this.lastReload = 0L;
            this.reload();
        }
    }

    public boolean isContentCached() {
        return this.isCached;
    }

    public static void initSSL(HttpURLConnection httpCon) throws IOException {
        if (httpCon instanceof HttpsURLConnection) {
            HttpsURLConnection https = (HttpsURLConnection)httpCon;
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                https.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                https.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
    }

    static class CachingInputStream
    extends FilterInputStream {
        private OutputStream os;
        private String modTime;
        private String path;

        CachingInputStream(InputStream is, String path, String time) throws IOException {
            super(is);
            File storage = RSSFeed.initCacheStore(path);
            this.os = new BufferedOutputStream(new FileOutputStream(storage));
            this.modTime = time;
            this.path = path;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.modTime != null) {
                NbPreferences.forModule(RSSFeed.class).put(this.path, this.modTime);
            }
            this.os.close();
        }

        @Override
        public int read() throws IOException {
            int val = super.read();
            this.os.write(val);
            return val;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int res = super.read(b, off, len);
            if (res != -1) {
                this.os.write(b, off, res);
            }
            return res;
        }
    }

    protected static class FeedItem {
        public String title;
        public String link;
        public String description;
        public String dateTime;
        public String enclosureUrl;

        protected FeedItem() {
        }

        public boolean isValid() {
            return null != this.title && null != this.link;
        }
    }

    static class FeedHandler
    implements ContentHandler {
        private FeedItem currentItem;
        private StringBuffer textBuffer;
        private int maxItemCount;
        private ArrayList<FeedItem> itemList;

        public FeedHandler(int maxItemCount) {
            this.maxItemCount = maxItemCount;
            this.itemList = new ArrayList(maxItemCount);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.itemList.size() < this.maxItemCount) {
                if ("item".equals(localName) || "entry".equals(localName)) {
                    this.currentItem = new FeedItem();
                } else if ("link".equals(localName) || "pubDate".equals(localName) || "date".equals(localName) || "published".equals(localName) || "description".equals(localName) || "content".equals(localName) || "title".equals(localName)) {
                    this.textBuffer = new StringBuffer(110);
                    if ("link".equals(localName) && null != this.currentItem && null != atts.getValue("href")) {
                        this.currentItem.link = this.fixFeedItemUrl(atts.getValue("href"));
                    }
                } else if ("enclosure".equals(localName) && null != this.currentItem) {
                    this.currentItem.enclosureUrl = atts.getValue("url");
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.itemList.size() < this.maxItemCount) {
                if ("item".equals(localName) || "entry".equals(localName)) {
                    if (null != this.currentItem && this.currentItem.isValid()) {
                        this.itemList.add(this.currentItem);
                    }
                    this.currentItem = null;
                } else if (null != this.currentItem && null != this.textBuffer) {
                    String text = this.textBuffer.toString().trim();
                    this.textBuffer = null;
                    if (0 == text.length()) {
                        text = null;
                    }
                    if ("link".equals(localName) && null == this.currentItem.link) {
                        this.currentItem.link = this.fixFeedItemUrl(text);
                    } else if ("pubDate".equals(localName) || "published".equals(localName) || "date".equals(localName)) {
                        this.currentItem.dateTime = text;
                    } else if ("title".equals(localName)) {
                        this.currentItem.title = text;
                    } else if ("description".equals(localName) || "content".equals(localName)) {
                        this.currentItem.description = text;
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (null != this.textBuffer) {
                this.textBuffer.append(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        public ArrayList<FeedItem> getItemList() {
            return this.itemList;
        }

        protected String fixFeedItemUrl(String url) {
            if (null != url && (url.contains(".netbeans.org") || url.contains("/netbeans.org"))) {
                url = url.contains("?") ? url + "&" : url + "?";
                url = url + "utm_source=netbeans&utm_campaign=welcomepage";
            }
            return url;
        }
    }

    private class Reload
    extends Thread {
        private Reload() {
        }

        @Override
        public void run() {
            try {
                RSSFeed.this.lastReload = System.currentTimeMillis();
                List<FeedItem> itemList = RSSFeed.this.buildItemList();
                final JPanel contentPanel = new JPanel(new GridBagLayout());
                contentPanel.setOpaque(false);
                int contentRow = 0;
                Component header = RSSFeed.this.getContentHeader();
                if (null != header) {
                    contentPanel.add(header, new GridBagConstraints(0, contentRow++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                for (int i = 0; i < Math.min(itemList.size(), RSSFeed.this.getMaxItemCount()); ++i) {
                    FeedItem item = itemList.get(i);
                    if (null == item.title || null == item.link) continue;
                    Component comp = RSSFeed.this.createFeedItemComponent(item);
                    contentPanel.add(comp, new GridBagConstraints(0, contentRow++, 1, 1, 1.0, 0.0, 18, 1, new Insets(contentRow == 1 ? 0 : 0, 0, 16, 0), 0, 0));
                }
                contentPanel.add((Component)new JLabel(), new GridBagConstraints(0, contentRow++, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(contentPanel);
                    }
                });
                RSSFeed.this.reloadTimer = RP.post((Runnable)this, 3600000);
            }
            catch (UnknownHostException uhE) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (SocketException sE) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (IOException ioE) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (SAXException e) {
                RSSFeed.this.stopReloading();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildErrorLabel());
                    }
                });
            }
            catch (Exception e) {
                if (RSSFeed.this.isContentCached()) {
                    RSSFeed.this.isCached = false;
                    RSSFeed.this.clearCache();
                    RSSFeed.this.reload();
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildErrorLabel());
                    }
                });
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    static class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(Level level, SAXParseException e) {
            Logger l = Logger.getLogger(RSSFeed.class.getName());
            l.log(level, "Line number:" + e.getLineNumber());
            l.log(level, "Column number:" + e.getColumnNumber());
            l.log(level, "Public ID:" + e.getPublicId());
            l.log(level, "System ID:" + e.getSystemId());
            l.log(level, "Error message:" + e.getMessage());
        }

        @Override
        public void error(SAXParseException e) {
            this.message(Level.SEVERE, e);
        }

        @Override
        public void warning(SAXParseException e) {
            this.message(Level.WARNING, e);
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.message(Level.SEVERE, e);
        }
    }
}

