/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.indexing.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.indexing.CssIndexModelSupport;
import org.netbeans.modules.css.indexing.CssIndexer;
import org.netbeans.modules.css.indexing.api.CssIndexModel;
import org.netbeans.modules.css.indexing.api.CssIndexModelFactory;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.FileReference;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public class CssIndex {
    private static final Logger LOGGER = Logger.getLogger(CssIndex.class.getSimpleName());
    private static final String SCSS_EXT = "scss";
    private static final String SASS_EXT = "sass";
    private static final Map<Project, CssIndex> INDEXES = new WeakHashMap<Project, CssIndex>();
    private static final String VIRTUAL_ELEMENT_MARKER_STR = Character.toString('!');
    private final QuerySupport querySupport;
    private final Collection<FileObject> sourceRoots;
    private final ChangeSupport changeSupport;
    private AllDependenciesMaps allDepsCache;
    private long allDepsCache_hashCode;
    private static final String REGEXP_CHARS_TO_ENCODE = ".\\?*+&:{}[]()^$";

    public static CssIndex create(Project project) throws IOException {
        return new CssIndex(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CssIndex get(Project project) throws IOException {
        if (project == null) {
            throw new NullPointerException();
        }
        Map<Project, CssIndex> map = INDEXES;
        synchronized (map) {
            CssIndex index = INDEXES.get(project);
            if (index == null) {
                index = CssIndex.create(project);
                INDEXES.put(project, index);
            }
            return index;
        }
    }

    private CssIndex(Project project) throws IOException {
        this.sourceRoots = QuerySupport.findRoots((Project)project, null, Collections.emptyList(), Collections.emptyList());
        this.querySupport = QuerySupport.forRoots((String)"css", (int)5, (FileObject[])this.sourceRoots.toArray(new FileObject[0]));
        this.changeSupport = new ChangeSupport((Object)this);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void notifyChange() {
        this.changeSupport.fireChange();
    }

    public <T extends CssIndexModel> T getIndexModel(Class factoryClass, FileObject file) throws IOException {
        if (file == null) {
            throw new NullPointerException("The file argument cannot be null!");
        }
        CssIndexModelFactory factory = CssIndexModelSupport.getFactory(factoryClass);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("No %s class registered as a system service!", factoryClass.getName()));
        }
        Collection<String> fieldsToLoad = factory.getIndexKeys();
        Collection results = this.querySupport.getQueryFactory().file(file).execute(fieldsToLoad.toArray(new String[fieldsToLoad.size()]));
        if (!results.isEmpty()) {
            return factory.loadFromIndex((IndexResult)results.iterator().next());
        }
        return null;
    }

    public <T extends CssIndexModel> Map<FileObject, T> getIndexModels(Class<CssIndexModelFactory<T>> factoryClass) throws IOException {
        CssIndexModelFactory factory = CssIndexModelSupport.getFactory(factoryClass);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("No %s class registered as a system service!", factoryClass.getName()));
        }
        Collection results = this.querySupport.query("cssContent", "", QuerySupport.Kind.PREFIX, factory.getIndexKeys().toArray(new String[0]));
        HashMap file2model = new HashMap();
        for (IndexResult result : results) {
            file2model.put(result.getFile(), factory.loadFromIndex(result));
        }
        return file2model;
    }

    public Collection<FileObject> findIds(String id) {
        return this.find(RefactoringElementType.ID, id);
    }

    public Collection<FileObject> findIdDeclarations(String id) {
        return this.find(RefactoringElementType.ID, id, false);
    }

    public Map<FileObject, Collection<String>> findAllIdDeclarations() {
        return this.findAll(RefactoringElementType.ID, false);
    }

    public Collection<FileObject> findClasses(String clazz) {
        return this.find(RefactoringElementType.CLASS, clazz);
    }

    public Map<FileObject, Collection<String>> findAllClassDeclarations() {
        return this.findAll(RefactoringElementType.CLASS, false);
    }

    public Collection<FileObject> findClassDeclarations(String clazz) {
        return this.find(RefactoringElementType.CLASS, clazz, false);
    }

    public Collection<FileObject> findHtmlElement(String htmlElement) {
        return this.find(RefactoringElementType.ELEMENT, htmlElement);
    }

    public Collection<FileObject> findColor(String colorCode) {
        return this.find(RefactoringElementType.COLOR, colorCode);
    }

    public Map<FileObject, Collection<String>> findClassesByPrefix(String prefix) {
        return this.findByPrefix(RefactoringElementType.CLASS, prefix);
    }

    public Map<FileObject, Collection<String>> findIdsByPrefix(String prefix) {
        return this.findByPrefix(RefactoringElementType.ID, prefix);
    }

    public Map<FileObject, Collection<String>> findColorsByPrefix(String prefix) {
        return this.findByPrefix(RefactoringElementType.COLOR, prefix);
    }

    public Map<FileObject, Collection<String>> findByPrefix(RefactoringElementType type, String prefix) {
        String keyName = type.getIndexKey();
        HashMap<FileObject, Collection<String>> map = new HashMap<FileObject, Collection<String>>();
        try {
            Collection results = this.querySupport.query(keyName, prefix, QuerySupport.Kind.PREFIX, new String[]{keyName});
            for (IndexResult result : results) {
                String[] elements;
                for (String e : elements = result.getValues(keyName)) {
                    FileObject file;
                    String val = e;
                    if (!val.startsWith(prefix)) continue;
                    if (val.endsWith(VIRTUAL_ELEMENT_MARKER_STR)) {
                        val = val.substring(0, val.length() - 1);
                    }
                    if ((file = result.getFile()) == null) continue;
                    map.computeIfAbsent(file, f -> new LinkedList()).add(val);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return map;
    }

    public Map<FileObject, Collection<String>> findAll(RefactoringElementType type) {
        return this.findAll(type, true);
    }

    private Map<FileObject, Collection<String>> findAll(RefactoringElementType type, boolean includeVirtualElements) {
        String keyName = type.getIndexKey();
        HashMap<FileObject, Collection<String>> map = new HashMap<FileObject, Collection<String>>();
        try {
            Collection results = this.querySupport.query(keyName, "", QuerySupport.Kind.PREFIX, new String[]{keyName});
            for (IndexResult indexResult : this.filterDeletedFiles(results)) {
                String[] elements;
                for (String e : elements = indexResult.getValues(keyName)) {
                    String val;
                    if (e.endsWith(VIRTUAL_ELEMENT_MARKER_STR)) {
                        if (!includeVirtualElements) continue;
                        val = e.substring(0, e.length() - 1);
                    } else {
                        val = e;
                    }
                    map.computeIfAbsent(indexResult.getFile(), f -> new LinkedList()).add(val);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return map;
    }

    public Collection<FileObject> find(RefactoringElementType type, String value) {
        return this.find(type, value, true);
    }

    private Collection<FileObject> find(RefactoringElementType type, String value, boolean includeVirtualElements) {
        String keyName = type.getIndexKey();
        try {
            StringBuilder searchExpression = new StringBuilder();
            searchExpression.append(CssIndex.encodeValueForRegexp(value));
            if (includeVirtualElements) {
                searchExpression.append('!');
                searchExpression.append('?');
            }
            LinkedList<FileObject> matchedFiles = new LinkedList<FileObject>();
            Collection results = this.querySupport.query(keyName, searchExpression.toString(), QuerySupport.Kind.REGEXP, new String[]{keyName});
            for (IndexResult indexResult : this.filterDeletedFiles(results)) {
                matchedFiles.add(indexResult.getFile());
            }
            return matchedFiles;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    public Collection<FileObject> getAllIndexedFiles() {
        try {
            Collection results = this.querySupport.query("cssContent", "", QuerySupport.Kind.PREFIX, new String[]{"cssContent"});
            LinkedList<FileObject> stylesheets = new LinkedList<FileObject>();
            for (IndexResult indexResult : this.filterDeletedFiles(results)) {
                if (!indexResult.getFile().getMIMEType().equals("text/css")) continue;
                stylesheets.add(indexResult.getFile());
            }
            return stylesheets;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    public DependenciesGraph getDependencies(FileObject cssFile) {
        try {
            DependenciesGraph deps = new DependenciesGraph(cssFile);
            AllDependenciesMaps alldeps = this.getAllDependencies();
            this.resolveDependencies(deps.getSourceNode(), alldeps.getSource2dest(), alldeps.getDest2source());
            return deps;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public AllDependenciesMaps getAllDependencies() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "getAllDependencies", new Throwable());
        }
        long freshAllDeps_hashCode = CssIndexer.getImportsHashCodeForRoots(this.sourceRoots);
        StringBuilder sb = new StringBuilder();
        for (FileObject sr : this.sourceRoots) {
            sb.append(sr.getPath());
            sb.append(',');
        }
        LOGGER.log(Level.FINE, "Fresh deps hash code for roots {0} is {1}", new Object[]{sb.toString(), freshAllDeps_hashCode});
        if (this.allDepsCache != null) {
            LOGGER.fine("allDepsCache is NOT null");
            if (this.allDepsCache_hashCode == freshAllDeps_hashCode) {
                LOGGER.fine("Returning cached dependencies.");
                return this.allDepsCache;
            }
        } else {
            LOGGER.fine("allDepsCache is null");
        }
        this.allDepsCache = this.createAllDependencies();
        this.allDepsCache_hashCode = freshAllDeps_hashCode;
        LOGGER.log(Level.FINE, "Created new dependencties map with with hashcode {0}", this.allDepsCache_hashCode);
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder deps = new StringBuilder();
            deps.append("dest2source:\n");
            for (Map.Entry<FileObject, Collection<FileReference>> entry : this.allDepsCache.dest2source.entrySet()) {
                FileObject dest = entry.getKey();
                Collection<FileReference> source = entry.getValue();
                deps.append(dest.getNameExt());
                deps.append("->");
                for (FileReference fref : source) {
                    deps.append(fref.source().getNameExt());
                    deps.append(',');
                }
                deps.append('\n');
            }
            deps.append("source2dest:\n");
            for (Map.Entry<FileObject, Collection<FileReference>> entry : this.allDepsCache.source2dest.entrySet()) {
                FileObject source = entry.getKey();
                Collection<FileReference> dest = entry.getValue();
                deps.append(source.getNameExt());
                deps.append("->");
                for (FileReference fref : dest) {
                    deps.append(fref.target().getNameExt());
                    deps.append(',');
                }
                deps.append('\n');
            }
            LOGGER.log(Level.FINE, deps.toString());
        }
        return this.allDepsCache;
    }

    private AllDependenciesMaps createAllDependencies() throws IOException {
        Collection<? extends IndexResult> results = this.filterDeletedFiles(this.querySupport.query("imports", "", QuerySupport.Kind.PREFIX, new String[]{"imports"}));
        HashMap<FileObject, Collection<FileReference>> source2dests = new HashMap<FileObject, Collection<FileReference>>();
        HashMap<FileObject, Collection<FileReference>> dest2sources = new HashMap<FileObject, Collection<FileReference>>();
        for (IndexResult indexResult : results) {
            FileObject file = indexResult.getFile();
            String[] imports = indexResult.getValues("imports");
            HashSet<FileReference> imported = new HashSet<FileReference>();
            for (String importedFileName : imports) {
                FileReference resolvedReference = this.resolveImport(file, importedFileName);
                if (resolvedReference == null) continue;
                imported.add(resolvedReference);
                HashSet<FileReference> sources = (HashSet<FileReference>)dest2sources.get(resolvedReference.target());
                if (sources == null) {
                    sources = new HashSet<FileReference>();
                    dest2sources.put(resolvedReference.target(), sources);
                }
                sources.add(resolvedReference);
            }
            source2dests.put(file, imported);
        }
        return new AllDependenciesMaps(source2dests, dest2sources);
    }

    private FileReference resolveImport(FileObject source, String importedFileName) {
        String impliedUnderscoreAndSassExt;
        String extension;
        FileReference resolvedReference;
        int qmIndex = importedFileName.indexOf("?");
        if (qmIndex >= 0) {
            importedFileName = importedFileName.substring(0, qmIndex);
        }
        if ((resolvedReference = WebUtils.resolveToReference((FileObject)source, (String)importedFileName)) != null) {
            return resolvedReference;
        }
        int dotIndex = importedFileName.lastIndexOf(46);
        String string = extension = dotIndex == -1 ? null : importedFileName.substring(dotIndex + 1);
        if (extension == null || !SASS_EXT.equalsIgnoreCase(extension) && !SCSS_EXT.equals(extension)) {
            String impliedScssExt = CssIndex.createImpliedFileName(importedFileName, SCSS_EXT, false);
            resolvedReference = WebUtils.resolveToReference((FileObject)source, (String)impliedScssExt);
            if (resolvedReference != null) {
                return resolvedReference;
            }
            String impliedUnderscoreAndScssExt = CssIndex.createImpliedFileName(importedFileName, SCSS_EXT, true);
            resolvedReference = WebUtils.resolveToReference((FileObject)source, (String)impliedUnderscoreAndScssExt);
            if (resolvedReference != null) {
                return resolvedReference;
            }
            String impliedSassExt = CssIndex.createImpliedFileName(importedFileName, SASS_EXT, false);
            resolvedReference = WebUtils.resolveToReference((FileObject)source, (String)impliedSassExt);
            if (resolvedReference != null) {
                return resolvedReference;
            }
            String impliedUnderscoreAndSassExt2 = CssIndex.createImpliedFileName(importedFileName, SCSS_EXT, true);
            resolvedReference = WebUtils.resolveToReference((FileObject)source, (String)impliedUnderscoreAndSassExt2);
            if (resolvedReference != null) {
                return resolvedReference;
            }
        } else if ((SASS_EXT.equalsIgnoreCase(extension) || SCSS_EXT.equalsIgnoreCase(extension)) && (resolvedReference = WebUtils.resolveToReference((FileObject)source, (String)(impliedUnderscoreAndSassExt = CssIndex.createImpliedFileName(importedFileName, null, true)))) != null) {
            return resolvedReference;
        }
        return null;
    }

    static String createImpliedFileName(@NonNull String original, String extension, boolean underscore) {
        if (extension == null && !underscore) {
            return original;
        }
        if (!underscore) {
            return original + '.' + extension;
        }
        int separatorIndex = original.lastIndexOf(47);
        if (separatorIndex == -1) {
            separatorIndex = original.lastIndexOf(92);
        }
        if (separatorIndex == -1) {
            return '_' + original + (extension == null ? "" : Character.valueOf('.')) + (extension == null ? "" : extension);
        }
        return original.substring(0, separatorIndex + 1) + '_' + original.substring(separatorIndex + 1) + (extension == null ? "" : Character.valueOf('.')) + (extension == null ? "" : extension);
    }

    private void resolveDependencies(DependenciesGraph.Node base, Map<FileObject, Collection<FileReference>> source2dests, Map<FileObject, Collection<FileReference>> dest2sources) {
        Collection<FileReference> sources;
        FileObject baseFile = base.getFile();
        Collection<FileReference> destinations = source2dests.get(baseFile);
        if (destinations != null) {
            for (FileReference destinationReference : destinations) {
                FileObject destination = destinationReference.target();
                DependenciesGraph.Node node = base.getDependencyGraph().getNode(destination);
                if (!base.addReferedNode(node)) continue;
                this.resolveDependencies(node, source2dests, dest2sources);
            }
        }
        if ((sources = dest2sources.get(baseFile)) != null) {
            for (FileReference sourceReference : sources) {
                FileObject source = sourceReference.source();
                DependenciesGraph.Node node = base.getDependencyGraph().getNode(source);
                if (!base.addReferingNode(node)) continue;
                this.resolveDependencies(node, source2dests, dest2sources);
            }
        }
    }

    private Collection<? extends IndexResult> filterDeletedFiles(Collection<? extends IndexResult> queryResult) {
        ArrayList<IndexResult> filtered = new ArrayList<IndexResult>();
        for (IndexResult indexResult : queryResult) {
            if (indexResult.getFile() == null) continue;
            filtered.add(indexResult);
        }
        return filtered;
    }

    static String encodeValueForRegexp(String value) {
        StringBuilder encoded = new StringBuilder();
        block0: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            for (int j = 0; j < REGEXP_CHARS_TO_ENCODE.length(); ++j) {
                if (c != REGEXP_CHARS_TO_ENCODE.charAt(j)) continue;
                encoded.append('\\');
                encoded.append(c);
                continue block0;
            }
            encoded.append(c);
        }
        return encoded.toString();
    }

    public static class AllDependenciesMaps {
        Map<FileObject, Collection<FileReference>> source2dest;
        Map<FileObject, Collection<FileReference>> dest2source;

        public AllDependenciesMaps(Map<FileObject, Collection<FileReference>> source2dest, Map<FileObject, Collection<FileReference>> dest2source) {
            this.source2dest = source2dest;
            this.dest2source = dest2source;
        }

        public Map<FileObject, Collection<FileReference>> getDest2source() {
            return this.dest2source;
        }

        public Map<FileObject, Collection<FileReference>> getSource2dest() {
            return this.source2dest;
        }
    }
}

