/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

public class WordDelineator {
    private String delimiters = new String();

    private WordDelineator(String delimeters) {
        this.delimiters = delimeters;
    }

    protected int charClass(char c) {
        if (this.delimiters.indexOf(c) >= 0) {
            return 2;
        }
        return 0;
    }

    protected int findLeft(StringBuffer buf, int start, boolean useLineBound) {
        int lx;
        int cclass = this.charClass(buf.charAt(start));
        boolean success = false;
        for (lx = start; lx > 0; --lx) {
            boolean bl = success = this.charClass(buf.charAt(lx - 1)) != cclass;
            if (success) break;
        }
        return !success && useLineBound ? -1 : lx;
    }

    protected int findRight(StringBuffer buf, int start, boolean useLineBound) {
        int rx;
        int cclass = this.charClass(buf.charAt(start));
        boolean success = false;
        for (rx = start; rx < buf.length(); ++rx) {
            boolean bl = success = this.charClass(buf.charAt(rx)) != cclass;
            if (success) break;
        }
        return !success && useLineBound ? -1 : --rx;
    }

    public static WordDelineator createCustomDelineator(String delimeters) {
        if (delimeters.contains(" ")) {
            return new WordDelineator(delimeters);
        }
        return new WordDelineator(delimeters.concat(" "));
    }

    public static WordDelineator createNewlineDelineator() {
        return new WordDelineator("\n");
    }
}

