/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListDataGuardAssociationsRequest
extends BmcRequest<Void> {
    private String databaseId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"databaseId", "limit", "page"})
    ListDataGuardAssociationsRequest(String databaseId, Integer limit, String page) {
        this.databaseId = databaseId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).limit(this.limit).page(this.page);
    }

    public String toString() {
        return "ListDataGuardAssociationsRequest(super=" + super.toString() + ", databaseId=" + this.getDatabaseId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDataGuardAssociationsRequest)) {
            return false;
        }
        ListDataGuardAssociationsRequest other = (ListDataGuardAssociationsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$databaseId = this.getDatabaseId();
        String other$databaseId = other.getDatabaseId();
        if (this$databaseId == null ? other$databaseId != null : !this$databaseId.equals(other$databaseId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListDataGuardAssociationsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $databaseId = this.getDatabaseId();
        result = result * 59 + ($databaseId == null ? 43 : $databaseId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDataGuardAssociationsRequest, Void> {
        private String databaseId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDataGuardAssociationsRequest o) {
            this.databaseId(o.getDatabaseId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDataGuardAssociationsRequest build() {
            ListDataGuardAssociationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListDataGuardAssociationsRequest buildWithoutInvocationCallback() {
            return new ListDataGuardAssociationsRequest(this.databaseId, this.limit, this.page);
        }

        public String toString() {
            return "ListDataGuardAssociationsRequest.Builder(databaseId=" + this.databaseId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

