/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.DbServerSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDbServersRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String exadataInfrastructureId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private String opcRequestId;
    private SortBy sortBy;
    private DbServerSummary.LifecycleState lifecycleState;
    private String displayName;

    @ConstructorProperties(value={"compartmentId", "exadataInfrastructureId", "limit", "page", "sortOrder", "opcRequestId", "sortBy", "lifecycleState", "displayName"})
    ListDbServersRequest(String compartmentId, String exadataInfrastructureId, Integer limit, String page, SortOrder sortOrder, String opcRequestId, SortBy sortBy, DbServerSummary.LifecycleState lifecycleState, String displayName) {
        this.compartmentId = compartmentId;
        this.exadataInfrastructureId = exadataInfrastructureId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.opcRequestId = opcRequestId;
        this.sortBy = sortBy;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).exadataInfrastructureId(this.exadataInfrastructureId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).sortBy(this.sortBy).lifecycleState(this.lifecycleState).displayName(this.displayName);
    }

    public String toString() {
        return "ListDbServersRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", exadataInfrastructureId=" + this.getExadataInfrastructureId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", opcRequestId=" + this.getOpcRequestId() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", displayName=" + this.getDisplayName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDbServersRequest)) {
            return false;
        }
        ListDbServersRequest other = (ListDbServersRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$exadataInfrastructureId = this.getExadataInfrastructureId();
        String other$exadataInfrastructureId = other.getExadataInfrastructureId();
        if (this$exadataInfrastructureId == null ? other$exadataInfrastructureId != null : !this$exadataInfrastructureId.equals(other$exadataInfrastructureId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        DbServerSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        DbServerSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListDbServersRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $exadataInfrastructureId = this.getExadataInfrastructureId();
        result = result * 59 + ($exadataInfrastructureId == null ? 43 : $exadataInfrastructureId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        DbServerSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getExadataInfrastructureId() {
        return this.exadataInfrastructureId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public DbServerSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbServersRequest, Void> {
        private String compartmentId;
        private String exadataInfrastructureId;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private String opcRequestId;
        private SortBy sortBy;
        private DbServerSummary.LifecycleState lifecycleState;
        private String displayName;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbServersRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.exadataInfrastructureId(o.getExadataInfrastructureId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.sortBy(o.getSortBy());
            this.lifecycleState(o.getLifecycleState());
            this.displayName(o.getDisplayName());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbServersRequest build() {
            ListDbServersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder exadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder lifecycleState(DbServerSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ListDbServersRequest buildWithoutInvocationCallback() {
            return new ListDbServersRequest(this.compartmentId, this.exadataInfrastructureId, this.limit, this.page, this.sortOrder, this.opcRequestId, this.sortBy, this.lifecycleState, this.displayName);
        }

        public String toString() {
            return "ListDbServersRequest.Builder(compartmentId=" + this.compartmentId + ", exadataInfrastructureId=" + this.exadataInfrastructureId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", opcRequestId=" + this.opcRequestId + ", sortBy=" + (Object)((Object)this.sortBy) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", displayName=" + this.displayName + ")";
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

