/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

public final class ToStringGenerator
extends CodeActionsProvider {
    private static final String URI = "uri";
    private static final String OFFSET = "offset";
    private static final String FIELDS = "fields";
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        int offset = ToStringGenerator.getOffset((CompilationInfo)info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement type = (TypeElement)info.getTrees().getElement(tp);
        if (type == null || !type.getKind().isClass()) {
            return Collections.emptyList();
        }
        ArrayList<QuickPickItem> fields = new ArrayList<QuickPickItem>();
        for (Element element : type.getEnclosedElements()) {
            switch (element.getKind()) {
                case METHOD: {
                    if (!element.getSimpleName().contentEquals("toString") || !((ExecutableElement)element).getParameters().isEmpty()) break;
                    return Collections.emptyList();
                }
                case FIELD: {
                    if ("<error>".contentEquals(element.getSimpleName()) || element.getModifiers().contains((Object)Modifier.STATIC)) break;
                    QuickPickItem item = new QuickPickItem(ToStringGenerator.createLabel((CompilationInfo)info, (VariableElement)element));
                    item.setUserData(new CodeActionsProvider.ElementData(element));
                    fields.add(item);
                }
            }
        }
        String uri = Utils.toUri(info.getFileObject());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(URI, uri);
        hashMap.put(OFFSET, offset);
        hashMap.put(FIELDS, fields);
        return Collections.singletonList(this.createCodeAction(Bundle.DN_GenerateToString(), "source.generate", hashMap, fields.isEmpty() ? null : "workbench.action.focusActiveEditorGroup", new Object[0]));
    }

    @Override
    public CompletableFuture<CodeAction> resolve(NbCodeLanguageClient client, CodeAction codeAction, Object data) {
        CompletableFuture<CodeAction> future = new CompletableFuture<CodeAction>();
        try {
            String uri = ((JsonObject)data).getAsJsonPrimitive(URI).getAsString();
            int offset = ((JsonObject)data).getAsJsonPrimitive(OFFSET).getAsInt();
            List<QuickPickItem> fields = Arrays.asList((QuickPickItem[])this.gson.fromJson(((JsonObject)data).get(FIELDS), QuickPickItem[].class));
            if (fields.isEmpty()) {
                WorkspaceEdit edit = this.generate(uri, offset, fields);
                if (edit != null) {
                    codeAction.setEdit(edit);
                }
                future.complete(codeAction);
            } else {
                client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectToString(), true, fields)).thenAccept(selected -> {
                    try {
                        WorkspaceEdit edit;
                        if (selected != null && (edit = this.generate(uri, offset, fields)) != null) {
                            codeAction.setEdit(edit);
                        }
                        future.complete(codeAction);
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        future.completeExceptionally(ex);
                    }
                });
            }
        }
        catch (JsonSyntaxException | IOException | IllegalArgumentException ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    private WorkspaceEdit generate(String uri, int offset, List<QuickPickItem> fields) throws IOException, IllegalArgumentException {
        FileObject file = Utils.fromUri(uri);
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            throw new IOException("Cannot get JavaSource for: " + uri);
        }
        List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TreePath tp = wc.getTreeUtilities().pathFor(offset);
            tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
            if (tp != null) {
                ClassTree cls = (ClassTree)tp.getLeaf();
                List selectedFields = fields.stream().map(item -> {
                    CodeActionsProvider.ElementData data = (CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeActionsProvider.ElementData.class);
                    return (VariableElement)data.resolve((CompilationInfo)wc);
                }).collect(Collectors.toList());
                MethodTree method = org.netbeans.modules.java.editor.codegen.ToStringGenerator.createToStringMethod((WorkingCopy)wc, selectedFields, (String)cls.getSimpleName().toString(), (boolean)true);
                wc.rewrite((Tree)cls, (Tree)GeneratorUtilities.get((WorkingCopy)wc).insertClassMember(cls, (Tree)method));
            }
        }));
        return edits.isEmpty() ? null : new WorkspaceEdit(Collections.singletonMap(uri, edits));
    }
}

