/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.Border;

public final class CompositeBorder
implements Border {
    private Border[] borders;
    private Insets insets;

    public CompositeBorder(Border ... borders) {
        this.borders = borders;
        Insets result = new Insets(0, 0, 0, 0);
        for (Border border : borders) {
            Insets insets = border.getInsets();
            result.top += insets.top;
            result.left += insets.left;
            result.bottom += insets.bottom;
            result.right += insets.right;
        }
        this.insets = result;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void paint(Graphics2D gr, Rectangle bounds) {
        for (Border border : this.borders) {
            border.paint(gr, new Rectangle(bounds));
            Insets insets = border.getInsets();
            bounds.x += insets.left;
            bounds.width -= insets.left + insets.right;
            bounds.y += insets.top;
            bounds.height -= insets.top + insets.bottom;
        }
    }

    @Override
    public boolean isOpaque() {
        for (Border border : this.borders) {
            if (!border.isOpaque()) continue;
            return true;
        }
        return false;
    }
}

