/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteApiKeyRequest
extends BmcRequest<Void> {
    private String userId;
    private String fingerprint;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "fingerprint", "ifMatch"})
    DeleteApiKeyRequest(String userId, String fingerprint, String ifMatch) {
        this.userId = userId;
        this.fingerprint = fingerprint;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).fingerprint(this.fingerprint).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DeleteApiKeyRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", fingerprint=" + this.getFingerprint() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteApiKeyRequest)) {
            return false;
        }
        DeleteApiKeyRequest other = (DeleteApiKeyRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteApiKeyRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteApiKeyRequest, Void> {
        private String userId;
        private String fingerprint;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteApiKeyRequest o) {
            this.userId(o.getUserId());
            this.fingerprint(o.getFingerprint());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteApiKeyRequest build() {
            DeleteApiKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteApiKeyRequest buildWithoutInvocationCallback() {
            return new DeleteApiKeyRequest(this.userId, this.fingerprint, this.ifMatch);
        }

        public String toString() {
            return "DeleteApiKeyRequest.Builder(userId=" + this.userId + ", fingerprint=" + this.fingerprint + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

