/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitSubmoduleStatus;
import org.netbeans.libs.git.jgit.DelegatingGitProgressMonitor;
import org.netbeans.libs.git.jgit.DelegatingProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.SubmoduleStatusCommand;
import org.netbeans.libs.git.jgit.commands.TransportCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class SubmoduleUpdateCommand
extends TransportCommand {
    private final File[] roots;
    private final SubmoduleStatusCommand statusCmd;
    private final ProgressMonitor monitor;

    public SubmoduleUpdateCommand(Repository repository, GitClassFactory classFactory, File[] roots, ProgressMonitor monitor) {
        super(repository, classFactory, "origin", monitor);
        this.monitor = monitor;
        this.roots = roots;
        this.statusCmd = new SubmoduleStatusCommand(repository, this.getClassFactory(), roots, new DelegatingGitProgressMonitor(monitor));
    }

    @Override
    protected void runTransportCommand() throws GitException {
        Repository repository = this.getRepository();
        File workTree = repository.getWorkTree();
        org.eclipse.jgit.api.SubmoduleUpdateCommand cmd = new Git(repository).submoduleUpdate();
        for (File root : this.roots) {
            cmd.addPath(Utils.getRelativePath(workTree, root));
            try {
                cmd.setProgressMonitor((org.eclipse.jgit.lib.ProgressMonitor)new DelegatingProgressMonitor(this.monitor));
                cmd.setCredentialsProvider(this.getCredentialsProvider());
                cmd.setTimeout(45);
                cmd.call();
            }
            catch (org.eclipse.jgit.api.errors.TransportException e) {
                URIish uriish = null;
                try {
                    uriish = this.getUriWithUsername(false);
                }
                catch (URISyntaxException ex) {
                    throw new GitException(e.getMessage(), e);
                }
                Utils.deleteRecursively(new File(root, ".git"));
                this.handleException(new TransportException(e.getMessage(), (Throwable)e), uriish);
            }
            catch (GitAPIException | JGitInternalException ex) {
                throw new GitException(ex);
            }
        }
        this.statusCmd.run();
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git submodule update");
        for (File root : this.roots) {
            sb.append(" ").append(root.getAbsolutePath());
        }
        return sb.toString();
    }

    public Map<File, GitSubmoduleStatus> getStatuses() {
        return this.statusCmd.getStatuses();
    }
}

