/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasPort;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNode;
import org.netbeans.modules.websvc.saas.ui.nodes.WsdlPortNodeChildren;
import org.netbeans.modules.websvc.saas.util.SaasTransferable;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class WsdlPortNode
extends AbstractNode {
    private WsdlSaasPort port;
    private Transferable transferable;
    private static final Image ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/ui/resources/wsport-closed.png");
    private static final Image OPENED_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/ui/resources/wsport-open.png");

    public WsdlPortNode(WsdlSaasPort port) {
        this(port, new InstanceContent());
    }

    private WsdlPortNode(WsdlSaasPort port, InstanceContent content) {
        super((Children)new WsdlPortNodeChildren(port), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.port = port;
        content.add((Object)port);
        this.transferable = ExTransferable.create((Transferable)new SaasTransferable((Object)port, SaasTransferable.WSDL_PORT_FLAVORS));
    }

    public String getDisplayName() {
        return this.port.getName();
    }

    public Action[] getActions(boolean context) {
        List<Action> actions = SaasNode.getActions(this.getLookup());
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        Action[] actions = this.getActions(true);
        return actions.length > 0 ? actions[0] : null;
    }

    public Image getIcon(int type) {
        return ICON;
    }

    public Image getOpenedIcon(int type) {
        return OPENED_ICON;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set ss = sheet.get("data");
        if (ss == null) {
            ss = new Sheet.Set();
            ss.setName("data");
            ss.setDisplayName(NbBundle.getMessage(WsdlPortNode.class, (String)"WS_INFO"));
            ss.setShortDescription(NbBundle.getMessage(WsdlPortNode.class, (String)"WS_INFO"));
            sheet.put(ss);
        }
        ss.put((Node.Property)new PropertySupport.ReadOnly<String>("port", String.class, NbBundle.getMessage(WsdlPortNode.class, (String)"PORT_NAME_IN_WSDL"), NbBundle.getMessage(WsdlPortNode.class, (String)"PORT_NAME_IN_WSDL")){

            public String getValue() {
                String portName = WsdlPortNode.this.port.getName();
                return portName;
            }
        });
        ss.put((Node.Property)new PropertySupport.ReadOnly<String>("URL", String.class, NbBundle.getMessage(WsdlPortNode.class, (String)"WS_URL"), NbBundle.getMessage(WsdlPortNode.class, (String)"WS_URL")){

            public String getValue() {
                return WsdlPortNode.this.port.getParentSaas().getUrl();
            }
        });
        return sheet;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public Transferable clipboardCopy() throws IOException {
        if (this.port.getParentSaas().getState() != Saas.State.READY) {
            this.port.getParentSaas().toStateReady(false);
            return super.clipboardCopy();
        }
        return SaasTransferable.addFlavors((Transferable)this.transferable);
    }
}

