/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions.usages.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.actions.usages.ui.Bundle;
import org.netbeans.modules.maven.indexer.api.NBArtifactInfo;
import org.netbeans.modules.maven.indexer.api.NBGroupInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.api.ui.ArtifactViewer;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.NotificationLineSupport;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public final class UsagesUI
extends JPanel
implements ExplorerManager.Provider {
    private static final String ARTIFACT_BADGE = "org/netbeans/modules/maven/actions/usages/ArtifactBadge.png";
    static final int TYPE_DEPENDENCY = 0;
    static final int TYPE_COMPILE = 1;
    static final int TYPE_TEST = 2;
    static final int TYPE_RUNTIME = 3;
    private final ExplorerManager explorerManager = new ExplorerManager();
    private NotificationLineSupport nls;
    private final Artifact artifact;
    private final String libDef;
    private JScrollPane jScrollPane1;

    public UsagesUI(String libDef, Artifact artifact) {
        this.initComponents();
        this.libDef = libDef;
        this.artifact = artifact;
    }

    void initNodes(final String libDef, final Artifact artifact) {
        Children.Keys<Integer> openProjectsChildren = new Children.Keys<Integer>(){

            protected Node[] createNodes(Integer type) {
                final List<NbMavenProjectImpl> openProjects = UsagesUI.this.getOpenProjects(artifact, type);
                Children.Keys<NbMavenProjectImpl> children = new Children.Keys<NbMavenProjectImpl>(){

                    protected Node[] createNodes(NbMavenProjectImpl nmp) {
                        return new Node[]{new OpenProjectNode(nmp)};
                    }

                    protected void addNotify() {
                        super.addNotify();
                        this.setKeys(openProjects);
                    }
                };
                AbstractNode node = new AbstractNode((Children)children){

                    public String getHtmlDisplayName() {
                        return this.getDisplayName();
                    }

                    public Image getIcon(int arg0) {
                        return NodeUtils.getTreeFolderIcon(false);
                    }

                    public Image getOpenedIcon(int arg0) {
                        return NodeUtils.getTreeFolderIcon(true);
                    }
                };
                switch (type) {
                    case 0: {
                        node.setDisplayName(Bundle.LBL_Dependancy());
                        break;
                    }
                    case 1: {
                        node.setDisplayName(Bundle.LBL_TYPE_COMPILE());
                        break;
                    }
                    case 2: {
                        node.setDisplayName(Bundle.LBL_TYPE_TEST());
                        break;
                    }
                    case 3: {
                        node.setDisplayName(Bundle.LBL_TYPE_RUNTIME());
                    }
                }
                return new Node[]{node};
            }

            protected void addNotify() {
                super.addNotify();
                this.setKeys(new Integer[]{0, 1, 2, 3});
            }
        };
        final AbstractNode openProjectsNode = new AbstractNode((Children)openProjectsChildren){

            public String getHtmlDisplayName() {
                return Bundle.LBL_Description(libDef);
            }

            public Image getIcon(int arg0) {
                return NodeUtils.getTreeFolderIcon(false);
            }

            public Image getOpenedIcon(int arg0) {
                return NodeUtils.getTreeFolderIcon(true);
            }
        };
        RepositoryQueries.Result result = RepositoryQueries.findDependencyUsageResult((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion(), null);
        final List list = result.getResults();
        this.nls.setWarningMessage(Bundle.LBL_Incomplete());
        Children.Keys<NBGroupInfo> repoChildren = new Children.Keys<NBGroupInfo>(){

            protected Node[] createNodes(NBGroupInfo ug) {
                return new Node[]{new GroupNode(ug)};
            }

            protected void addNotify() {
                super.addNotify();
                this.setKeys(list);
            }
        };
        AbstractNode repoNode = new AbstractNode((Children)repoChildren){

            public String getHtmlDisplayName() {
                return Bundle.LBL_Repo(libDef);
            }

            public Image getIcon(int arg0) {
                return NodeUtils.getTreeFolderIcon(false);
            }

            public Image getOpenedIcon(int arg0) {
                return NodeUtils.getTreeFolderIcon(true);
            }
        };
        Children.Array array = new Children.Array();
        array.add(new Node[]{openProjectsNode, repoNode});
        this.explorerManager.setRootContext((Node)new AbstractNode((Children)array));
        final BeanTreeView beanTreeView = (BeanTreeView)this.jScrollPane1;
        beanTreeView.setPopupAllowed(false);
        beanTreeView.setRootVisible(false);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        beanTreeView.expandAll();
                    }
                });
            }
        }, 100);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    UsagesUI.this.explorerManager.setSelectedNodes(new Node[]{openProjectsNode});
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, 600);
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder(null, UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 524, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 447, Short.MAX_VALUE)));
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public List<NbMavenProjectImpl> getOpenProjects(Artifact artifact, int type) {
        Project[] prjs;
        ArrayList<NbMavenProjectImpl> mavenProjects = new ArrayList<NbMavenProjectImpl>();
        block6: for (Project project : prjs = OpenProjects.getDefault().getOpenProjects()) {
            NbMavenProjectImpl mavProj = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
            if (mavProj == null) continue;
            MavenProject mp = mavProj.getOriginalMavenProject();
            ArrayList artifacts = new ArrayList();
            switch (type) {
                case 0: {
                    Set deps = mp.getDependencyArtifacts();
                    if (deps == null) break;
                    artifacts.addAll(deps);
                    break;
                }
                case 1: {
                    List compArtifs = mp.getCompileArtifacts();
                    if (compArtifs == null) break;
                    artifacts.addAll(compArtifs);
                    break;
                }
                case 2: {
                    List compArtifs;
                    List testArtifs = mp.getTestArtifacts();
                    if (testArtifs != null) {
                        artifacts.addAll(testArtifs);
                    }
                    if ((compArtifs = mp.getCompileArtifacts()) == null) break;
                    artifacts.removeAll(compArtifs);
                    break;
                }
                case 3: {
                    List compArtifs;
                    List runtimeArtifs = mp.getRuntimeArtifacts();
                    if (runtimeArtifs != null) {
                        artifacts.addAll(runtimeArtifs);
                    }
                    if ((compArtifs = mp.getCompileArtifacts()) == null) break;
                    artifacts.removeAll(compArtifs);
                }
            }
            for (Artifact d : artifacts) {
                if (!d.getGroupId().equals(artifact.getGroupId()) || !d.getArtifactId().equals(artifact.getArtifactId()) || !d.getVersion().equals(artifact.getVersion())) continue;
                mavenProjects.add(mavProj);
                continue block6;
            }
        }
        return mavenProjects;
    }

    public void initialize(NotificationLineSupport nls) {
        assert (nls != null);
        this.nls = nls;
        this.initNodes(this.libDef, this.artifact);
    }

    private static class OpenProjectNode
    extends AbstractNode {
        private final NbMavenProjectImpl project;
        private final ProjectInformation pi;

        public OpenProjectNode(NbMavenProjectImpl project) {
            super(Children.LEAF);
            this.project = project;
            this.pi = ProjectUtils.getInformation((Project)project);
        }

        public Image getIcon(int arg0) {
            return ImageUtilities.icon2Image((Icon)this.pi.getIcon());
        }

        public String getDisplayName() {
            return this.pi.getDisplayName();
        }
    }

    private static class VersionNode
    extends AbstractNode {
        NBVersionInfo version;

        public VersionNode(NBVersionInfo version) {
            super(Children.LEAF);
            this.version = version;
            this.setIconBaseWithExtension("org/netbeans/modules/maven/DependencyIcon.png");
        }

        public String getDisplayName() {
            return this.version.getVersion() + " [ " + this.version.getType() + " ]";
        }

        public Action getPreferredAction() {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArtifactViewer.showArtifactViewer((NBVersionInfo)version);
                }
            };
        }
    }

    private static class ArtifactNode
    extends AbstractNode {
        NBArtifactInfo artifact;

        public ArtifactNode(final NBArtifactInfo artifact) {
            super((Children)new Children.Keys<NBVersionInfo>(){

                protected Node[] createNodes(NBVersionInfo arg0) {
                    return new Node[]{new VersionNode(arg0)};
                }

                protected void addNotify() {
                    super.addNotify();
                    this.setKeys(artifact.getVersionInfos());
                }
            });
            this.artifact = artifact;
        }

        public Image getIcon(int arg0) {
            Image badge = ImageUtilities.loadImage((String)UsagesUI.ARTIFACT_BADGE, (boolean)true);
            return badge;
        }

        public Image getOpenedIcon(int arg0) {
            return this.getIcon(arg0);
        }

        public String getDisplayName() {
            return this.artifact.getName();
        }
    }

    private static class GroupNode
    extends AbstractNode {
        NBGroupInfo group;

        public GroupNode(final NBGroupInfo group) {
            super((Children)new Children.Keys<NBArtifactInfo>(){

                protected Node[] createNodes(NBArtifactInfo arg0) {
                    return new Node[]{new ArtifactNode(arg0)};
                }

                protected void addNotify() {
                    super.addNotify();
                    this.setKeys(group.getArtifactInfos());
                }
            });
            this.group = group;
        }

        public Image getIcon(int arg0) {
            return NodeUtils.getTreeFolderIcon(false);
        }

        public Image getOpenedIcon(int arg0) {
            return NodeUtils.getTreeFolderIcon(true);
        }

        public String getDisplayName() {
            return this.group.getName();
        }
    }
}

