/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.nodes.AnnotatedAbstractNode;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.modules.maven.nodes.OthersRootNode;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

public class ProjectFilesNode
extends AnnotatedAbstractNode {
    private static final String PF_BADGE = "org/netbeans/modules/maven/projectfiles-badge.png";
    private final NbMavenProjectImpl project;

    public ProjectFilesNode(NbMavenProjectImpl project) {
        super(Children.create((ChildFactory)new ProjectFilesChildren(project), (boolean)true), Lookups.fixed((Object[])new Object[]{project.getProjectDirectory(), new OthersRootNode.ChildDelegateFind()}));
        this.setName("projectfiles");
        this.setDisplayName(Bundle.LBL_Project_Files());
        this.project = project;
        this.setMyFiles();
    }

    public Action[] getActions(boolean context) {
        ArrayList<AddSettingsXmlAction> col = new ArrayList<AddSettingsXmlAction>();
        if (!SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.exists()) {
            col.add(new AddSettingsXmlAction());
        }
        return col.toArray(new Action[col.size()]);
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)PF_BADGE, (boolean)true);
        Image img = ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
        return img;
    }

    @Override
    protected Image getIconImpl(int param) {
        return this.getIcon(false);
    }

    @Override
    protected Image getOpenedIconImpl(int param) {
        return this.getIcon(true);
    }

    private void setMyFiles() {
        HashSet<FileObject> fobs = new HashSet<FileObject>();
        FileObject fo = this.project.getProjectDirectory().getFileObject("pom.xml");
        if (fo != null) {
            fobs.add(fo);
        }
        this.setFiles(fobs);
    }

    private static class AddSettingsXmlAction
    extends AbstractAction {
        AddSettingsXmlAction() {
            super(Bundle.BTN_Create_settings_xml());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                File sf = FileUtilities.getUserSettingsFile(true);
                EditCookie cook = (EditCookie)DataObject.find((FileObject)FileUtil.toFileObject((File)sf)).getLookup().lookup(EditCookie.class);
                if (cook != null) {
                    cook.edit();
                }
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(ProjectFilesNode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static class ProjectFilesChildren
    extends ChildFactory.Detachable<FileObject>
    implements PropertyChangeListener {
        private final NbMavenProjectImpl project;
        private final FileChangeAdapter fileChangeListener;

        ProjectFilesChildren(NbMavenProjectImpl proj) {
            this.project = proj;
            this.fileChangeListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    this.refresh(false);
                }

                public void fileDeleted(FileEvent fe) {
                    this.refresh(false);
                }
            };
        }

        protected Node createNodeForKey(FileObject key) {
            try {
                return DataObject.find((FileObject)key).getNodeDelegate().cloneNode();
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.refresh(false);
            }
        }

        protected void addNotify() {
            NbMavenProject.addPropertyChangeListener(this.project, this);
            this.project.getProjectDirectory().addFileChangeListener((FileChangeListener)this.fileChangeListener);
        }

        protected void removeNotify() {
            NbMavenProject.removePropertyChangeListener(this.project, this);
            this.project.getProjectDirectory().removeFileChangeListener((FileChangeListener)this.fileChangeListener);
        }

        protected boolean createKeys(List<FileObject> keys) {
            FileObject d = this.project.getProjectDirectory();
            keys.add(d.getFileObject("pom.xml"));
            keys.add(d.getFileObject("nbactions.xml"));
            for (FileObject kid : d.getChildren()) {
                String n = kid.getNameExt();
                if (!n.startsWith("nbactions-") || !n.endsWith(".xml")) continue;
                keys.add(kid);
            }
            keys.add(d.getFileObject("nb-configuration.xml"));
            keys.add(FileUtil.toFileObject((File)SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE));
            keys.removeAll(Collections.singleton(null));
            return true;
        }
    }
}

