/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.adapter;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.util.BuffTool;
import org.apache.tomcat.util.BufferEvent;
import org.apache.tomcat.util.BufferListener;
import org.apache.tomcat.util.ByteBuffer;
import org.apache.tomcat.util.MimeHeaderField;
import org.apache.tomcat.util.MimeHeaders;
import org.apache.tomcat.util.RecycleBufferedInputStream;

public final class HttpAdapter
implements BufferListener {
    protected OutputStream sout;
    static int debug = 0;
    ContextManager contextM;
    RequestImpl req;
    ResponseImpl res;
    RecycleBufferedInputStream in;
    public static final int MAX_HEAD_LEN = 8192;
    byte[] buf = new byte[8192];
    int off = 0;
    int count = 0;
    int readLimit = -1;
    int readCount = 0;
    private Socket socket;
    public static final String DEFAULT_CHARACTER_ENCODING = "8859_1";
    protected static final int DEFAULT_HEAD_BUFFER_SIZE = 1024;
    protected byte[] headBuffer = new byte[1024];
    protected int bufferCount = 0;
    static final byte[] NAME_DELIMS = new byte[]{58, 32, 9, 13, 10};
    static final byte[] SPACE_DELIMS = new byte[]{32, 9};

    public void init(ContextManager contextM) {
        ByteBuffer ob = new ByteBuffer();
        ByteBuffer ib = new ByteBuffer();
        ob.addBufferListener(this);
        ib.addBufferListener(this);
        this.req = new RequestImpl();
        this.res = new ResponseImpl();
        this.res.setOutputBuffer(ob);
        this.req.setInputBuffer(ib);
        this.contextM = contextM;
        contextM.initRequest(this.req, this.res);
    }

    public void readNextRequest() throws IOException {
        this.readNextRequest(this.req, this.res);
        int contentLength = this.req.getContentLength();
        if (contentLength != -1) {
            this.readLimit = contentLength;
        }
    }

    public void setSocket(Socket socket) throws IOException {
        if (this.in == null) {
            this.in = new RecycleBufferedInputStream(socket.getInputStream());
        } else {
            this.in.setInputStream(socket.getInputStream());
        }
        this.sout = socket.getOutputStream();
        this.socket = socket;
    }

    public Request getRequest() {
        return this.req;
    }

    public Response getResponse() {
        return this.res;
    }

    public void recycle() {
        this.bufferCount = 0;
        this.readLimit = -1;
        this.readCount = 0;
    }

    void log(String s) {
        System.out.println("HttpAdapter: " + s);
    }

    public void setDebug(int debug) {
        HttpAdapter.debug = debug;
    }

    public void bufferEmpty(BufferEvent ev) {
        try {
            if (debug > 0) {
                this.log("Buffer empty event ");
            }
            ByteBuffer bb = (ByteBuffer)ev.getSource();
            ResponseImpl resp = (ResponseImpl)bb.getParent();
            int len = ev.getLength();
            if (this.readLimit >= 0 && this.readCount + len >= this.readLimit) {
                len = this.readLimit - this.readCount;
            }
            int n = 0;
            if (len >= 0) {
                n = this.in.read(ev.getByteBuffer(), ev.getOffset(), len);
            }
            ev.setLength(n);
            this.readCount += n;
            if (debug > 0) {
                this.log("Read: " + this.readLimit + " " + this.readCount + " " + n + " " + len + " " + ev.getLength());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void bufferFull(BufferEvent ev) {
        block4: {
            try {
                ByteBuffer bb;
                ResponseImpl resp;
                if (debug > 0) {
                    this.log("Buffer full event ");
                }
                if (!(resp = (ResponseImpl)(bb = (ByteBuffer)ev.getSource()).getParent()).isBufferCommitted()) {
                    resp.notifyEndHeaders();
                    this.sendHead(resp);
                    resp.setBufferCommitted(true);
                }
                this.sout.write(ev.getByteBuffer(), ev.getOffset(), ev.getLength());
            }
            catch (IOException ex) {
                if ("Broken pipe".equals(ex.getMessage())) break block4;
                ex.printStackTrace();
            }
        }
    }

    private void sendHead(ResponseImpl resp) throws IOException {
        if (debug > 0) {
            this.log("Sending head ");
        }
        Request request = resp.getRequest();
        int status = resp.getStatus();
        String message = ResponseImpl.getMessage(status);
        MimeHeaders headers = resp.getMimeHeaders();
        this.headAppend("HTTP/1.0 ");
        this.headAppend(String.valueOf(status));
        if (message != null) {
            this.headAppend(" ");
            this.headAppend(message);
        }
        this.headAppend("\r\n");
        MimeHeaderField dateH = headers.find("Date");
        if (request.getContext() != null) {
            this.headAppend("Servlet-Engine: ");
            this.headAppend(request.getContext().getEngineHeader());
        }
        int count = headers.size();
        int i = 0;
        while (i < count) {
            MimeHeaderField field = headers.getField(i);
            this.headAppend(field.getName());
            this.headAppend(": ");
            this.headAppend(field.getValue());
            this.headAppend("\r\n");
            ++i;
        }
        this.headAppend("\r\n");
        this.sout.write(this.headBuffer, 0, this.bufferCount);
        this.sout.flush();
    }

    protected void headAppend(String s) {
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if ((c & 0xFF00) != 0) {
                System.out.println("Header character is not iso8859_1, not supported yet: " + c);
            }
            if (this.bufferCount >= this.headBuffer.length) {
                byte[] bufferNew = new byte[this.headBuffer.length * 2];
                System.arraycopy(this.headBuffer, 0, bufferNew, 0, this.headBuffer.length);
                this.headBuffer = bufferNew;
            }
            this.headBuffer[this.bufferCount] = (byte)c;
            ++this.bufferCount;
            ++i;
        }
    }

    private void readNextRequest(Request req, Response response) throws IOException {
        this.count = BuffTool.readLine(this.in, this.buf, 0, this.buf.length);
        if (this.count < 0) {
            response.setStatus(400);
            return;
        }
        int status = this.processRequestLine(req);
        if (status != 0) {
            response.setStatus(status);
            return;
        }
        if (req.getProtocol() != null && (status = this.readHeaders(req)) != 0) {
            response.setStatus(status);
            return;
        }
    }

    public int readHeaders(Request req) throws IOException {
        block4: {
            int start;
            MimeHeaderField mhf;
            int status;
            MimeHeaders headers = req.getMimeHeaders();
            this.off = this.count;
            do {
                start = this.off;
                while (true) {
                    int len;
                    if ((len = this.buf.length - this.off) > 0 && (len = BuffTool.readLine(this.in, this.buf, this.off, len)) == -1) {
                        return 400;
                    }
                    this.off += len;
                    if (len == 0 || this.buf[this.off - 1] == 10) break;
                    byte[] tmp = new byte[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
                    this.buf = tmp;
                }
                if (--this.off > start && this.buf[this.off - 1] == 13) {
                    --this.off;
                }
                if (this.off == start) break block4;
            } while ((status = this.parseHeaderFiled(mhf = headers.putHeader(), this.buf, start, this.off - start)) == 0);
            return status;
        }
        return 0;
    }

    public int parseHeaderFiled(MimeHeaderField mhf, byte[] b, int off, int len) {
        int start = off;
        int end = off + len;
        int nameEnd = BuffTool.findChars(b, start, end, NAME_DELIMS);
        if (nameEnd < 0 || b[nameEnd] == 13 || b[nameEnd] == 10) {
            System.out.println("Parse error, empty line: " + new String(b, off, len));
            return 400;
        }
        mhf.setName(b, start, nameEnd - start);
        int sepIdx = BuffTool.findNotChars(b, nameEnd, end, SPACE_DELIMS);
        if (b[sepIdx] != 58) {
            System.out.println("Parse error, missing : in  " + new String(b, off, len));
            System.out.println("Full  " + new String(b, 0, b.length));
            return 400;
        }
        int valueStart = BuffTool.findNotChars(b, sepIdx + 1, end, SPACE_DELIMS);
        if (valueStart < 0) {
            System.out.println("Parse error, no value after : " + new String(b, off, len));
            System.out.println("Full  " + new String(b, 0, b.length));
            return 400;
        }
        mhf.setValue(b, valueStart, end - valueStart);
        return 0;
    }

    private int processRequestLine(Request req) throws IOException {
        this.off = 0;
        if (this.buf[this.count - 1] != 13 && this.buf[this.count - 1] != 10) {
            return 414;
        }
        int startMethod = BuffTool.findNotChars(this.buf, 0, this.count, SPACE_DELIMS);
        if (startMethod == -1) {
            return 400;
        }
        int endMethod = BuffTool.findChars(this.buf, startMethod, this.count, SPACE_DELIMS);
        if (endMethod == -1) {
            return 400;
        }
        req.setMethod(new String(this.buf, startMethod, endMethod - startMethod));
        int startReq = BuffTool.findNotChars(this.buf, endMethod, this.count, SPACE_DELIMS);
        if (startReq == -1) {
            return 400;
        }
        int endReq = BuffTool.findChars(this.buf, startReq, this.count, SPACE_DELIMS);
        if (endReq != -1) {
            int startProto = BuffTool.findNotChars(this.buf, endReq, this.count, SPACE_DELIMS);
            if (startProto != -1) {
                int endProto = BuffTool.findChars(this.buf, startProto, this.count, SPACE_DELIMS);
                if (endProto == -1) {
                    endProto = this.count;
                }
                req.setProtocol(new String(this.buf, startProto, endProto - startProto));
            } else {
                req.setProtocol(null);
            }
        } else {
            req.setProtocol(null);
            endReq = this.count;
        }
        int qryIdx = BuffTool.findChar(this.buf, startReq, endReq, '?');
        if (qryIdx < 0) {
            req.setRequestURI(new String(this.buf, startReq, endReq - startReq));
        } else {
            req.setRequestURI(new String(this.buf, startReq, qryIdx - startReq));
            req.setQueryString(new String(this.buf, qryIdx + 1, endReq - qryIdx - 1));
        }
        return 0;
    }
}

