/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletion;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionContext;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class MicronautDataCompletionTask {
    private static final String JPA_REPOSITORY_ANNOTATION_NAME = "io.micronaut.data.annotation.Repository";
    private static final String JDBC_REPOSITORY_ANNOTATION_NAME = "io.micronaut.data.jdbc.annotation.JdbcRepository";
    private static final String REPOSITORY_TYPE_NAME = "io.micronaut.data.repository.GenericRepository";
    private static final String QUERY_ANNOTATION_TYPE_NAME = "io.micronaut.data.annotation.Query";
    private static final String GET = "get";
    private static final List<String> QUERY_PATTERNS = new ArrayList<String>(Arrays.asList("find", "get", "query", "read", "retrieve", "search"));
    private static final List<String> SPECIAL_QUERY_PATTERNS = new ArrayList<String>(Arrays.asList("count", "countDistinct", "delete", "exists", "update"));
    private static final List<String> QUERY_PROJECTIONS = new ArrayList<String>(Arrays.asList("", "Avg", "Distinct", "Max", "Min", "Sum"));
    private static final List<String> CRITERION_EXPRESSIONS = new ArrayList<String>(Arrays.asList("", "After", "Before", "Contains", "StartingWith", "StartsWith", "EndingWith", "EndsWith", "Equal", "Equals", "NotEqual", "NotEquals", "GreaterThan", "GreaterThanEquals", "LessThan", "LessThanEquals", "Like", "Ilike", "In", "InList", "InRange", "Between", "IsNull", "IsNotNull", "IsEmpty", "IsNotEmpty", "True", "False"));
    private static final List<String> COMPOSE_EXPRESSIONS = new ArrayList<String>(Arrays.asList("And", "Or"));
    private static final String BY = "By";
    private static final String ORDER_BY = "OrderBy";
    private static final String COUNT = "count";
    private static final String EXISTS = "exists";
    private static final String EMPTY = "";
    private static final String COMPLETION_CASE_SENSITIVE = "completion-case-sensitive";
    private static final boolean COMPLETION_CASE_SENSITIVE_DEFAULT = true;
    private static final String JAVA_COMPLETION_SUBWORDS = "javaCompletionSubwords";
    private static final boolean JAVA_COMPLETION_SUBWORDS_DEFAULT = false;
    private static final PreferenceChangeListener preferencesTracker = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String settingName;
            String string = settingName = evt == null ? null : evt.getKey();
            if (settingName == null || MicronautDataCompletionTask.COMPLETION_CASE_SENSITIVE.equals(settingName)) {
                caseSensitive = preferences.getBoolean(MicronautDataCompletionTask.COMPLETION_CASE_SENSITIVE, true);
            }
            if (settingName == null || MicronautDataCompletionTask.JAVA_COMPLETION_SUBWORDS.equals(settingName)) {
                javaCompletionSubwords = preferences.getBoolean(MicronautDataCompletionTask.JAVA_COMPLETION_SUBWORDS, false);
            }
        }
    };
    private static final AtomicBoolean inited = new AtomicBoolean(false);
    private static Preferences preferences;
    private static boolean caseSensitive;
    private static boolean javaCompletionSubwords;
    private static String cachedPrefix;
    private static Pattern cachedCamelCasePattern;
    private static Pattern cachedSubwordsPattern;
    private int anchorOffset;

    public <T> List<T> query(Document doc, final int caretOffset, final ItemFactory<T> factory) {
        final ArrayList items = new ArrayList();
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController cc = CompilationController.get((Parser.Result)resultIterator.getParserResult(caretOffset));
                    if (cc != null) {
                        int len;
                        cc.toPhase(JavaSource.Phase.PARSED);
                        MicronautDataCompletionTask.this.anchorOffset = caretOffset;
                        String prefix = MicronautDataCompletionTask.EMPTY;
                        TokenSequence ts = cc.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                        if (ts.move(MicronautDataCompletionTask.this.anchorOffset) == 0 || !ts.moveNext()) {
                            ts.movePrevious();
                        }
                        if ((len = MicronautDataCompletionTask.this.anchorOffset - ts.offset()) > 0 && ts.token().length() >= len) {
                            if (ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)ts.token().id()).primaryCategory().equals("literal")) {
                                prefix = ts.token().text().toString().substring(0, len);
                                MicronautDataCompletionTask.this.anchorOffset = ts.offset();
                            } else if (ts.token().id() == JavaTokenId.STRING_LITERAL) {
                                prefix = ts.token().text().toString().substring(1, ts.token().length() - 1);
                                MicronautDataCompletionTask.this.anchorOffset = ts.offset() + 1;
                            } else if (ts.token().id() == JavaTokenId.MULTILINE_STRING_LITERAL) {
                                prefix = ts.token().text().toString().substring(3, len);
                                MicronautDataCompletionTask.this.anchorOffset = ts.offset() + 3;
                            }
                        }
                        Consumer consumer = (namePrefix, name, type) -> items.add(type != null ? factory.createFinderMethodItem(name, type, MicronautDataCompletionTask.this.anchorOffset) : factory.createFinderMethodNameItem(namePrefix, name, MicronautDataCompletionTask.this.anchorOffset));
                        TreeUtilities treeUtilities = cc.getTreeUtilities();
                        SourcePositions sp = cc.getTrees().getSourcePositions();
                        TreePath path = treeUtilities.pathFor(MicronautDataCompletionTask.this.anchorOffset);
                        switch (path.getLeaf().getKind()) {
                            case CLASS: 
                            case INTERFACE: {
                                MicronautDataCompletionTask.this.resolveFinderMethods(cc, path, prefix, true, consumer);
                                break;
                            }
                            case METHOD: {
                                Tree returnType = ((MethodTree)path.getLeaf()).getReturnType();
                                if (returnType == null || MicronautDataCompletionTask.findLastNonWhitespaceToken((TokenSequence<JavaTokenId>)ts, (int)sp.getEndPosition(path.getCompilationUnit(), returnType), MicronautDataCompletionTask.this.anchorOffset) != null) break;
                                MicronautDataCompletionTask.this.resolveFinderMethods(cc, path.getParentPath(), prefix, false, consumer);
                                break;
                            }
                            case VARIABLE: {
                                TreePath parentPath;
                                Tree type2 = ((VariableTree)path.getLeaf()).getType();
                                if (type2 == null || MicronautDataCompletionTask.findLastNonWhitespaceToken((TokenSequence<JavaTokenId>)ts, (int)sp.getEndPosition(path.getCompilationUnit(), type2), MicronautDataCompletionTask.this.anchorOffset) != null || (parentPath = path.getParentPath()).getLeaf().getKind() != Tree.Kind.CLASS && parentPath.getLeaf().getKind() != Tree.Kind.INTERFACE) break;
                                MicronautDataCompletionTask.this.resolveFinderMethods(cc, parentPath, prefix, false, consumer);
                                break;
                            }
                            case STRING_LITERAL: {
                                if (path.getParentPath().getLeaf().getKind() != Tree.Kind.ASSIGNMENT || path.getParentPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) break;
                                MicronautDataCompletionTask.this.resolveQueryAnnotation(cc, path.getParentPath().getParentPath(), prefix, caretOffset - MicronautDataCompletionTask.this.anchorOffset, item -> items.add(factory.createSQLItem((CompletionItem)item)));
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return items;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    private <T> void resolveQueryAnnotation(CompilationController cc, TreePath path, String prefix, int off, java.util.function.Consumer<CompletionItem> consumer) throws IOException {
        TreePath clsPath;
        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        Element el = cc.getTrees().getElement(path);
        if (el instanceof TypeElement && QUERY_ANNOTATION_TYPE_NAME.contentEquals(((TypeElement)el).getQualifiedName()) && (clsPath = cc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path)) != null && MicronautDataCompletionTask.checkForRepositoryAnnotation(cc.getTrees().getElement(clsPath).getAnnotationMirrors(), false, new HashSet<TypeElement>())) {
            SQLCompletionContext ctx = SQLCompletionContext.empty().setStatement((CharSequence)prefix).setOffset(off).setDatabaseConnection(ConnectionManager.getDefault().getPreferredConnection(true));
            SQLCompletion completion = SQLCompletion.create((SQLCompletionContext)ctx);
            SQLCompletionResultSet resultSet = SQLCompletionResultSet.create();
            completion.query(resultSet, (component, offset, text) -> {
                int caretOffset = component.getCaretPosition();
                StyledDocument document = (StyledDocument)component.getDocument();
                try {
                    NbDocument.runAtomicAsUser((StyledDocument)document, () -> {
                        try {
                            int documentOffset = this.anchorOffset + offset;
                            document.remove(documentOffset, caretOffset - documentOffset);
                            document.insertString(documentOffset, text.replace("\"", "\\\""), null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    });
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            });
            for (CompletionItem item : resultSet.getItems()) {
                consumer.accept(item);
            }
        }
    }

    private <T> void resolveFinderMethods(CompilationController cc, TreePath path, String prefix, boolean full, Consumer consumer) throws IOException {
        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        TypeUtilities tu = cc.getTypeUtilities();
        TypeElement entity = MicronautDataCompletionTask.getEntityFor((CompilationInfo)cc, path);
        if (entity != null) {
            HashMap<String, String> prop2Types = new HashMap<String, String>();
            for (ExecutableElement method : ElementFilter.methodsIn(entity.getEnclosedElements())) {
                String methodName = method.getSimpleName().toString();
                if (!methodName.startsWith(GET) || !method.getParameters().isEmpty()) continue;
                prop2Types.put(methodName.substring(GET.length()), tu.getTypeName(method.getReturnType(), new TypeUtilities.TypeNameOptions[0]).toString());
            }
            this.addFindByCompletions(entity, prop2Types, prefix, full, consumer);
        }
    }

    private void addFindByCompletions(TypeElement entity, Map<String, String> prop2Types, String prefix, boolean full, Consumer consumer) {
        for (String pattern : QUERY_PATTERNS) {
            String name = pattern + BY;
            if (prefix.length() >= name.length() && prefix.startsWith(name)) {
                this.addPropertyCriterionCompletions(prop2Types, name, prefix, consumer);
            } else if (MicronautDataCompletionTask.startsWith(name, prefix)) {
                consumer.accept(EMPTY, name, full ? entity.getSimpleName().toString() : null);
            }
            for (String projection : QUERY_PROJECTIONS) {
                for (String propName : prop2Types.keySet()) {
                    name = pattern + projection + propName + BY;
                    if (prefix.length() >= name.length() && prefix.startsWith(name)) {
                        this.addPropertyCriterionCompletions(prop2Types, name, prefix, consumer);
                        continue;
                    }
                    if (!MicronautDataCompletionTask.startsWith(name, prefix)) continue;
                    consumer.accept(EMPTY, name, full ? prop2Types.get(propName) : null);
                }
            }
        }
        for (String pattern : SPECIAL_QUERY_PATTERNS) {
            for (String propName : prop2Types.keySet()) {
                String name = pattern + propName + BY;
                if (prefix.length() >= name.length() && prefix.startsWith(name)) {
                    this.addPropertyCriterionCompletions(prop2Types, name, prefix, consumer);
                    continue;
                }
                if (!MicronautDataCompletionTask.startsWith(name, prefix)) continue;
                consumer.accept(EMPTY, name, full ? (name.startsWith(COUNT) ? "int" : (name.startsWith(EXISTS) ? "boolean" : "void")) : null);
            }
        }
    }

    private void addPropertyCriterionCompletions(Map<String, String> prop2Types, String namePrefix, String prefix, Consumer consumer) {
        for (String propName : prop2Types.keySet()) {
            for (String criterion : CRITERION_EXPRESSIONS) {
                String name = propName + criterion;
                if (prefix.length() >= namePrefix.length() + name.length() && prefix.startsWith(namePrefix + name)) {
                    this.addComposeAndOrderCompletions(prop2Types, namePrefix + name, prefix, consumer);
                    continue;
                }
                if (!MicronautDataCompletionTask.startsWith(namePrefix + name, prefix)) continue;
                consumer.accept(namePrefix, name, null);
            }
        }
    }

    private void addComposeAndOrderCompletions(Map<String, String> prop2Types, String namePrefix, String prefix, Consumer consumer) {
        for (String name : COMPOSE_EXPRESSIONS) {
            if (prefix.length() >= namePrefix.length() + name.length() && prefix.startsWith(namePrefix + name)) {
                this.addPropertyCriterionCompletions(prop2Types, namePrefix + name, prefix, consumer);
                continue;
            }
            if (!MicronautDataCompletionTask.startsWith(namePrefix + name, prefix)) continue;
            consumer.accept(namePrefix, name, null);
        }
        for (String propName : prop2Types.keySet()) {
            String name = ORDER_BY + propName;
            if (prefix.length() >= namePrefix.length() + name.length() || !MicronautDataCompletionTask.startsWith(namePrefix + name, prefix)) continue;
            consumer.accept(namePrefix, name, null);
        }
    }

    private static TypeElement getEntityFor(CompilationInfo info, TreePath path) {
        TypeElement te = (TypeElement)info.getTrees().getElement(path);
        if (te.getModifiers().contains((Object)Modifier.ABSTRACT) && MicronautDataCompletionTask.checkForRepositoryAnnotation(te.getAnnotationMirrors(), true, new HashSet<TypeElement>())) {
            Types types = info.getTypes();
            TypeMirror repositoryType = types.erasure(info.getElements().getTypeElement(REPOSITORY_TYPE_NAME).asType());
            for (TypeMirror typeMirror : te.getInterfaces()) {
                TypeMirror entityType;
                List<? extends TypeMirror> typeArguments;
                if (typeMirror.getKind() != TypeKind.DECLARED || !types.isSubtype(types.erasure(typeMirror), repositoryType) || (typeArguments = ((DeclaredType)typeMirror).getTypeArguments()).isEmpty() || (entityType = typeArguments.get(0)) == null || entityType.getKind() != TypeKind.DECLARED) continue;
                return (TypeElement)((DeclaredType)entityType).asElement();
            }
        }
        return null;
    }

    private static boolean checkForRepositoryAnnotation(List<? extends AnnotationMirror> annotations, boolean jpa, HashSet<TypeElement> checked) {
        for (AnnotationMirror annotationMirror : annotations) {
            String repositoryAnnotationName;
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            String string = repositoryAnnotationName = jpa ? JPA_REPOSITORY_ANNOTATION_NAME : JDBC_REPOSITORY_ANNOTATION_NAME;
            if (!repositoryAnnotationName.contentEquals(annotationElement.getQualifiedName()) && (!checked.add(annotationElement) || !MicronautDataCompletionTask.checkForRepositoryAnnotation(annotationElement.getAnnotationMirrors(), jpa, checked))) continue;
            return true;
        }
        return false;
    }

    private static TokenSequence<JavaTokenId> findLastNonWhitespaceToken(TokenSequence<JavaTokenId> ts, int startPos, int endPos) {
        ts.move(endPos);
        TokenSequence<JavaTokenId> last = MicronautDataCompletionTask.previousNonWhitespaceToken(ts);
        if (last == null || last.offset() < startPos) {
            return null;
        }
        return last;
    }

    private static TokenSequence<JavaTokenId> previousNonWhitespaceToken(TokenSequence<JavaTokenId> ts) {
        block3: while (ts.movePrevious()) {
            switch ((JavaTokenId)ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    continue block3;
                }
            }
            return ts;
        }
        return null;
    }

    private static boolean startsWith(String theString, String prefix) {
        return MicronautDataCompletionTask.isCamelCasePrefix(prefix) ? (MicronautDataCompletionTask.isCaseSensitive() ? MicronautDataCompletionTask.startsWithCamelCase(theString, prefix) : MicronautDataCompletionTask.startsWithCamelCase(theString, prefix) || MicronautDataCompletionTask.startsWithPlain(theString, prefix)) : MicronautDataCompletionTask.startsWithPlain(theString, prefix);
    }

    private static boolean isCamelCasePrefix(String prefix) {
        if (prefix == null || prefix.length() < 2 || prefix.charAt(0) == '\"') {
            return false;
        }
        for (int i = 1; i < prefix.length(); ++i) {
            if (!Character.isUpperCase(prefix.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isCaseSensitive() {
        MicronautDataCompletionTask.lazyInit();
        return caseSensitive;
    }

    public static boolean isSubwordSensitive() {
        MicronautDataCompletionTask.lazyInit();
        return javaCompletionSubwords;
    }

    private static boolean startsWithPlain(String theString, String prefix) {
        if (theString == null || theString.length() == 0) {
            return false;
        }
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        if (MicronautDataCompletionTask.isSubwordSensitive()) {
            if (!prefix.equals(cachedPrefix)) {
                cachedCamelCasePattern = null;
                cachedSubwordsPattern = null;
            }
            if (cachedSubwordsPattern == null) {
                cachedPrefix = prefix;
                String patternString = MicronautDataCompletionTask.createSubwordsPattern(prefix);
                Pattern pattern = cachedSubwordsPattern = patternString != null ? Pattern.compile(patternString) : null;
            }
            if (cachedSubwordsPattern != null && cachedSubwordsPattern.matcher(theString).matches()) {
                return true;
            }
        }
        return MicronautDataCompletionTask.isCaseSensitive() ? theString.startsWith(prefix) : theString.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
    }

    private static String createSubwordsPattern(String prefix) {
        StringBuilder sb = new StringBuilder(3 + 8 * prefix.length());
        sb.append(".*?");
        for (int i = 0; i < prefix.length(); ++i) {
            char charAt = prefix.charAt(i);
            if (!Character.isJavaIdentifierPart(charAt)) {
                return null;
            }
            if (Character.isLowerCase(charAt)) {
                sb.append("[");
                sb.append(charAt);
                sb.append(Character.toUpperCase(charAt));
                sb.append("]");
            } else {
                sb.append(charAt);
            }
            sb.append(".*?");
        }
        return sb.toString();
    }

    private static boolean startsWithCamelCase(String theString, String prefix) {
        if (theString == null || theString.length() == 0 || prefix == null || prefix.length() == 0) {
            return false;
        }
        if (!prefix.equals(cachedPrefix)) {
            cachedCamelCasePattern = null;
            cachedSubwordsPattern = null;
        }
        if (cachedCamelCasePattern == null) {
            int index;
            StringBuilder sb = new StringBuilder();
            int lastIndex = 0;
            do {
                String token = prefix.substring(lastIndex, (index = MicronautDataCompletionTask.findNextUpper(prefix, lastIndex + 1)) == -1 ? prefix.length() : index);
                sb.append(token);
                sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                lastIndex = index;
            } while (index != -1);
            cachedPrefix = prefix;
            cachedCamelCasePattern = Pattern.compile(sb.toString());
        }
        return cachedCamelCasePattern.matcher(theString).matches();
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static void lazyInit() {
        if (inited.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)JavaTokenId.language().mimeType()).lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    static {
        caseSensitive = true;
        javaCompletionSubwords = false;
        cachedPrefix = null;
        cachedCamelCasePattern = null;
        cachedSubwordsPattern = null;
    }

    @FunctionalInterface
    private static interface Consumer {
        public void accept(String var1, String var2, String var3);
    }

    public static interface ItemFactory<T> {
        public T createFinderMethodItem(String var1, String var2, int var3);

        public T createFinderMethodNameItem(String var1, String var2, int var3);

        public T createSQLItem(CompletionItem var1);
    }
}

