/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.InternalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public final class JDIExceptionReporter {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdi");
    private static final Level LOGLEVEL = Level.FINER;
    public static final Object RET_VOID = new Object();
    private static final ThreadLocal<Long> callStartTime = new ThreadLocal();

    private JDIExceptionReporter() {
    }

    public static void report(InternalException iex) {
        iex = (InternalException)Exceptions.attachMessage((Throwable)iex, (String)"An unexpected internal exception occured in debug interface layer. Please submit this to your JVM vendor.");
        Exceptions.printStackTrace((Throwable)iex);
    }

    public static boolean isLoggable() {
        return LOGGER.isLoggable(Level.SEVERE);
    }

    public static void logCallStart(String className, String methodName, String msg, Object[] args) {
        try {
            LOGGER.log(LOGLEVEL, msg, args);
        }
        catch (Exception exc) {
            LOGGER.log(LOGLEVEL, "Logging of " + className + "." + methodName + "() threw exception:", exc);
        }
        callStartTime.set(System.nanoTime());
    }

    public static void logCallEnd(String className, String methodName, Object ret) {
        long t2 = System.nanoTime();
        long t1 = callStartTime.get();
        callStartTime.remove();
        LOGGER.log(LOGLEVEL, "          {0}.{1}() returned after {2} ns, return value = {3}", new Object[]{className, methodName, t2 - t1, RET_VOID == ret ? "void" : ret});
        if (ret instanceof Throwable) {
            LOGGER.log(LOGLEVEL, "", (Throwable)ret);
        }
        if (t2 - t1 > 100000000L) {
            LOGGER.log(LOGLEVEL, "", new RuntimeException("TooLongCall"));
        }
    }
}

