/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.CompilationInfoHolder;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException;
import org.netbeans.modules.debugger.jpda.expr.JavaExpression;
import org.netbeans.modules.debugger.jpda.expr.TreeEvaluator;
import org.netbeans.modules.debugger.jpda.expr.VMCache;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.Evaluator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaEvaluator
implements Evaluator<JavaExpression> {
    private final JPDADebuggerImpl debugger;
    private final VMCache vmCache;
    private final Map<Value, EvaluationContext.VariableInfo> valueContainers = Collections.synchronizedMap(new IdentityHashMap());

    public JavaEvaluator(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.debugger.addPropertyChangeListener("currentCallStackFrame", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JavaEvaluator.this.valueContainers.clear();
            }
        });
        this.vmCache = new VMCache(this.debugger);
    }

    public Evaluator.Result evaluate(Evaluator.Expression<JavaExpression> expression, Evaluator.Context context) throws InvalidExpressionException {
        return this.evaluate(expression, context, null);
    }

    public Evaluator.Result evaluate(Evaluator.Expression<JavaExpression> expression, final Evaluator.Context context, CompilationInfoHolder ciHolder) throws InvalidExpressionException {
        JavaExpression expr = (JavaExpression)expression.getPreprocessedObject();
        if (expr == null) {
            expr = JavaExpression.parse(expression.getExpression(), "1.5.0");
            expression.setPreprocessedObject((Object)expr);
        }
        Value v = this.evaluateIn(expr, context.getCallStackFrame(), context.getStackFrame(), context.getStackDepth(), context.getContextObject(), ciHolder, this.debugger.methodCallsUnsupportedExc == null, new Runnable(){

            @Override
            public void run() {
                context.notifyMethodToBeInvoked();
            }
        });
        return new Evaluator.Result(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value evaluateIn(JavaExpression expression, CallStackFrame csf, StackFrame frame, int frameDepth, ObjectReference var, CompilationInfoHolder ciHolder, boolean canInvokeMethods, Runnable methodInvokePreprocessor) throws InvalidExpressionException {
        Value value;
        EvaluationContext context;
        block13: {
            if (csf == null) {
                throw new InvalidExpressionException(NbBundle.getMessage(JPDADebuggerImpl.class, (String)"MSG_NoCurrentContextStackFrame"));
            }
            CallStackFrameImpl csfi = (CallStackFrameImpl)csf;
            ImportsLazyList imports = new ImportsLazyList(csfi);
            ArrayList<String> staticImports = new ArrayList<String>();
            JPDAThreadImpl trImpl = (JPDAThreadImpl)csf.getThread();
            context = new EvaluationContext(trImpl, frame, frameDepth, var, imports, staticImports, canInvokeMethods, methodInvokePreprocessor, this.debugger, this.vmCache);
            TreeEvaluator evaluator = expression.evaluator(context, ciHolder);
            try {
                Tree tree;
                EvaluationContext.VariableInfo vi;
                Value v = evaluator.evaluate();
                TreePath treePath = context.getTreePath();
                if (treePath != null && (vi = context.getVariableInfo(tree = treePath.getLeaf())) != null) {
                    this.valueContainers.put(v, vi);
                }
                value = v;
                if (this.debugger.methodCallsUnsupportedExc != null || context.canInvokeMethods()) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (this.debugger.methodCallsUnsupportedExc == null && !context.canInvokeMethods()) {
                        this.debugger.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
                    }
                    context.destroy();
                    throw throwable;
                }
                catch (InternalExceptionWrapper e) {
                    throw new InvalidExpressionException(e.getLocalizedMessage());
                }
                catch (ObjectCollectedExceptionWrapper e) {
                    throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_collected"));
                }
                catch (VMDisconnectedExceptionWrapper e) {
                    throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_disconnected"));
                }
                catch (InvalidStackFrameExceptionWrapper e) {
                    JPDAThreadImpl t = (JPDAThreadImpl)csf.getThread();
                    e = (InvalidStackFrameExceptionWrapper)Exceptions.attachMessage((Throwable)e, (String)t.getThreadStateLog());
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)("During evaluation of '" + expression.getExpression() + "'")));
                    throw new InvalidExpressionException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NoCurrentContext"));
                }
                catch (EvaluationException e) {
                    InvalidExpressionException iee = new InvalidExpressionException((Throwable)e);
                    Exceptions.attachMessage((Throwable)iee, (String)("Expression = '" + expression.getExpression() + "'"));
                    throw iee;
                }
                catch (IncompatibleThreadStateException itsex) {
                    InvalidExpressionException isex = new InvalidExpressionException(itsex.getLocalizedMessage());
                    isex.initCause((Throwable)itsex);
                    throw isex;
                }
            }
            this.debugger.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
        }
        context.destroy();
        return value;
    }

    public EvaluationContext.VariableInfo getValueContainer(Value v) {
        return this.valueContainers.get(v);
    }

    private class ImportsLazyList
    extends AbstractList<String> {
        private final CallStackFrameImpl csfi;
        private List<String> imports;

        ImportsLazyList(CallStackFrameImpl csfi) {
            this.csfi = csfi;
        }

        private synchronized List<String> getImports() {
            if (this.imports == null) {
                this.imports = this.createImports();
            }
            return this.imports;
        }

        private List<String> createImports() {
            ArrayList<String> im = new ArrayList<String>();
            im.add("java.lang.*");
            try {
                String[] frameImports = EditorContextBridge.getContext().getImports(JavaEvaluator.this.debugger.getEngineContext().getURL(this.csfi.getStackFrame(), "Java"));
                if (frameImports != null) {
                    im.addAll(Arrays.asList(frameImports));
                }
            }
            catch (InternalExceptionWrapper | InvalidStackFrameExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper exception) {
                // empty catch block
            }
            return im;
        }

        @Override
        public String get(int index) {
            return this.getImports().get(index);
        }

        @Override
        public int size() {
            return this.getImports().size();
        }
    }
}

