/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NullNameClass;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ElementPattern
extends Pattern {
    private Pattern p;
    private final NameClass origNameClass;
    private NameClass nameClass;
    private boolean expanded = false;
    private boolean checkedRestrictions = false;
    private final Locator loc;

    ElementPattern(NameClass nameClass, Pattern pattern, Locator locator) {
        super(false, 1, ElementPattern.combineHashCode(23, nameClass.hashCode(), pattern.hashCode()));
        this.nameClass = nameClass;
        this.origNameClass = nameClass;
        this.p = pattern;
        this.loc = locator;
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        if (alphabet != null) {
            alphabet.addElement(this.origNameClass);
        }
        if (this.checkedRestrictions) {
            return;
        }
        switch (n) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_element");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_element");
            }
            case 5: {
                throw new RestrictionViolationException("attribute_contains_element");
            }
        }
        this.checkedRestrictions = true;
        try {
            this.p.checkRestrictions(1, new DuplicateAttributeDetector(), null);
        }
        catch (RestrictionViolationException restrictionViolationException) {
            this.checkedRestrictions = false;
            restrictionViolationException.maybeSetLocator(this.loc);
            throw restrictionViolationException;
        }
    }

    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        if (!this.expanded) {
            this.expanded = true;
            this.p = this.p.expand(schemaPatternBuilder);
            if (this.p.isNotAllowed()) {
                this.nameClass = new NullNameClass();
            }
        }
        return this;
    }

    boolean samePattern(Pattern pattern) {
        if (!(pattern instanceof ElementPattern)) {
            return false;
        }
        ElementPattern elementPattern = (ElementPattern)pattern;
        return this.nameClass.equals(elementPattern.nameClass) && this.p == elementPattern.p;
    }

    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n + 1);
    }

    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitElement(this.nameClass, this.p);
    }

    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseElement(this);
    }

    void setContent(Pattern pattern) {
        this.p = pattern;
    }

    Pattern getContent() {
        return this.p;
    }

    NameClass getNameClass() {
        return this.nameClass;
    }

    Locator getLocator() {
        return this.loc;
    }
}

