/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipAware;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.table.CustomSortableHeaderRenderer;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.TableCellRendererPersistent;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModelAdapter;
import org.netbeans.modules.profiler.api.icons.Icons;

public class JTreeTable
extends JTable
implements CellTipAware,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    public static final boolean SORT_ORDER_DESC = false;
    public static final boolean SORT_ORDER_ASC = true;
    private static final boolean isGTK = UIUtils.isGTKLookAndFeel();
    protected JToolTip cellTip;
    protected Rectangle rendererRect;
    TreeTableCellRenderer tree;
    protected int lastColumn = -1;
    protected int lastRow = -1;
    private AbstractTreeTableModel treeTableModel;
    private CustomSortableHeaderRenderer headerRenderer;
    private ImageIcon sortAscIcon = Icons.getImageIcon((String)"GeneralIcons.SortAscending");
    private ImageIcon sortDescIcon = Icons.getImageIcon((String)"GeneralIcons.SortDescending");
    private JTableHeader tableHeader;
    private String internalFindString;
    private String userFindString;
    private TableHeaderListener headerListener;
    private TreeTableModelAdapter treeTableModelAdapter;
    private int lastFocusedColumn = -1;
    private int treeSignExtent;
    private int treeSignRightMargin;
    private int userFindColumn;

    public JTreeTable(AbstractTreeTableModel treeTableModel) {
        this.treeTableModel = treeTableModel;
        this.setBackground(UIUtils.getProfilerResultsBackground());
        int initialSortingColumn = treeTableModel.getInitialSortingColumn();
        boolean initialSortingOrder = treeTableModel.getInitialSortingOrder();
        if (treeTableModel.supportsSorting()) {
            treeTableModel.sortByColumn(initialSortingColumn, initialSortingOrder);
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JTreeTable.this.getSelectedRows().length > 0) {
                    JTreeTable.this.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (JTreeTable.this.getSelectedRows().length > 0) {
                    JTreeTable.this.repaint();
                }
            }
        });
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.setTreeUIVariables();
        this.tree.setTransferHandler(new TransferHandler(){

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
                JTreeTable.this.getTransferHandler().exportToClipboard(JTreeTable.this, clip, action);
            }
        });
        this.treeTableModelAdapter = new TreeTableModelAdapter(treeTableModel, this);
        this.setModel(this.treeTableModelAdapter);
        if (treeTableModel.supportsSorting()) {
            this.headerListener = new TableHeaderListener();
            this.headerRenderer = new CustomSortableHeaderRenderer(this.sortAscIcon, this.sortDescIcon);
            this.headerRenderer.setSortingColumn(initialSortingColumn);
            this.headerRenderer.setSortingOrder(initialSortingOrder);
            this.updateTreeTableHeader();
        }
        this.getTableHeader().setReorderingAllowed(false);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.cellTip = this.createCellTip();
        this.cellTip.setBorder(BorderFactory.createLineBorder(this.getGridColor()));
        this.cellTip.setLayout(new BorderLayout());
        CellTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public JToolTip getCellTip() {
        return this.cellTip;
    }

    @Override
    public Point getCellTipLocation() {
        if (this.rendererRect == null) {
            return null;
        }
        return new Point(this.rendererRect.getLocation().x - 1, this.rendererRect.getLocation().y - 1);
    }

    public int getFindColumn() {
        return this.userFindColumn;
    }

    public boolean isFindColumnValid() {
        return this.userFindColumn >= 0 && this.userFindColumn < this.getColumnCount();
    }

    public void setFindParameters(String findString, int findColumn) {
        this.userFindString = findString;
        this.userFindColumn = findColumn;
        this.internalFindString = this.getInternalFindString(this.userFindString);
    }

    public String getFindString() {
        return this.userFindString;
    }

    public boolean isFindStringDefined() {
        return this.userFindString != null && this.userFindString.trim().length() > 0;
    }

    @Override
    public void setGridColor(Color gridColor) {
        super.setGridColor(gridColor);
        if (gridColor == null || this.cellTip == null) {
            return;
        }
        this.cellTip.setBorder(BorderFactory.createLineBorder(gridColor));
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public void setSortingColumn(int column) {
        this.headerRenderer.setSortingColumn(column);
    }

    public int getSortingColumn() {
        return this.headerRenderer.getSortingColumn();
    }

    public void setSortingOrder(boolean order) {
        this.headerRenderer.setSortingOrder(order);
    }

    public boolean getSortingOrder() {
        return this.headerRenderer.getSortingOrder();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTreeCellOffsetX(int offsetX) {
        if (this.getTreeCellOffsetX() != offsetX) {
            this.tree.setOffsetX(offsetX);
            this.repaint(0, 0, this.getColumnModel().getColumn(0).getWidth(), this.getHeight());
        }
    }

    public int getTreeCellOffsetX() {
        return this.tree.getOffsetX();
    }

    public void setTreeCellRenderer(EnhancedTreeCellRenderer renderer) {
        this.tree.setTreeCellRenderer(renderer);
    }

    public EnhancedTreeCellRenderer getTreeCellRenderer() {
        return this.tree.getTreeCellRenderer();
    }

    public boolean canFindBePerformed() {
        return this.tree != null && this.treeTableModel.getRoot() != null && this.isFindColumnValid() && this.isFindStringDefined();
    }

    public boolean findFirst() {
        return this.findFirst(true);
    }

    public boolean findNext() {
        if (!this.canFindBePerformed()) {
            return false;
        }
        CCTNode searchRoot = this.getSearchRoot();
        if (this.doFindNext(searchRoot, 0, true)) {
            return true;
        }
        CCTNode searchRootParent = searchRoot.getParent();
        while (searchRootParent != null) {
            if (this.doFindNext(searchRootParent, searchRootParent.getIndexOfChild((Object)searchRoot) + 1, true)) {
                return true;
            }
            searchRoot = searchRootParent;
            searchRootParent = searchRoot.getParent();
        }
        return false;
    }

    public boolean findPrevious() {
        if (!this.canFindBePerformed()) {
            return false;
        }
        CCTNode searchRoot = this.getSearchRoot();
        if (!this.isAnyRowSelected()) {
            return this.findFirst();
        }
        CCTNode searchRootParent = searchRoot.getParent();
        while (searchRootParent != null) {
            if (this.doFindPrevious(searchRootParent, searchRootParent.getIndexOfChild((Object)searchRoot) - 1, true)) {
                return true;
            }
            searchRoot = searchRootParent;
            searchRootParent = searchRoot.getParent();
        }
        return false;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.shouldBeForwarded(e)) {
            this.dispatchKeyboardEvent(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.shouldBeForwarded(e)) {
            this.dispatchKeyboardEvent(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.shouldBeForwarded(e)) {
            this.dispatchKeyboardEvent(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.dispatchMouseEvent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dispatchMouseEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        CellTipManager.sharedInstance().setEnabled(false);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.contains(e.getPoint()) && this.cellTip.isShowing()) {
            return;
        }
        CellTipManager.sharedInstance().setEnabled(false);
        this.lastRow = -1;
        this.lastColumn = -1;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Component cellRenderer;
        boolean isForTreeCell;
        int row = this.rowAtPoint(e.getPoint());
        int column = this.columnAtPoint(e.getPoint());
        boolean bl = isForTreeCell = this.getColumnClass(column) == TreeTableModel.class;
        if (!isForTreeCell && row == this.lastRow && column == this.lastColumn) {
            return;
        }
        this.lastRow = row;
        this.lastColumn = column;
        if (row < 0 || column < 0) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        Rectangle cellRect = this.getCellRect(row, column, false);
        if (isForTreeCell) {
            EnhancedTreeCellRenderer treeCellRenderer = this.tree.getTreeCellRenderer();
            cellRenderer = ((TreeCellRendererPersistent)treeCellRenderer).getTreeCellRendererComponentPersistent(this.tree, this.treeTableModel.getValueAt(this.tree.getPathForRow(row).getLastPathComponent(), 0), false, this.tree.isExpanded(row), this.treeTableModel.isLeaf(this.tree.getPathForRow(row).getLastPathComponent()), row, false);
            if (cellRenderer == null) {
                CellTipManager.sharedInstance().setEnabled(false);
                return;
            }
            Point treeCellStart = this.tree.getPathBounds(this.tree.getPathForRow(row)).getLocation();
            this.rendererRect = new Rectangle(cellRect.x + treeCellStart.x - this.tree.getOffsetX(), treeCellStart.y, cellRenderer.getPreferredSize().width, cellRenderer.getPreferredSize().height + 2);
        } else {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(row, column);
            if (!(tableCellRenderer instanceof TableCellRendererPersistent)) {
                return;
            }
            cellRenderer = ((TableCellRendererPersistent)tableCellRenderer).getTableCellRendererComponentPersistent(this, this.getValueAt(row, column), false, false, row, column);
            if (cellRenderer == null) {
                CellTipManager.sharedInstance().setEnabled(false);
                return;
            }
            int horizontalAlignment = ((EnhancedTableCellRenderer)cellRenderer).getHorizontalAlignment();
            this.rendererRect = horizontalAlignment == 11 || horizontalAlignment == 4 ? new Rectangle(cellRect.x + cellRect.width - cellRenderer.getPreferredSize().width, cellRect.y, cellRenderer.getPreferredSize().width, cellRenderer.getPreferredSize().height) : new Rectangle(cellRect.x, cellRect.y, cellRenderer.getPreferredSize().width, cellRenderer.getPreferredSize().height);
        }
        if (isForTreeCell && !this.rendererRect.contains(e.getPoint())) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        if (this.rendererRect.x >= cellRect.x && this.rendererRect.x + this.rendererRect.width <= cellRect.x + cellRect.width) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        while (this.cellTip.getComponentCount() > 0) {
            this.cellTip.remove(0);
        }
        this.cellTip.add(cellRenderer, "Center");
        this.cellTip.setPreferredSize(new Dimension(this.rendererRect.width + 2, this.getRowHeight(row) + 2));
        CellTipManager.sharedInstance().setEnabled(true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dispatchMouseEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dispatchMouseEvent(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mouseMoved(e);
        CellTipManager.sharedInstance().setEnabled(false);
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (e instanceof MouseWheelEvent) {
            Container target = this.getParent();
            if (target == null || !(target instanceof JViewport)) {
                target = this;
            }
            MouseEvent mwe = SwingUtilities.convertMouseEvent(this, (MouseWheelEvent)e, target);
            target.dispatchEvent((MouseWheelEvent)mwe);
        } else {
            super.processMouseEvent(e);
        }
    }

    public void resetTreeCellOffsetX() {
        this.setTreeCellOffsetX(0);
    }

    public CCTNode[] getPathToRoot(CCTNode node) {
        return this.treeTableModel.getPathToRoot(node);
    }

    public void selectNode(CCTNode node, boolean setVisible) {
        TreePath path = new TreePath(this.treeTableModel.getPathToRoot(node));
        this.getTree().setSelectionPath(path);
        if (setVisible) {
            this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), 0, true));
        }
    }

    public void selectRowByContents(String rowString, int columnIndex, boolean setVisible) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getValueAt(i, columnIndex).toString().equals(rowString)) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            if (setVisible) {
                this.scrollRectToVisible(this.getCellRect(i, columnIndex, true));
            }
            return;
        }
        this.getSelectionModel().clearSelection();
    }

    public boolean silentlyFindFirst() {
        return this.findFirst(false);
    }

    public void updateTreeTable() {
        this.treeTableModelAdapter.updateTreeTable();
    }

    public void changeRoot(CCTNode newRoot) {
        this.treeTableModelAdapter.changeRoot(newRoot);
    }

    public void setup(List<TreePath> expanded, TreePath selected) {
        this.treeTableModelAdapter.setup(expanded, selected);
    }

    public List<TreePath> getExpandedPaths() {
        return this.treeTableModelAdapter.getExpandedPaths();
    }

    public void updateTreeTableHeader() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableColumnModel.getColumn(i).setHeaderRenderer(this.headerRenderer);
        }
        if (this.tableHeader != this.getTableHeader()) {
            if (this.tableHeader != null) {
                this.tableHeader.removeMouseListener(this.headerListener);
            }
            if (this.tableHeader != null) {
                this.tableHeader.removeMouseMotionListener(this.headerListener);
            }
            this.tableHeader = this.getTableHeader();
            this.tableHeader.addMouseListener(this.headerListener);
            this.tableHeader.addMouseMotionListener(this.headerListener);
            this.updateTreeTable();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
            this.setTreeUIVariables();
        }
    }

    protected JToolTip createCellTip() {
        return new JToolTip();
    }

    private boolean isAnyRowSelected() {
        TreePath treeSelectionPath = this.tree.getSelectionPath();
        return treeSelectionPath != null && treeSelectionPath.getPathCount() > 0;
    }

    private String getInternalFindString(String findString) {
        if (findString == null) {
            return null;
        }
        return findString.toLowerCase();
    }

    private CCTNode getSearchRoot() {
        if (!this.isAnyRowSelected()) {
            return (CCTNode)this.treeTableModel.getRoot();
        }
        return (CCTNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    private void setTreeUIVariables() {
        if (this.tree.getUI() instanceof BasicTreeUI) {
            BasicTreeUI treeUI = (BasicTreeUI)this.tree.getUI();
            this.treeSignExtent = treeUI.getExpandedIcon().getIconWidth() / 2;
            this.treeSignRightMargin = treeUI.getRightChildIndent();
        }
    }

    private void dispatchKeyboardEvent(KeyEvent e) {
        int selectedRow;
        this.tree.customProcessKeyEvent(e);
        if (!JTreeTable.isModifierKey(e) && (selectedRow = this.getSelectedRow()) > -1) {
            this.scrollRectToVisible(this.getCellRect(selectedRow, 0, false));
        }
    }

    private static boolean isModifierKey(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 65406: {
                return true;
            }
        }
        return false;
    }

    private void dispatchMouseEvent(MouseEvent e) {
        if (e != null) {
            int row = this.rowAtPoint(e.getPoint());
            int column = this.columnAtPoint(e.getPoint());
            Rectangle tableCellRect = this.getCellRect(row, column, true);
            Rectangle treeCellRect = this.tree.getRowBounds(row);
            if (treeCellRect != null) {
                int xClick;
                Class<?> columnClass = this.getColumnClass(column);
                if (columnClass == TreeTableModel.class) {
                    xClick = e.getX() - tableCellRect.x;
                    if ((xClick += this.tree.getOffsetX()) < treeCellRect.x - this.treeSignExtent - this.treeSignRightMargin || xClick > treeCellRect.x + this.treeSignExtent - this.treeSignRightMargin + 1) {
                        xClick = treeCellRect.x + treeCellRect.width - 1;
                    }
                } else {
                    xClick = treeCellRect.x + treeCellRect.width - 1;
                }
                int clickCount = 2 - e.getClickCount() % 2;
                MouseEvent newEvent = new MouseEvent(this.tree, e.getID(), e.getWhen(), e.getModifiers(), xClick, e.getY(), clickCount, e.isPopupTrigger());
                this.tree.dispatchEvent(newEvent);
            }
        }
    }

    private boolean doFindNext(CCTNode rootForSearch, int childToSearchIndex, boolean requestFocus) {
        int nChildren = rootForSearch.getNChildren();
        while (childToSearchIndex < nChildren) {
            CCTNode childToSearch = rootForSearch.getChild(childToSearchIndex);
            if (this.matchesFindCriterion(childToSearch)) {
                return this.selectFoundNode(childToSearch, requestFocus);
            }
            if (childToSearch.getNChildren() > 0 && this.doFindNext(childToSearch, 0, requestFocus)) {
                return true;
            }
            ++childToSearchIndex;
        }
        return false;
    }

    private boolean doFindPrevious(CCTNode rootForSearch, int childToSearchIndex, boolean requestFocus) {
        while (childToSearchIndex >= 0) {
            CCTNode childToSearch = rootForSearch.getChild(childToSearchIndex);
            if (this.doFindPrevious(childToSearch, childToSearch.getNChildren() - 1, requestFocus)) {
                return true;
            }
            --childToSearchIndex;
        }
        if (this.matchesFindCriterion(rootForSearch)) {
            return this.selectFoundNode(rootForSearch, requestFocus);
        }
        return false;
    }

    private boolean findFirst(boolean requestFocus) {
        if (!this.canFindBePerformed()) {
            return false;
        }
        CCTNode searchRoot = (CCTNode)this.treeTableModel.getRoot();
        if (this.matchesFindCriterion(searchRoot)) {
            return this.selectFoundNode(searchRoot, requestFocus);
        }
        return this.doFindNext(searchRoot, 0, requestFocus);
    }

    private boolean matchesFindCriterion(Object node) {
        Object o = this.treeTableModel.getValueAt(node, 0);
        if (o == null) {
            return false;
        }
        String s = o.toString();
        if (s == null) {
            return false;
        }
        return s.toLowerCase().indexOf(this.internalFindString) != -1;
    }

    private boolean selectFoundNode(CCTNode nodeToSelect, boolean requestFocus) {
        Rectangle rect;
        TreePath nodeToSelectPath = new TreePath(this.treeTableModel.getPathToRoot(nodeToSelect));
        this.tree.expandPath(nodeToSelectPath);
        this.tree.setSelectionPath(nodeToSelectPath);
        if (requestFocus) {
            this.requestFocusInWindow();
        }
        if ((rect = this.tree.getPathBounds(nodeToSelectPath)) != null) {
            this.scrollRectToVisible(rect);
            return true;
        }
        return false;
    }

    private boolean shouldBeForwarded(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 33: 
            case 34: {
                return false;
            }
        }
        return true;
    }

    private class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int currentlyPaintedRow;
        private Color darkerUnselectedBackground;
        private Color unselectedBackground;
        private Color unselectedForeground;
        private EnhancedTreeCellRenderer treeCellRenderer;
        private int offsetX;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.offsetX = 0;
            this.setOpaque(false);
            this.treeCellRenderer = new EnhancedTreeCellRenderer();
            this.setCellRenderer(this.treeCellRenderer);
            this.unselectedBackground = UIUtils.getProfilerResultsBackground();
            this.darkerUnselectedBackground = UIUtils.getDarker(this.unselectedBackground);
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public Insets getInsets() {
            return ZERO_INSETS;
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        public void setOffsetX(int offsetX) {
            this.offsetX = offsetX;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setRowForeground(table.isFocusOwner() ? table.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
                this.setRowBackground(table.isFocusOwner() ? table.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
            } else if ((row & 1) == 0) {
                this.setRowForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                this.setRowBackground(this.darkerUnselectedBackground != null ? this.darkerUnselectedBackground : UIUtils.getDarker(table.getBackground()));
            } else {
                this.setRowForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                this.setRowBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.currentlyPaintedRow = row;
            return this;
        }

        public void setTreeCellRenderer(EnhancedTreeCellRenderer renderer) {
            this.treeCellRenderer = renderer;
            this.setCellRenderer(this.treeCellRenderer);
        }

        public EnhancedTreeCellRenderer getTreeCellRenderer() {
            return this.treeCellRenderer;
        }

        public void customProcessKeyEvent(KeyEvent e) {
            this.processKeyEvent(e);
        }

        @Override
        public void paint(Graphics g) {
            boolean selected = this.isRowSelected(this.currentlyPaintedRow);
            boolean focused = JTreeTable.this.isFocusOwner();
            int rHeight = this.getRowHeight();
            g.translate(-this.offsetX, -this.currentlyPaintedRow * rHeight);
            if (isGTK) {
                super.paint(g);
                Rectangle rowBounds = this.getRowBounds(this.currentlyPaintedRow);
                int xpos = rowBounds.x + rowBounds.width;
                g.setColor(this.getRowColor(this.currentlyPaintedRow, selected, focused));
                g.fillRect(xpos, this.currentlyPaintedRow * rHeight, this.getWidth() + this.offsetX - xpos, rHeight);
            } else {
                int xpos = selected ? 0 : this.getRowBounds((int)this.currentlyPaintedRow).x;
                g.setColor(this.getRowColor(this.currentlyPaintedRow, selected, focused));
                g.fillRect(xpos, this.currentlyPaintedRow * rHeight, this.getWidth() + this.offsetX, rHeight);
                super.paint(g);
            }
        }

        protected void setRowBackground(Color c) {
            this.treeCellRenderer.setBackground(c);
            this.treeCellRenderer.setBackgroundNonSelectionColor(c);
            this.treeCellRenderer.setBackgroundSelectionColor(c);
        }

        protected void setRowForeground(Color c) {
            this.treeCellRenderer.setForeground(c);
            this.treeCellRenderer.setTextNonSelectionColor(c);
            this.treeCellRenderer.setTextSelectionColor(c);
        }

        private Color getRowColor(int row, boolean selected, boolean focused) {
            if (selected) {
                return focused ? JTreeTable.this.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground();
            }
            Color backgroundColor = UIUtils.getProfilerResultsBackground();
            if ((row & 1) == 0) {
                return UIUtils.getDarker(backgroundColor);
            }
            return backgroundColor;
        }
    }

    private class TableHeaderListener
    extends MouseAdapter
    implements MouseMotionListener {
        private TableHeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getModifiers() == 16) {
                int sortingColumn;
                int column = JTreeTable.this.tableHeader.columnAtPoint(e.getPoint());
                if (column == (sortingColumn = JTreeTable.this.headerRenderer.getSortingColumn())) {
                    JTreeTable.this.headerRenderer.reverseSortingOrder();
                } else {
                    JTreeTable.this.headerRenderer.setSortingColumn(column);
                    if (JTreeTable.this.treeTableModel.getInitialSorting(column)) {
                        JTreeTable.this.headerRenderer.setSortingOrder(true);
                    } else {
                        JTreeTable.this.headerRenderer.setSortingOrder(false);
                    }
                }
                JTreeTable.this.tableHeader.repaint();
                JTreeTable.this.treeTableModel.sortByColumn(column, JTreeTable.this.headerRenderer.getSortingOrder());
                JTreeTable.this.updateTreeTable();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int focusedColumn = JTreeTable.this.tableHeader.columnAtPoint(e.getPoint());
            if (focusedColumn != JTreeTable.this.lastFocusedColumn) {
                if (focusedColumn != -1) {
                    JTreeTable.this.tableHeader.setToolTipText(JTreeTable.this.treeTableModel.getColumnToolTipText(focusedColumn));
                } else {
                    JTreeTable.this.tableHeader.setToolTipText(null);
                }
                JTreeTable.this.lastFocusedColumn = focusedColumn;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getModifiers() == 16 && JTreeTable.this.tableHeader.getResizingColumn() == null) {
                JTreeTable.this.headerRenderer.setPressedColumn(JTreeTable.this.tableHeader.columnAtPoint(e.getPoint()));
                JTreeTable.this.tableHeader.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getModifiers() == 16) {
                JTreeTable.this.headerRenderer.setPressedColumn(-1);
                JTreeTable.this.tableHeader.repaint();
            }
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (JTreeTable.this.treeTableModelAdapter.isFiringChange()) {
                    return;
                }
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }
}

