/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import com.oracle.bmc.adm.ApplicationDependencyManagementClient;
import com.oracle.bmc.adm.model.KnowledgeBase;
import com.oracle.bmc.adm.requests.GetKnowledgeBaseRequest;
import com.oracle.bmc.adm.responses.GetKnowledgeBaseResponse;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.model.BmcException;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.adm.AuditException;
import org.netbeans.modules.cloud.oracle.adm.AuditOptions;
import org.netbeans.modules.cloud.oracle.adm.Bundle;
import org.netbeans.modules.cloud.oracle.adm.ErrorUtils;
import org.netbeans.modules.cloud.oracle.adm.KnowledgeBaseItem;
import org.netbeans.modules.cloud.oracle.adm.VulnerabilityWorker;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.openide.util.RequestProcessor;

public final class ProjectVulnerability {
    private final RequestProcessor AUDIT_PROCESSOR = new RequestProcessor(ProjectVulnerability.class.getName(), 4);
    private final RequestProcessor CALL_PROCESSOR = new RequestProcessor(ProjectVulnerability.class);
    private final Project project;
    private KnowledgeBaseItem knowledgeBaseItem = null;

    public ProjectVulnerability(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnowledgeBaseItem getProjectKnowledgeBase() {
        ProjectVulnerability projectVulnerability = this;
        synchronized (projectVulnerability) {
            return this.knowledgeBaseItem;
        }
    }

    public CompletableFuture<String> runProjectAudit(KnowledgeBaseItem item, AuditOptions options) {
        if (item != null) {
            this.setProjectKnowledgeBase(item);
        }
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.AUDIT_PROCESSOR.post(() -> {
            try {
                result.complete(VulnerabilityWorker.getInstance().findVulnerability(this.project, options));
            }
            catch (ThreadDeath x) {
                throw x;
            }
            catch (AuditException ex) {
                String projectDisplayName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
                ErrorUtils.processError(ex, Bundle.MSG_CreatingAuditFailed(projectDisplayName));
                result.completeExceptionally(ex);
            }
            catch (Error | Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<KnowledgeBaseItem> findKnowledgeBase(String knowledgeBaseId) {
        CompletableFuture<KnowledgeBaseItem> result = new CompletableFuture<KnowledgeBaseItem>();
        this.CALL_PROCESSOR.post(() -> {
            try (ApplicationDependencyManagementClient client = new ApplicationDependencyManagementClient((BasicAuthenticationDetailsProvider)OCIManager.getDefault().getConfigProvider());){
                GetKnowledgeBaseRequest request = GetKnowledgeBaseRequest.builder().knowledgeBaseId(knowledgeBaseId).build();
                GetKnowledgeBaseResponse response = client.getKnowledgeBase(request);
                KnowledgeBase p = response.getKnowledgeBase();
                result.complete(new KnowledgeBaseItemProxy(OCID.of(p.getId(), "KnowledgeBase"), p.getCompartmentId(), p.getDisplayName(), p.getTimeUpdated()));
            }
            catch (ThreadDeath x) {
                throw x;
            }
            catch (BmcException ex) {
                result.completeExceptionally(new AuditException(ex.getStatusCode(), ex.getOpcRequestId(), ex.getMessage(), ex));
            }
            catch (Error | Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnowledgeBaseItem setProjectKnowledgeBase(KnowledgeBaseItem item) {
        ProjectVulnerability projectVulnerability = this;
        synchronized (projectVulnerability) {
            this.knowledgeBaseItem = item;
            return this.knowledgeBaseItem;
        }
    }

    static class KnowledgeBaseItemProxy
    extends KnowledgeBaseItem {
        public KnowledgeBaseItemProxy(OCID id, String compartmentId, String displayName, Date timeUpdated) {
            super(id, compartmentId, displayName, timeUpdated);
        }

        @Override
        void registerItem() {
        }

        @Override
        public void refresh() {
            super.refresh();
            Collection<KnowledgeBaseItem> delegates = KnowledgeBaseItemProxy.findKnownInstances(this.getKey());
            for (KnowledgeBaseItem kbi : delegates) {
                kbi.refresh();
            }
        }
    }
}

