/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectActionContext;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.spi.ProjectArtifactsImplementation;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class ProjectArtifactsQuery {
    public static ArtifactsResult findArtifacts(Project project, Filter filter) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"filter", (Object)filter);
        ArrayList impls = new ArrayList(project.getLookup().lookupAll(ProjectArtifactsImplementation.class));
        TreeMap<Integer, List> buckets = new TreeMap<Integer, List>();
        for (ProjectArtifactsImplementation impl : impls) {
            Object r = impl.evaluate(filter);
            if (r == null) continue;
            buckets.computeIfAbsent(impl.getOrder(), i -> new ArrayList()).add(new E(r, impl));
        }
        List<E<?>> delegates = buckets.size() == 1 ? (List<E<?>>)buckets.values().iterator().next() : buckets.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
        return new ArtifactsResult(filter, delegates);
    }

    @NonNull
    public static Filter newQuery(@NullAllowed String artifactType) {
        return new Filter(artifactType, null, null, null);
    }

    @NonNull
    public static Filter newQuery(@NullAllowed String artifactType, @NullAllowed String classifier, @NullAllowed ProjectActionContext buildContext) {
        return new Filter(artifactType, classifier, null, buildContext);
    }

    @NonNull
    public static Filter newQuery(@NullAllowed String artifactType, @NullAllowed String classifier, @NullAllowed ProjectActionContext buildContext, String ... tags) {
        return new Filter(artifactType, classifier, tags == null || tags.length == 0 ? null : new HashSet<String>(Arrays.asList(tags)), buildContext);
    }

    public static final class Filter {
        public static final String TYPE_ALL = "<all>";
        public static final String CLASSIFIER_ANY = "<any>";
        private final Set<String> tags;
        private final String classifier;
        private final String artifactType;
        private final ProjectActionContext buildContext;

        Filter(String artifactType, String classifier, Set<String> tags, ProjectActionContext buildContext) {
            this.classifier = classifier;
            this.artifactType = artifactType;
            this.buildContext = buildContext;
            this.tags = tags == null ? Collections.emptySet() : Collections.unmodifiableSet(tags);
        }

        @CheckForNull
        public String getClassifier() {
            return this.classifier;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public boolean hasTag(String t) {
            return this.tags.contains(t);
        }

        @CheckForNull
        public String getArtifactType() {
            return this.artifactType;
        }

        @CheckForNull
        public ProjectActionContext getBuildContext() {
            return this.buildContext;
        }
    }

    public static final class ArtifactsResult {
        private final List<E<?>> delegates;
        private final Filter filter;
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private ChangeListener delListener;
        private List<ArtifactSpec> artifacts;
        private Boolean supportsChanges;

        ArtifactsResult(Filter filter, List<E<?>> delegates) {
            this.filter = filter;
            this.delegates = delegates;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ArtifactSpec> getArtifacts() {
            ArtifactsResult artifactsResult = this;
            synchronized (artifactsResult) {
                if (this.artifacts != null) {
                    return this.artifacts;
                }
            }
            return this.updateResults();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<ArtifactSpec> updateResults() {
            ChangeListener[] ll;
            Collection<ArtifactSpec> ex;
            boolean changes = false;
            LinkedHashSet<ArtifactSpec> specs = new LinkedHashSet<ArtifactSpec>();
            boolean single = this.filter.getArtifactType() == null && this.filter.getClassifier() == null;
            boolean shouldAdd = true;
            for (E<?> e : this.delegates) {
                List<ArtifactSpec> add;
                ex = e.findExcludedArtifacts();
                if (ex != null) {
                    specs.removeAll(ex);
                }
                if (shouldAdd && (add = e.findArtifacts()) != null && !add.isEmpty()) {
                    specs.addAll(add);
                    if (single) {
                        shouldAdd = false;
                    }
                }
                changes |= e.computeSupportsChanges();
            }
            ArrayList<ArtifactSpec> copy = new ArrayList<ArtifactSpec>(specs);
            ex = this;
            synchronized (ex) {
                if (null == this.supportsChanges) {
                    this.supportsChanges = changes;
                }
                if (this.artifacts != null && this.artifacts.equals(specs)) {
                    return copy;
                }
                if (this.artifacts == null) {
                    this.artifacts = copy;
                    return copy;
                }
                this.artifacts = copy;
                if (this.listeners.isEmpty()) {
                    return copy;
                }
                ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : ll) {
                l.stateChanged(e);
            }
            return copy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            ArtifactsResult artifactsResult = this;
            synchronized (artifactsResult) {
                if (Boolean.FALSE.equals(this.supportsChanges)) {
                    return;
                }
                if (this.delListener == null) {
                    this.delListener = WeakListeners.change(e -> this.updateResults(), null);
                    for (E<?> d : this.delegates) {
                        d.handleChangeListener(this.delListener, true);
                    }
                }
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            ArtifactsResult artifactsResult = this;
            synchronized (artifactsResult) {
                this.listeners.remove(l);
            }
        }
    }

    private static final class E<T> {
        final T data;
        final ProjectArtifactsImplementation<T> impl;

        public E(T data, ProjectArtifactsImplementation<T> impl) {
            this.data = data;
            this.impl = impl;
        }

        public Project findProject() {
            return this.impl.findProject(this.data);
        }

        public List<ArtifactSpec> findArtifacts() {
            return this.impl.findArtifacts(this.data);
        }

        public Collection<ArtifactSpec> findExcludedArtifacts() {
            return this.impl.findExcludedArtifacts(this.data);
        }

        public void handleChangeListener(ChangeListener l, boolean add) {
            this.impl.handleChangeListener(this.data, l, add);
        }

        public boolean computeSupportsChanges() {
            return this.impl.computeSupportsChanges(this.data);
        }
    }
}

