/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.jtreg;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.openjdk.common.BuildUtils;
import org.netbeans.modules.java.openjdk.common.ShortcutUtils;
import org.netbeans.modules.java.openjdk.jtreg.TestRootDescription;
import org.netbeans.modules.java.openjdk.jtreg.Utilities;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class ClassPathProviderImpl
implements ClassPathProvider {
    public ClassPath findClassPath(FileObject file, String type) {
        LinkedHashSet<FileObject> roots;
        block49: {
            boolean javac;
            TestRootDescription rootDesc = TestRootDescription.findRootDescriptionFor(file);
            if (rootDesc == null) {
                return null;
            }
            FileObject testProperties = rootDesc.testProperties;
            FileObject testRoot = rootDesc.testRoot;
            FileObject testRootFile = rootDesc.testRootFile;
            boolean bl = javac = (Utilities.isLangtoolsRepository(testRoot.getParent()) || testRoot.getNameExt().equals("langtools")) && ShortcutUtils.getDefault().shouldUseCustomTest("langtools", FileUtil.getRelativePath((FileObject)testRoot.getParent(), (FileObject)file));
            FileObject keyRoot = javac ? (testRoot.getNameExt().equals("langtools") ? Utilities.getLangtoolsKeyRoot(testRoot.getParent().getParent()) : Utilities.getLangtoolsKeyRoot(testRoot.getParent())) : null;
            switch (type) {
                case "classpath/compile": {
                    if (javac) {
                        ClassPath langtoolsCP = ClassPath.getClassPath((FileObject)keyRoot, (String)"classpath/compile");
                        Library testngLib = LibraryManager.getDefault().getLibrary("testng");
                        if (testngLib != null) {
                            return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathSupport.createClassPath((URL[])testngLib.getContent("classpath").toArray(new URL[0])), langtoolsCP});
                        }
                        if (langtoolsCP == null) {
                            return ClassPath.EMPTY;
                        }
                        return langtoolsCP;
                    }
                    return null;
                }
                case "classpath/boot": {
                    if (javac) {
                        try {
                            ClassPath langtoolsBCP = ClassPath.getClassPath((FileObject)keyRoot, (String)"classpath/boot");
                            ArrayList<URL> roots2 = new ArrayList<URL>();
                            for (String rootPaths : new String[]{"build/classes/", "build/java.compiler/classes/", "build/jdk.compiler/classes/", "build/jdk.javadoc/classes/", "build/jdk.dev/classes/"}) {
                                roots2.add(testRoot.getParent().toURI().resolve(rootPaths).toURL());
                            }
                            return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathSupport.createClassPath((URL[])roots2.toArray(new URL[roots2.size()])), langtoolsBCP});
                        }
                        catch (MalformedURLException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return null;
                }
                case "classpath/source": {
                    break;
                }
                default: {
                    return null;
                }
            }
            roots = new LinkedHashSet<FileObject>();
            if (testProperties != null) {
                roots.add(testProperties.getParent());
                try (InputStream in = testProperties.getInputStream();){
                    FileObject libDirsRoot;
                    Properties p = new Properties();
                    p.load(in);
                    String libDirsText = p.getProperty("lib.dirs");
                    FileObject fileObject = libDirsRoot = libDirsText != null ? this.resolve(testProperties, testRoot, libDirsText) : null;
                    if (libDirsRoot != null) {
                        roots.add(libDirsRoot);
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                if (file.isFolder()) {
                    return null;
                }
                roots.add(file.getParent());
                try (InputStreamReader r = new InputStreamReader(file.getInputStream(), FileEncodingQuery.getEncoding((FileObject)file));){
                    int read;
                    StringBuilder content = new StringBuilder();
                    while ((read = ((Reader)r).read()) != -1) {
                        content.append((char)read);
                    }
                    Pattern library = Pattern.compile("@library (.*)\n");
                    Matcher m = library.matcher(content.toString());
                    if (!m.find()) break block49;
                    ArrayList<FileObject> libDirs = new ArrayList<FileObject>();
                    try (InputStream in = testRootFile.getInputStream();){
                        Properties p = new Properties();
                        p.load(in);
                        String externalLibRoots = p.getProperty("external.lib.roots");
                        if (externalLibRoots != null) {
                            for (String extLib : externalLibRoots.split("\\s+")) {
                                FileObject libDir = BuildUtils.getFileObject(testRoot, extLib);
                                if (libDir == null) continue;
                                libDirs.add(libDir);
                            }
                        }
                    }
                    libDirs.add(testRoot);
                    String libraryPaths = m.group(1).trim();
                    for (String libraryPath : libraryPaths.split(" ")) {
                        for (FileObject libDir : libDirs) {
                            FileObject libFO = this.resolve(file, libDir, libraryPath);
                            if (libFO == null) continue;
                            roots.add(libFO);
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        for (FileObject root : roots) {
            this.initializeUsagesQuery(root);
        }
        return ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[0]));
    }

    private FileObject resolve(FileObject file, FileObject root, String spec) {
        if (spec.startsWith("/")) {
            return BuildUtils.getFileObject(root, spec.substring(1));
        }
        return BuildUtils.getFileObject(file.getParent(), spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeUsagesQuery(FileObject root) {
        try {
            Object[] cietcCreateParams;
            Method cietcCreate;
            ClassLoader cl = JavaSource.class.getClassLoader();
            Class<?> transactionContextClass = Class.forName("org.netbeans.modules.java.source.indexing.TransactionContext", false, cl);
            Class<?> serviceClass = Class.forName("org.netbeans.modules.java.source.indexing.TransactionContext$Service", false, cl);
            Method beginTrans = transactionContextClass.getDeclaredMethod("beginTrans", new Class[0]);
            Method commit = transactionContextClass.getDeclaredMethod("commit", new Class[0]);
            Method register = transactionContextClass.getDeclaredMethod("register", Class.class, serviceClass);
            Class<?> classIndexEventsTransactionClass = Class.forName("org.netbeans.modules.java.source.usages.ClassIndexEventsTransaction", false, cl);
            try {
                cietcCreate = classIndexEventsTransactionClass.getDeclaredMethod("create", Boolean.TYPE);
                cietcCreateParams = new Object[]{true};
            }
            catch (NoSuchMethodException ex) {
                cietcCreate = classIndexEventsTransactionClass.getDeclaredMethod("create", Boolean.TYPE, Supplier.class);
                cietcCreateParams = new Object[]{true, () -> true};
            }
            Class<?> classIndexManagerClass = Class.forName("org.netbeans.modules.java.source.usages.ClassIndexManager", false, cl);
            Method cimcGetDefault = classIndexManagerClass.getDeclaredMethod("getDefault", new Class[0]);
            Method createUsagesQuery = classIndexManagerClass.getDeclaredMethod("createUsagesQuery", URL.class, Boolean.TYPE);
            Class<?> classIndexImplClass = Class.forName("org.netbeans.modules.java.source.usages.ClassIndexImpl", false, cl);
            Class<?> stateClass = Class.forName("org.netbeans.modules.java.source.usages.ClassIndexImpl$State", false, cl);
            Method setState = classIndexImplClass.getDeclaredMethod("setState", stateClass);
            Field initialized = stateClass.getDeclaredField("INITIALIZED");
            Object transaction = beginTrans.invoke(null, new Object[0]);
            register.invoke(transaction, classIndexEventsTransactionClass, cietcCreate.invoke(null, cietcCreateParams));
            try {
                Object classIndexImpl = createUsagesQuery.invoke(cimcGetDefault.invoke(null, new Object[0]), root.toURL(), true);
                setState.invoke(classIndexImpl, initialized.get(null));
            }
            finally {
                commit.invoke(transaction, new Object[0]);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

