/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class SourceLevelQueryImpl
implements SourceLevelQueryImplementation2,
AntProjectListener {
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private AuxiliaryConfiguration aux;
    private Map<FileObject, R> sourceLevels;

    public SourceLevelQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
        this.helper.addAntProjectListener((AntProjectListener)this);
    }

    public SourceLevelQueryImplementation2.Result getSourceLevel(final FileObject file) {
        return (SourceLevelQueryImplementation2.Result)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceLevelQueryImplementation2.Result>(){

            public SourceLevelQueryImplementation2.Result run() {
                Map data = SourceLevelQueryImpl.this.init(true);
                for (Map.Entry entry : data.entrySet()) {
                    FileObject root = (FileObject)entry.getKey();
                    if (root != file && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
                    return (SourceLevelQueryImplementation2.Result)entry.getValue();
                }
                return null;
            }
        });
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.init(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<FileObject, R> init(boolean query) {
        Map<FileObject, R> retVal;
        HashMap<FileObject, R> added = new HashMap<FileObject, R>();
        HashMap<FileObject, Object[]> update = new HashMap<FileObject, Object[]>();
        LinkedList<R> remove = new LinkedList<R>();
        Iterator iterator = this;
        synchronized (iterator) {
            if (this.sourceLevels == null) {
                if (!query) {
                    return null;
                }
                this.sourceLevels = new HashMap<FileObject, R>();
            } else if (query) {
                return Collections.unmodifiableMap(new HashMap<FileObject, R>(this.sourceLevels));
            }
            Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/5", true);
            if (java != null) {
                for (Element element : XMLUtil.findSubElements((Element)java)) {
                    assert (element.getLocalName().equals("compilation-unit")) : element;
                    String lvl = this.getLevel(element);
                    List<FileObject> packageRoots = Classpaths.findPackageRoots(this.helper, this.evaluator, element);
                    for (FileObject root : packageRoots) {
                        SourceLevelQueryImplementation2.Result result = this.sourceLevels.remove(root);
                        if (result != null) {
                            update.put(root, new Object[]{result, lvl});
                            continue;
                        }
                        added.put(root, new R(lvl));
                    }
                }
            }
            remove.addAll(this.sourceLevels.values());
            this.sourceLevels.clear();
            this.sourceLevels.putAll(added);
            for (Map.Entry entry : update.entrySet()) {
                this.sourceLevels.put((FileObject)entry.getKey(), (R)((Object[])entry.getValue())[0]);
            }
            retVal = Collections.unmodifiableMap(new HashMap<FileObject, R>(this.sourceLevels));
        }
        for (Object[] toUpdate : update.values()) {
            ((R)toUpdate[0]).update((String)toUpdate[1]);
        }
        iterator = remove.iterator();
        while (iterator.hasNext()) {
            R toRemove = (R)iterator.next();
            toRemove.update(null);
        }
        return retVal;
    }

    private String getLevel(Element compilationUnitEl) {
        Element sourceLevelEl = XMLUtil.findElement((Element)compilationUnitEl, (String)"source-level", (String)"http://www.netbeans.org/ns/freeform-project-java/5");
        if (sourceLevelEl != null) {
            return XMLUtil.findText((Node)sourceLevelEl);
        }
        return null;
    }

    private static class R
    implements SourceLevelQueryImplementation2.Result {
        private final ChangeSupport changeSuppport = new ChangeSupport((Object)this);
        private volatile String sourceLevel;

        private R(String sourceLevel) {
            this.sourceLevel = sourceLevel;
        }

        private void update(String sourceLevel) {
            this.sourceLevel = sourceLevel;
            this.changeSuppport.fireChange();
        }

        public String getSourceLevel() {
            return this.sourceLevel;
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSuppport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSuppport.removeChangeListener(listener);
        }
    }
}

