/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.nativeexecution.NbRemoteNativeProcess;
import org.netbeans.modules.nativeexecution.RemoteNativeProcess;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.MiscUtils;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class ProcessUtils {
    private static final RequestProcessor RP = new RequestProcessor("ProcessUtils", 1);
    private static final String remoteCharSet = System.getProperty("cnd.remote.charset", "UTF-8");

    private ProcessUtils() {
    }

    public static String getRemoteCharSet() {
        return remoteCharSet;
    }

    public static boolean isAlive(Process p) {
        if (p instanceof RemoteNativeProcess) {
            RemoteNativeProcess rnp = (RemoteNativeProcess)p;
            return rnp.isAlive();
        }
        if (p instanceof NbRemoteNativeProcess) {
            NbRemoteNativeProcess rnp = (NbRemoteNativeProcess)p;
            return rnp.isAlive();
        }
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException x) {
            return true;
        }
    }

    public static BufferedReader getReader(InputStream is, boolean remote) {
        if (remote) {
            try {
                return new BufferedReader(new InputStreamReader(is, ProcessUtils.getRemoteCharSet()));
            }
            catch (UnsupportedEncodingException ex) {
                String msg = ProcessUtils.getRemoteCharSet() + " encoding is not supported, try to override it with cnd.remote.charset";
                Exceptions.printStackTrace((Throwable)new IllegalStateException(msg, ex));
            }
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    public static PrintWriter getWriter(OutputStream os, boolean remote) {
        if (remote) {
            try {
                return new PrintWriter(new OutputStreamWriter(os, ProcessUtils.getRemoteCharSet()));
            }
            catch (UnsupportedEncodingException ex) {
                String msg = ProcessUtils.getRemoteCharSet() + " encoding is not supported, try to override it with cnd.remote.charset";
                Exceptions.printStackTrace((Throwable)new IllegalStateException(msg, ex));
            }
        }
        return new PrintWriter(os);
    }

    public static List<String> readProcessError(Process p) throws IOException {
        if (p == null) {
            return Collections.emptyList();
        }
        return ProcessUtils.readProcessStreamImpl(p.getErrorStream(), ProcessUtils.isRemote(p));
    }

    public static String readProcessErrorLine(Process p) throws IOException {
        if (p == null) {
            return "";
        }
        return ProcessUtils.readProcessStreamLine(p.getErrorStream(), ProcessUtils.isRemote(p));
    }

    public static List<String> readProcessOutput(Process p) throws IOException {
        if (p == null) {
            return Collections.emptyList();
        }
        return ProcessUtils.readProcessStreamImpl(p.getInputStream(), ProcessUtils.isRemote(p));
    }

    public static String readProcessOutputLine(Process p) throws IOException {
        if (p == null) {
            return "";
        }
        return ProcessUtils.readProcessStreamLine(p.getInputStream(), ProcessUtils.isRemote(p));
    }

    private static boolean isRemote(Process process) {
        if (process instanceof NativeProcess) {
            return ((NativeProcess)process).getExecutionEnvironment().isRemote();
        }
        return false;
    }

    public static void logError(Level logLevel, java.util.logging.Logger log, ExitStatus exitStatus) throws IOException {
        if (log != null && log.isLoggable(logLevel)) {
            ProcessUtils.logErrorImpl(logLevel, log, exitStatus.getErrorLines());
        }
    }

    public static void logError(Level logLevel, java.util.logging.Logger log, Process p) throws IOException {
        if (log != null && log.isLoggable(logLevel)) {
            ProcessUtils.logErrorImpl(logLevel, log, ProcessUtils.readProcessError(p));
        } else {
            ProcessUtils.readAndIgnoreProcessStream(p.getErrorStream());
        }
    }

    private static void logErrorImpl(Level logLevel, java.util.logging.Logger log, List<String> err) throws IOException {
        for (String line : err) {
            log.log(logLevel, "ERROR: {0}", line);
        }
    }

    public static void readProcessOutputAsync(final Process process, final LineProcessor lineProcessor) {
        NativeTaskExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessUtils.readProcessStreamImpl(process.getInputStream(), ProcessUtils.isRemote(process), lineProcessor);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, "reading process output");
    }

    public static Future<List<String>> readProcessOutputAsync(final Process process) {
        return NativeTaskExecutorService.submit(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return ProcessUtils.readProcessStreamImpl(process.getInputStream(), ProcessUtils.isRemote(process));
            }
        }, "reading process output");
    }

    public static void readProcessErrorAsync(final Process process, final LineProcessor lineProcessor) {
        NativeTaskExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessUtils.readProcessStreamImpl(process.getErrorStream(), ProcessUtils.isRemote(process), lineProcessor);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, "reading process error");
    }

    public static Future<List<String>> readProcessErrorAsync(final Process process) {
        return NativeTaskExecutorService.submit(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return ProcessUtils.readProcessStreamImpl(process.getErrorStream(), ProcessUtils.isRemote(process));
            }
        }, "reading process error");
    }

    private static void readAndIgnoreProcessStream(InputStream stream) throws IOException {
        if (stream != null) {
            try (BufferedReader br = ProcessUtils.getReader(stream, true);){
                while (br.readLine() != null) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readProcessStreamImpl(InputStream stream, boolean remoteStream) throws IOException {
        if (stream == null) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        try (BufferedReader br = ProcessUtils.getReader(stream, remoteStream);){
            String line;
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readProcessStreamImpl(InputStream stream, boolean remoteStream, LineProcessor lineProcessor) throws IOException {
        if (stream == null) {
            lineProcessor.reset();
            lineProcessor.close();
        } else {
            lineProcessor.reset();
            BufferedReader br = ProcessUtils.getReader(stream, remoteStream);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    lineProcessor.processLine(line);
                }
            }
            finally {
                lineProcessor.close();
                if (br != null) {
                    br.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readProcessStreamLine(InputStream stream, boolean remoteStream) throws IOException {
        if (stream == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        try (BufferedReader br = ProcessUtils.getReader(stream, remoteStream);){
            String line;
            boolean first = true;
            while ((line = br.readLine()) != null) {
                if (!first) {
                    result.append('\n');
                }
                result.append(line);
                first = false;
            }
        }
        return result.toString();
    }

    public static <T extends Process> T ignoreProcessOutputAndError(T p) {
        ProcessUtils.ignoreProcessOutput(p);
        ProcessUtils.ignoreProcessError(p);
        return p;
    }

    public static <T extends Process> T ignoreProcessError(final T p) {
        if (p != null) {
            NativeTaskExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProcessUtils.readAndIgnoreProcessStream(p.getErrorStream());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, "Reading process error " + p);
        }
        return p;
    }

    public static <T extends Process> T ignoreProcessOutput(final T p) {
        if (p != null) {
            NativeTaskExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProcessUtils.readAndIgnoreProcessStream(p.getInputStream());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, "Reading process output " + p);
        }
        return p;
    }

    public static void writeError(Writer error, Process p) throws IOException {
        class MyLineProcessor
        implements LineProcessor {
            private IOException writeEx = null;
            final /* synthetic */ Writer val$error;

            MyLineProcessor(Writer writer) {
                this.val$error = writer;
            }

            public void processLine(String line) {
                if (this.writeEx == null) {
                    try {
                        this.val$error.write(line);
                    }
                    catch (IOException ex) {
                        this.writeEx = ex;
                    }
                }
            }

            public void reset() {
            }

            public void close() {
            }
        }
        MyLineProcessor myLProcessor = new MyLineProcessor(error);
        ProcessUtils.readProcessStreamImpl(p.getErrorStream(), ProcessUtils.isRemote(p), myLProcessor);
        if (myLProcessor.writeEx != null) {
            throw myLProcessor.writeEx;
        }
    }

    public static void destroy(Process process) {
        process.destroy();
        try {
            process.exitValue();
            return;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            ExecutionEnvironment execEnv = process instanceof NativeProcess ? ((NativeProcess)process).getExecutionEnvironment() : ExecutionEnvironmentFactory.getLocal();
            int pid = ProcessUtils.getPID(process);
            if (pid > 0) {
                try {
                    CommonTasksSupport.sendSignal(execEnv, pid, Signal.SIGKILL, null).get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    private static int getPID(Process process) {
        int pid = -1;
        try {
            if (process instanceof NativeProcess) {
                pid = ((NativeProcess)process).getPID();
            } else {
                String className = process.getClass().getName();
                if ("java.lang.UNIXProcess".equals(className)) {
                    Field f = process.getClass().getDeclaredField("pid");
                    f.setAccessible(true);
                    pid = f.getInt(process);
                }
            }
        }
        catch (Throwable e) {
            Logger.getInstance().log(Level.FINE, e.getMessage(), e);
        }
        return pid;
    }

    public static Future<ExitStatus> execute(final ExecutionEnvironment execEnv, RequestProcessor rp, final PostExecutor postExecutor, final String executable, final String ... args) {
        RequestProcessor processor = rp == null ? RP : rp;
        return processor.submit((Callable)new Callable<ExitStatus>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ExitStatus call() throws Exception {
                ExitStatus status = null;
                String error = null;
                try {
                    status = ProcessUtils.execute(execEnv, executable, args);
                    if (postExecutor != null) {
                        postExecutor.processFinished(error == null ? status : new ExitStatus(1, null, Arrays.asList(error.split("\n"))));
                    }
                }
                catch (Throwable t) {
                    try {
                        error = t.getMessage();
                        if (postExecutor != null) {
                            postExecutor.processFinished(error == null ? status : new ExitStatus(1, null, Arrays.asList(error.split("\n"))));
                        }
                    }
                    catch (Throwable throwable) {
                        if (postExecutor != null) {
                            postExecutor.processFinished(error == null ? status : new ExitStatus(1, null, Arrays.asList(error.split("\n"))));
                        }
                        throw throwable;
                    }
                }
                return status;
            }
        });
    }

    public static ExitStatus execute(ExecutionEnvironment execEnv, String executable, String ... args) {
        return ProcessUtils.execute(NativeProcessBuilder.newProcessBuilder(execEnv).setExecutable(executable).setArguments(args));
    }

    public static ExitStatus executeInDir(String workingDir, ExecutionEnvironment execEnv, String executable, String ... args) {
        return ProcessUtils.execute(NativeProcessBuilder.newProcessBuilder(execEnv).setExecutable(executable).setArguments(args).setWorkingDirectory(workingDir));
    }

    public static ExitStatus executeWithoutMacroExpansion(String workingDir, ExecutionEnvironment execEnv, String executable, String ... args) {
        if (workingDir != null) {
            return ProcessUtils.execute(NativeProcessBuilder.newProcessBuilder(execEnv).setExecutable(executable).setArguments(args).setMacroExpansion(false));
        }
        return ProcessUtils.execute(NativeProcessBuilder.newProcessBuilder(execEnv).setExecutable(executable).setArguments(args).setWorkingDirectory(workingDir).setMacroExpansion(false));
    }

    public static ExitStatus execute(NativeProcessBuilder processBuilder) {
        return ProcessUtils.execute(processBuilder, null);
    }

    public static ExitStatus execute(NativeProcessBuilder processBuilder, byte[] input) {
        ExitStatus result;
        if (processBuilder == null) {
            throw new NullPointerException("NULL process builder!");
        }
        processBuilder.setX11Forwarding(false);
        processBuilder.setInitialSuspend(false);
        processBuilder.unbufferOutput(false);
        processBuilder.useExternalTerminal(null);
        try {
            final NativeProcess process = processBuilder.call();
            Future<List<String>> error = processBuilder.redirectErrorStream() ? null : NativeTaskExecutorService.submit(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ProcessUtils.readProcessError(process);
                }
            }, "e");
            Future<List<String>> output = NativeTaskExecutorService.submit(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ProcessUtils.readProcessOutput(process);
                }
            }, "o");
            if (input != null && input.length > 0) {
                process.getOutputStream().write(input);
                process.getOutputStream().close();
            }
            result = new ExitStatus(process.waitFor(), output.get(), error == null ? null : error.get());
        }
        catch (InterruptedException ex) {
            result = new ExitStatus(-100, null, MiscUtils.getMessageAsList(ex));
        }
        catch (Throwable th) {
            Logger.getInstance().log(Level.INFO, th.getMessage(), th);
            result = new ExitStatus(-200, null, MiscUtils.getMessageAsList(th));
        }
        return result;
    }

    public static ExitStatus execute(ProcessBuilder processBuilder) {
        return ProcessUtils.execute(processBuilder, null);
    }

    public static ExitStatus execute(ProcessBuilder processBuilder, byte[] input) {
        ExitStatus result;
        if (processBuilder == null) {
            throw new NullPointerException("NULL process builder!");
        }
        try {
            final Process process = processBuilder.start();
            Future<List<String>> error = processBuilder.redirectErrorStream() || processBuilder.redirectError() != ProcessBuilder.Redirect.PIPE ? null : NativeTaskExecutorService.submit(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ProcessUtils.readProcessError(process);
                }
            }, "e");
            Future<List<String>> output = NativeTaskExecutorService.submit(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ProcessUtils.readProcessOutput(process);
                }
            }, "o");
            if (input != null && input.length > 0) {
                process.getOutputStream().write(input);
                process.getOutputStream().close();
            }
            result = new ExitStatus(process.waitFor(), output.get(), error == null ? null : error.get());
        }
        catch (InterruptedException ex) {
            result = new ExitStatus(-100, null, MiscUtils.getMessageAsList(ex));
        }
        catch (Throwable th) {
            Logger.getInstance().log(Level.INFO, th.getMessage(), th);
            result = new ExitStatus(-200, null, MiscUtils.getMessageAsList(th));
        }
        return result;
    }

    public static interface PostExecutor {
        public void processFinished(ExitStatus var1);
    }

    public static final class ExitStatus {
        public final int exitCode;
        private final String error;
        private final String output;
        private final List<String> outputLines;
        private final List<String> errorLines;

        public ExitStatus(int exitCode, List<String> outputLines, List<String> errorLines) {
            this.exitCode = exitCode;
            this.outputLines = outputLines == null ? Collections.emptyList() : Collections.unmodifiableList(outputLines);
            this.output = outputLines == null || outputLines.isEmpty() ? "" : this.merge(outputLines);
            this.errorLines = errorLines == null ? Collections.emptyList() : Collections.unmodifiableList(errorLines);
            this.error = errorLines == null || errorLines.isEmpty() ? "" : this.merge(errorLines);
        }

        private String merge(List<String> outputLines) {
            StringBuilder sb = new StringBuilder();
            if (outputLines != null) {
                for (String line : outputLines) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(line);
                }
            }
            return sb.toString();
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }

        public String toString() {
            return "ExitStatus exitCode=" + this.exitCode + "\nerror=" + this.getErrorString() + "\noutput=" + this.getOutputString();
        }

        public String getOutputString() {
            return this.output;
        }

        public List<String> getOutputLines() {
            return this.outputLines;
        }

        public String getErrorString() {
            return this.error;
        }

        public List<String> getErrorLines() {
            return this.errorLines;
        }
    }
}

