/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

class FilteringIterable<T>
implements Iterable<T> {
    private final Iterable<? extends T> delegate;
    private final Function<T, Boolean> filter;

    public FilteringIterable(Iterable<? extends T> delegate, Function<T, Boolean> filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteringIterator<T>(this.delegate.iterator(), this.filter);
    }

    private static class FilteringIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> delegate;
        private final Function<T, Boolean> filter;
        private T next;

        public FilteringIterator(Iterator<? extends T> delegate, Function<T, Boolean> filter) {
            this.delegate = delegate;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            this.fillNextIfPossible();
            return this.next != null;
        }

        @Override
        public T next() {
            this.fillNextIfPossible();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T value = this.next;
            this.next = null;
            return value;
        }

        private void fillNextIfPossible() {
            if (this.next == null) {
                while (this.delegate.hasNext()) {
                    T nextCandiate = this.delegate.next();
                    if (!this.filter.apply(nextCandiate).booleanValue()) continue;
                    this.next = nextCandiate;
                    break;
                }
            }
        }
    }
}

