/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.browser.spi.MessageDispatcher;
import org.netbeans.modules.web.browser.spi.PageInspectionHandle;
import org.netbeans.modules.web.browser.spi.PageInspectorCustomizer;
import org.netbeans.modules.web.inspect.PageModel;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.ui.DomTCController;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.knockout.KnockoutTCController;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PageInspectorImpl
extends PageInspector {
    private static final String SELECTION_MODE_COMPONENT_NAME = "selectionModeSwitch";
    static final RequestProcessor RP = new RequestProcessor(PageInspectorImpl.class.getName());
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport((Object)this);
    private PageModel pageModel;
    private MessageDispatcher.MessageListener messageListener;
    private MessageDispatcher messageDispatcher;
    private final Object LOCK = new Object();
    private final Object PAGE_MODEL_LOCK = new Object();
    private PageInspectorCustomizer pageInspectorCustomizer;
    private PropertyChangeListener pageInspectorCustomizerListener;

    public static PageInspectorImpl getDefault() {
        return (PageInspectorImpl)PageInspector.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectPage(Lookup pageContext) {
        DomTCController.getDefault();
        KnockoutTCController.getDefault();
        Object object = this.LOCK;
        synchronized (object) {
            PageModel oldModel = this.getPage();
            if (oldModel != null) {
                oldModel.dispose();
                if (this.messageDispatcher != null) {
                    this.messageDispatcher.removeMessageListener(this.messageListener);
                }
                if (this.pageInspectorCustomizer != null) {
                    this.pageInspectorCustomizer.removePropertyChangeListener(this.pageInspectorCustomizerListener);
                }
                Object object2 = this.PAGE_MODEL_LOCK;
                synchronized (object2) {
                    this.pageModel = null;
                }
                this.messageDispatcher = null;
                this.messageListener = null;
                this.pageInspectorCustomizer = null;
                this.pageInspectorCustomizerListener = null;
            }
            Resource.clearCache();
            WebKitDebugging webKit = (WebKitDebugging)pageContext.lookup(WebKitDebugging.class);
            if (webKit != null) {
                PageInspectionHandle inspectionHandle;
                WebKitPageModel newModel = new WebKitPageModel(pageContext);
                this.messageDispatcher = (MessageDispatcher)pageContext.lookup(MessageDispatcher.class);
                if (this.messageDispatcher != null) {
                    this.messageListener = new InspectionMessageListener(newModel, pageContext);
                    this.messageDispatcher.addMessageListener(this.messageListener);
                }
                this.initSelectionMode((JToolBar)pageContext.lookup(JToolBar.class), (JPopupMenu)pageContext.lookup(JPopupMenu.class), newModel);
                Project p = (Project)pageContext.lookup(Project.class);
                if (p != null) {
                    this.pageInspectorCustomizer = (PageInspectorCustomizer)p.getLookup().lookup(PageInspectorCustomizer.class);
                    if (this.pageInspectorCustomizer != null) {
                        this.pageInspectorCustomizerListener = this.createPageInspectorCustomizerListener(newModel, this.pageInspectorCustomizer);
                        this.pageInspectorCustomizer.addPropertyChangeListener(this.pageInspectorCustomizerListener);
                        ((PageModel)newModel).setSynchronizeSelection(this.pageInspectorCustomizer.isHighlightSelectionEnabled());
                    }
                }
                if ((inspectionHandle = (PageInspectionHandle)pageContext.lookup(PageInspectionHandle.class)) != null) {
                    final WebKitPageModel model = newModel;
                    newModel.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            String propertyName = evt.getPropertyName();
                            if ("selectionMode".equals(propertyName)) {
                                inspectionHandle.setSelectionMode(model.isSelectionMode());
                            } else if ("synchronizeSelection".equals(propertyName)) {
                                inspectionHandle.setSynchronizeSelection(model.isSynchronizeSelection());
                            }
                        }
                    });
                    inspectionHandle.setSelectionMode(((PageModel)model).isSelectionMode());
                    inspectionHandle.setSynchronizeSelection(((PageModel)model).isSynchronizeSelection());
                }
                Object object3 = this.PAGE_MODEL_LOCK;
                synchronized (object3) {
                    this.pageModel = newModel;
                }
            }
        }
        this.firePropertyChange("model", null, null);
    }

    PropertyChangeListener createPageInspectorCustomizerListener(final PageModel pageModel, final PageInspectorCustomizer customizer) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("highlight.selection".equals(propertyName)) {
                    boolean synchronize = customizer.isHighlightSelectionEnabled();
                    pageModel.setSynchronizeSelection(synchronize);
                }
            }
        };
    }

    private void initSelectionMode(JToolBar toolBar, JPopupMenu contextMenu, final PageModel pageModel) {
        if (toolBar != null) {
            ImageIcon selectionModeIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/inspect/resources/selectionMode.png", (boolean)true);
            final JToggleButton selectionModeButton = new JToggleButton(selectionModeIcon);
            KeyStroke ks = KeyStroke.getKeyStroke(83, 192);
            selectionModeButton.putClientProperty("AcceleratorKey", ks);
            String selectionModeTooltip = NbBundle.getMessage(PageInspectorImpl.class, (String)"PageInspectorImpl.selectionMode");
            selectionModeButton.setToolTipText(selectionModeTooltip);
            selectionModeButton.setName(SELECTION_MODE_COMPONENT_NAME);
            selectionModeButton.setFocusPainted(false);
            final JCheckBoxMenuItem selectionModeMenu = new JCheckBoxMenuItem(NbBundle.getMessage(PageInspectorImpl.class, (String)"PageInspectorImpl.selectionModeShort"));
            selectionModeMenu.setAccelerator(ks);
            selectionModeMenu.setIcon(selectionModeIcon);
            ItemListener listener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    final boolean selectionMode = e.getStateChange() == 1;
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            pageModel.setSelectionMode(selectionMode);
                        }
                    });
                }
            };
            selectionModeButton.addItemListener(listener);
            selectionModeMenu.addItemListener(listener);
            pageModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("selectionMode".equals(propName)) {
                        final boolean selectionMode = pageModel.isSelectionMode();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                selectionModeButton.setSelected(selectionMode);
                                selectionModeMenu.setSelected(selectionMode);
                            }
                        });
                    }
                }
            });
            if (toolBar.getComponentCount() == 0) {
                toolBar.addSeparator();
            }
            int gapSize = LayoutStyle.getInstance().getPreferredGap(selectionModeButton, selectionModeButton, LayoutStyle.ComponentPlacement.RELATED, 7, toolBar);
            toolBar.add(Box.createHorizontalStrut(gapSize));
            toolBar.add(selectionModeButton);
            selectionModeButton.setSelected(pageModel.isSelectionMode());
            selectionModeMenu.setSelected(pageModel.isSelectionMode());
            if (null != contextMenu) {
                contextMenu.addSeparator();
                contextMenu.add(selectionModeMenu);
            }
        }
    }

    void uninitSelectionMode(JToolBar toolBar) {
        if (toolBar != null) {
            for (Component component : toolBar.getComponents()) {
                if (!SELECTION_MODE_COMPONENT_NAME.equals(component.getName())) continue;
                toolBar.remove(component);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageModel getPage() {
        Object object = this.PAGE_MODEL_LOCK;
        synchronized (object) {
            return this.pageModel;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    private void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.propChangeSupport.firePropertyChange(propName, oldValue, newValue);
    }

    private class InspectionMessageListener
    implements MessageDispatcher.MessageListener {
        private static final String MESSAGE_TYPE = "message";
        private static final String MESSAGE_SELECTION_MODE = "selection_mode";
        private static final String MESSAGE_SELECTION_MODE_ATTR = "selectionMode";
        private final PageModel pageModel;
        private final Lookup pageContext;

        InspectionMessageListener(PageModel pageModel, Lookup pageContext) {
            this.pageModel = pageModel;
            this.pageContext = pageContext;
        }

        public void messageReceived(String featureId, final String messageTxt) {
            if (messageTxt == null && !"inspect".equals(featureId)) {
                return;
            }
            if (messageTxt == null) {
                this.processMessage(messageTxt);
            } else {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        InspectionMessageListener.this.processMessage(messageTxt);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMessage(String messageTxt) {
            if (messageTxt == null) {
                Object object = PageInspectorImpl.this.LOCK;
                synchronized (object) {
                    PageInspectorImpl.this.uninitSelectionMode((JToolBar)this.pageContext.lookup(JToolBar.class));
                    if (this.pageModel == PageInspectorImpl.this.getPage()) {
                        PageInspectorImpl.this.inspectPage(Lookup.EMPTY);
                    }
                }
            }
            try {
                JSONObject message = (JSONObject)JSONValue.parseWithException((String)messageTxt);
                Object type = message.get((Object)MESSAGE_TYPE);
                if (MESSAGE_SELECTION_MODE.equals(type)) {
                    boolean selectionMode = (Boolean)message.get((Object)MESSAGE_SELECTION_MODE_ATTR);
                    this.pageModel.setSelectionMode(selectionMode);
                }
            }
            catch (ParseException ex) {
                Logger.getLogger(PageInspectorImpl.class.getName()).log(Level.INFO, "Ignoring message that is not in JSON format: {0}", messageTxt);
            }
        }
    }
}

