/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.ApplicationMetadata;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleListener;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ResourceChangeReporterFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ResourceChangeReporterImplementation;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.EarProjectGenerator;
import org.netbeans.modules.j2ee.earproject.WebBrowserProvider;
import org.netbeans.modules.j2ee.earproject.model.ApplicationMetadataModelImpl;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.util.EarProjectUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelFactory;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelImplementation;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public final class ProjectEar
extends J2eeApplicationProvider
implements ModuleChangeReporter,
EjbChangeDescriptor,
PropertyChangeListener,
J2eeApplicationImplementation2 {
    public static final String FILE_DD = "application.xml";
    private static final Logger LOGGER = Logger.getLogger(ProjectEar.class.getName());
    private final ResourceChangeReporter rcr = ResourceChangeReporterFactory.createResourceChangeReporter((ResourceChangeReporterImplementation)new EarResourceChangeReporter());
    private final EarProject project;
    private PropertyChangeSupport propertyChangeSupport;
    private J2eeApplication j2eeApplication;
    private Application application;
    private MetadataModel<ApplicationMetadata> metadataModel;
    private final J2eeModuleProvider.DeployOnSaveSupport deployOnSaveSupport = new DeployOnSaveSupportProxy();
    final CopyOnSaveSupport copyOnSaveSupport = new CopyOnSaveSupport();
    private Map<String, J2eeModuleProvider> mods = new HashMap<String, J2eeModuleProvider>();
    private final List<ModuleListener> modListeners = new ArrayList<ModuleListener>();

    ProjectEar(EarProject project) {
        this.project = project;
    }

    public FileObject getDeploymentDescriptor() {
        FileObject metaInf = this.getMetaInf();
        if (metaInf != null) {
            return metaInf.getFileObject(FILE_DD);
        }
        return null;
    }

    public FileObject getMetaInf() {
        return this.project.getOrCreateMetaInfDir();
    }

    public File getResourceDirectory() {
        File f = this.project.getFile("resource.dir");
        if (f == null) {
            f = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "setup");
        }
        return f;
    }

    public ClassPathProvider getClassPathProvider() {
        return (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
    }

    public FileObject getArchive() {
        return this.project.getFileObject("dist.jar");
    }

    public synchronized J2eeModule getJ2eeModule() {
        if (this.j2eeApplication == null) {
            this.j2eeApplication = J2eeModuleFactory.createJ2eeApplication((J2eeApplicationImplementation2)this);
        }
        return this.j2eeApplication;
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this;
    }

    public ResourceChangeReporter getResourceChangeReporter() {
        return this.rcr;
    }

    public String getServerID() {
        return this.project.getServerID();
    }

    public void setServerInstanceID(String severInstanceID) {
    }

    public String getServerInstanceID() {
        return this.project.getServerInstanceID();
    }

    public Iterator getArchiveContents() throws IOException {
        FileObject content = this.getContentDirectory();
        content.refresh();
        return new IT(this, content);
    }

    public FileObject getContentDirectory() {
        return this.project.getFileObject("build.dir");
    }

    public FileObject getBuildDirectory() {
        return this.project.getFileObject("build.dir");
    }

    public synchronized MetadataModel<ApplicationMetadata> getMetadataModel() {
        if (this.metadataModel == null) {
            this.metadataModel = MetadataModelFactory.createMetadataModel((MetadataModelImplementation)new ApplicationMetadataModelImpl(this.project));
        }
        return this.metadataModel;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        if (type == ApplicationMetadata.class) {
            MetadataModel<ApplicationMetadata> model = this.getMetadataModel();
            return model;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application getApplication() {
        try {
            if (DDHelper.isApplicationXMLCompulsory((Project)this.project) || EarProjectUtil.isDDWritable(this.project)) {
                if (!DDHelper.isApplicationXMLCompulsory((Project)this.project)) {
                    ProjectEar projectEar = this;
                    synchronized (projectEar) {
                        if (this.application != null) {
                            this.application = null;
                        }
                    }
                }
                return this.getDDFromFile();
            }
            return this.setupDDFromVirtual();
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    private Application getDDFromFile() throws IOException {
        FileObject dd = this.getDeploymentDescriptor();
        if (dd == null) {
            dd = EarProjectGenerator.setupDD(this.project.getJ2eeProfile(), this.getMetaInf(), this.project);
        }
        return DDProvider.getDefault().getDDRoot(dd);
    }

    private synchronized Application setupDDFromVirtual() throws IOException {
        if (EarProjectUtil.isDDWritable(this.project)) {
            return this.getApplication();
        }
        if (this.application != null) {
            return this.application;
        }
        FileObject root = FileUtil.createMemoryFileSystem().getRoot();
        Profile p = this.getJ2eeProfile();
        if (p == null) {
            p = Profile.JAVA_EE_7_FULL;
        }
        FileObject dd = DDHelper.createApplicationXml((Profile)p, (FileObject)root, (boolean)true);
        this.application = DDProvider.getDefault().getDDRoot(dd);
        this.application.setDisplayName(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        for (ClassPathSupport.Item item : EarProjectProperties.getJarContentAdditional(this.project)) {
            EarProjectProperties.addItemToAppDD(this.project, this.application, item);
        }
        return this.application;
    }

    public EjbChangeDescriptor getEjbChanges(long timestamp) {
        return this;
    }

    public J2eeModule.Type getModuleType() {
        return J2eeModule.Type.EAR;
    }

    public String getModuleVersion() {
        Profile p = Profile.fromPropertiesString((String)this.project.evaluator().getProperty("j2ee.platform"));
        if (p == null) {
            p = Profile.JAVA_EE_7_FULL;
        }
        if (Profile.JAKARTA_EE_9_1_FULL.equals(p) || Profile.JAKARTA_EE_9_FULL.equals(p)) {
            return "9";
        }
        if (Profile.JAKARTA_EE_8_FULL.equals(p) || Profile.JAVA_EE_8_FULL.equals(p)) {
            return "8";
        }
        if (Profile.JAVA_EE_7_FULL.equals(p)) {
            return "7";
        }
        if (Profile.JAVA_EE_6_FULL.equals(p)) {
            return "6";
        }
        if (Profile.JAVA_EE_5.equals(p)) {
            return "5";
        }
        if (Profile.J2EE_14.equals(p)) {
            return "1.4";
        }
        return "7";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dd_version")) {
            String oldVersion = (String)evt.getOldValue();
            String newVersion = (String)evt.getNewValue();
            this.getPropertyChangeSupport().firePropertyChange("moduleVersion", oldVersion, newVersion);
        } else if ("j2ee.server.instance".equals(evt.getPropertyName())) {
            Deployment d = Deployment.getDefault();
            String oldServerID = evt.getOldValue() == null ? null : d.getServerID((String)evt.getOldValue());
            String newServerID = evt.getNewValue() == null ? null : d.getServerID((String)evt.getNewValue());
            this.fireServerChange(oldServerID, newServerID);
        } else if ("resource.dir".equals(evt.getPropertyName())) {
            String oldValue = (String)evt.getOldValue();
            String newValue = (String)evt.getNewValue();
            this.getPropertyChangeSupport().firePropertyChange("resourceDir", oldValue == null ? null : new File(oldValue), newValue == null ? null : new File(newValue));
        }
    }

    public String getUrl() {
        return "";
    }

    public boolean isManifestChanged(long timestamp) {
        return false;
    }

    public void setUrl(String url) {
        throw new UnsupportedOperationException("Cannot customize URL of web module");
    }

    public boolean ejbsChanged() {
        return false;
    }

    public String[] getChangedEjbs() {
        return new String[0];
    }

    public Profile getJ2eeProfile() {
        return this.project.getJ2eeProfile();
    }

    public FileObject[] getSourceRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        FileObject[] roots = new FileObject[groups.length + 1];
        roots[0] = this.getMetaInf();
        for (int i = 0; i < groups.length; ++i) {
            roots[i + 1] = groups[i].getRootFolder();
        }
        return roots;
    }

    void setModules(Map<String, J2eeModuleProvider> mods) {
        if (null == mods) {
            throw new IllegalArgumentException("mods");
        }
        this.mods = mods;
    }

    public J2eeModule[] getModules() {
        J2eeModule[] retVal = new J2eeModule[this.mods.size()];
        int i = 0;
        for (J2eeModuleProvider provider : this.mods.values()) {
            retVal[i++] = provider.getJ2eeModule();
        }
        return retVal;
    }

    public void addModuleProvider(J2eeModuleProvider jmp, String uri) {
        this.mods.put(uri, jmp);
        J2eeModule jm = jmp.getJ2eeModule();
        this.fireAddModule(jm);
    }

    public void removeModuleProvider(J2eeModuleProvider jmp, String uri) {
        J2eeModule jm = jmp.getJ2eeModule();
        this.fireRemoveModule(jm);
        this.mods.remove(uri);
    }

    private void fireAddModule(J2eeModule jm) {
        for (ModuleListener ml : this.modListeners) {
            try {
                ml.addModule(jm);
            }
            catch (RuntimeException rex) {
                LOGGER.log(Level.INFO, rex.getLocalizedMessage());
            }
        }
    }

    private void fireRemoveModule(J2eeModule jm) {
        for (ModuleListener ml : this.modListeners) {
            try {
                ml.removeModule(jm);
            }
            catch (RuntimeException rex) {
                LOGGER.log(Level.FINE, rex.getLocalizedMessage());
            }
        }
    }

    public void addModuleListener(ModuleListener ml) {
        this.modListeners.add(ml);
    }

    public void removeModuleListener(ModuleListener ml) {
        this.modListeners.remove(ml);
    }

    public J2eeModuleProvider getChildModuleProvider(String uri) {
        return this.mods.get(uri);
    }

    public J2eeModuleProvider[] getChildModuleProviders() {
        return this.mods.values().toArray(new J2eeModuleProvider[this.mods.size()]);
    }

    public J2eeModuleProvider.DeployOnSaveSupport getDeployOnSaveSupport() {
        return this.deployOnSaveSupport;
    }

    public boolean isOnlyCompileOnSaveEnabled() {
        return Boolean.parseBoolean(this.project.evaluator().getProperty("j2ee.compile.on.save")) && !Boolean.parseBoolean(this.project.evaluator().getProperty("j2ee.deploy.on.save"));
    }

    public File getDeploymentConfigurationFile(String name) {
        FileObject moduleFolder;
        String path = this.getConfigSupport().getContentRelativePath(name);
        if (path == null) {
            path = name;
        }
        if (path.startsWith("META-INF/")) {
            path = path.substring(8);
        }
        if ((moduleFolder = this.getMetaInf()) == null) {
            return null;
        }
        File configFolder = FileUtil.toFile((FileObject)moduleFolder);
        return new File(configFolder, path);
    }

    public void addEjbJarModule(EjbJar module) {
        FileObject childFO = module.getDeploymentDescriptor();
        if (childFO == null) {
            childFO = module.getMetaInf();
        }
        this.addModule(childFO);
    }

    public void addWebModule(WebModule module) {
        FileObject childFO = module.getDeploymentDescriptor();
        if (childFO == null) {
            childFO = module.getWebInf();
        }
        this.addModule(childFO);
    }

    public void addCarModule(Car module) {
        FileObject childFO = module.getDeploymentDescriptor();
        if (childFO == null) {
            childFO = module.getMetaInf();
        }
        this.addModule(childFO);
    }

    private void addModule(FileObject childFO) {
        Project owner = null;
        if (childFO != null) {
            owner = FileOwnerQuery.getOwner((FileObject)childFO);
        }
        if (owner == null) {
            LOGGER.log(Level.INFO, "Unable to add module to the Enterpise Application. Owner project not found.");
        } else {
            EarProjectProperties.addJ2eeSubprojects(this.project, new Project[]{owner});
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeSupport getPropertyChangeSupport() {
        Application app = this.getApplication();
        ProjectEar projectEar = this;
        synchronized (projectEar) {
            if (this.propertyChangeSupport == null) {
                this.propertyChangeSupport = new PropertyChangeSupport(this);
                if (app != null) {
                    PropertyChangeListener l = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)app);
                    app.addPropertyChangeListener(l);
                }
            }
            return this.propertyChangeSupport;
        }
    }

    public J2eeModule getWebModule() {
        for (J2eeModule mod : this.getModules()) {
            if (mod.getType() != J2eeModule.Type.WAR) continue;
            return mod;
        }
        return null;
    }

    private class EarResourceChangeReporter
    implements ResourceChangeReporterImplementation {
        private EarResourceChangeReporter() {
        }

        public boolean isServerResourceChanged(long lastDeploy) {
            File[] children;
            File resDir = ProjectEar.this.getResourceDirectory();
            if (resDir != null && resDir.exists() && resDir.isDirectory() && (children = resDir.listFiles()) != null) {
                for (File file : children) {
                    if (file.lastModified() <= lastDeploy) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class DeployOnSaveSupportProxy
    implements ArtifactListener,
    J2eeModuleProvider.DeployOnSaveSupport {
        private final List<ArtifactListener> listeners = new ArrayList<ArtifactListener>();

        public synchronized void addArtifactListener(ArtifactListener listener) {
            ProjectEar.this.copyOnSaveSupport.addArtifactListener(listener);
            boolean register = this.listeners.isEmpty();
            if (listener != null) {
                this.listeners.add(listener);
            }
            if (register) {
                for (J2eeModuleProvider provider : ProjectEar.this.getChildModuleProviders()) {
                    J2eeModuleProvider.DeployOnSaveSupport support = provider.getDeployOnSaveSupport();
                    if (support == null) continue;
                    support.addArtifactListener((ArtifactListener)this);
                }
            }
        }

        public synchronized void removeArtifactListener(ArtifactListener listener) {
            ProjectEar.this.copyOnSaveSupport.removeArtifactListener(listener);
            if (listener != null) {
                this.listeners.remove(listener);
            }
            if (this.listeners.isEmpty()) {
                for (J2eeModuleProvider provider : ProjectEar.this.getChildModuleProviders()) {
                    J2eeModuleProvider.DeployOnSaveSupport support = provider.getDeployOnSaveSupport();
                    if (support == null) continue;
                    support.removeArtifactListener((ArtifactListener)this);
                }
            }
        }

        public boolean containsIdeArtifacts() {
            for (J2eeModuleProvider provider : ProjectEar.this.getChildModuleProviders()) {
                J2eeModuleProvider.DeployOnSaveSupport support = provider.getDeployOnSaveSupport();
                if (support == null || !support.containsIdeArtifacts()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void artifactsUpdated(Iterable<ArtifactListener.Artifact> artifacts) {
            ArrayList<ArtifactListener.Artifact> recomputed = new ArrayList<ArtifactListener.Artifact>();
            String buildDirName = ProjectEar.this.project.evaluator().getProperty("build.dir");
            if (buildDirName == null) {
                return;
            }
            for (ArtifactListener.Artifact artifact : artifacts) {
                if (artifact.isReferencedLibrary() && artifact.isRelocatable()) {
                    File buildDir = ProjectEar.this.project.getAntProjectHelper().resolveFile(buildDirName);
                    String relocation = artifact.getRelocation();
                    File destFile = null;
                    destFile = relocation != null ? new File(buildDir, relocation + File.separator + artifact.getFile().getName()) : new File(buildDir, artifact.getFile().getName());
                    try {
                        FileUtil.createData((File)destFile);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, "Could not prepare data file", ex);
                        continue;
                    }
                    recomputed.add(artifact.distributionPath(destFile));
                    continue;
                }
                recomputed.add(artifact);
            }
            ArrayList<ArtifactListener> toFire = null;
            DeployOnSaveSupportProxy deployOnSaveSupportProxy = this;
            synchronized (deployOnSaveSupportProxy) {
                toFire = new ArrayList<ArtifactListener>(this.listeners);
            }
            for (ArtifactListener listener : toFire) {
                listener.artifactsUpdated(recomputed);
            }
        }
    }

    public class CopyOnSaveSupport
    extends FileChangeAdapter
    implements PropertyChangeListener,
    J2eeModuleProvider.ConfigSupport.DeployOnSaveListener {
        private File resources = null;
        private final List<ArtifactListener> listeners = new CopyOnWriteArrayList<ArtifactListener>();

        public void addArtifactListener(ArtifactListener listener) {
            this.listeners.add(listener);
        }

        public void removeArtifactListener(ArtifactListener listener) {
            this.listeners.remove(listener);
        }

        private boolean isCopyOnSaveEnabled() {
            return Boolean.parseBoolean(ProjectEar.this.project.evaluator().getProperty("j2ee.compile.on.save"));
        }

        public void initialize() throws FileStateInvalidException {
            ProjectEar.this.project.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
            if (!this.isCopyOnSaveEnabled()) {
                return;
            }
            if (this.resources != null) {
                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)this.resources);
            }
            this.resources = ProjectEar.this.getResourceDirectory();
            if (this.resources != null) {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)this.resources);
            }
            ProjectEar.this.getConfigSupport().addDeployOnSaveListener((J2eeModuleProvider.ConfigSupport.DeployOnSaveListener)this);
        }

        public void cleanup() throws FileStateInvalidException {
            if (this.resources != null) {
                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)this.resources);
                this.resources = null;
            }
            ProjectEar.this.project.evaluator().removePropertyChangeListener((PropertyChangeListener)this);
            ProjectEar.this.getConfigSupport().removeDeployOnSaveListener((J2eeModuleProvider.ConfigSupport.DeployOnSaveListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("resource.dir".equals(evt.getPropertyName()) || "j2ee.compile.on.save".equals(evt.getPropertyName())) {
                try {
                    this.cleanup();
                    this.initialize();
                }
                catch (FileStateInvalidException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
            }
        }

        public void fileChanged(FileEvent fe) {
            this.handleResource(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.handleResource(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.handleResource((FileEvent)fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.handleResource(fe);
        }

        private void fireArtifactChange(Iterable<ArtifactListener.Artifact> files) {
            for (ArtifactListener listener : this.listeners) {
                listener.artifactsUpdated(files);
            }
        }

        private void handleResource(FileEvent fe) {
            if (this.resources == null) {
                return;
            }
            FileObject resourceFo = FileUtil.toFileObject((File)this.resources);
            if (resourceFo != null && (resourceFo.equals(fe.getFile()) || FileUtil.isParentOf((FileObject)resourceFo, (FileObject)fe.getFile()))) {
                this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)FileUtil.toFile((FileObject)fe.getFile())).serverResource()));
            }
        }

        public void deployed(Iterable<ArtifactListener.Artifact> artifacts) {
            if (ProjectEar.this.project.getLookup().lookup(WebBrowserProvider.class) == null || !ProjectEar.this.project.getEaselSupport().canReload()) {
                return;
            }
            for (ArtifactListener.Artifact artifact : artifacts) {
                FileObject fileObject = this.getReloadFileObject(artifact);
                if (fileObject == null) continue;
                ProjectEar.this.project.getEaselSupport().reload(fileObject);
            }
        }

        private FileObject getReloadFileObject(ArtifactListener.Artifact artifact) {
            File file = artifact.getFile();
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            if (fileObject == null) {
                return null;
            }
            try {
                return this.findSourceForBinary(fileObject);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        private FileObject findSourceForBinary(FileObject artifact) throws IOException {
            FileObject contentDir;
            WebModule wm = WebModule.getWebModule((FileObject)artifact);
            if (wm == null) {
                return null;
            }
            J2eeModule mod = ProjectEar.this.getWebModule();
            if (mod != null && (contentDir = mod.getContentDirectory()) != null) {
                FileObject classesDir = contentDir.getFileObject("WEB-INF/classes");
                Project p = FileOwnerQuery.getOwner((FileObject)artifact);
                if (p != null && classesDir != null && FileUtil.isParentOf((FileObject)classesDir, (FileObject)artifact)) {
                    String path = FileUtil.getRelativePath((FileObject)classesDir, (FileObject)artifact).replace(".class", ".java");
                    for (SourceGroup sg : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
                        FileObject fo = sg.getRootFolder().getFileObject(path);
                        if (fo == null) continue;
                        return fo;
                    }
                    return null;
                }
                FileObject docBase = wm.getDocumentBase();
                if (docBase != null && FileUtil.isParentOf((FileObject)contentDir, (FileObject)artifact)) {
                    String path = FileUtil.getRelativePath((FileObject)contentDir, (FileObject)artifact);
                    return docBase.getFileObject(path);
                }
            }
            return null;
        }
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        FileObject f;
        FileObject root;

        FSRootRE(FileObject root, FileObject f) {
            this.f = f;
            this.root = root;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static class IT
    implements Iterator {
        Iterator<FileObject> it;
        FileObject root;

        private IT(ProjectEar pe, FileObject f) {
            J2eeModule[] mods = pe.getModules();
            HashSet<String> filter = new HashSet<String>(mods.length);
            for (int i = 0; i < mods.length; ++i) {
                FileObject modArchive = null;
                try {
                    modArchive = mods[i].getArchive();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.FINER, null, ioe);
                    continue;
                }
                if (modArchive == null) continue;
                String modName = modArchive.getNameExt();
                long modSize = modArchive.getSize();
                filter.add(modName + "." + modSize);
            }
            ArrayList<FileObject> filteredContent = new ArrayList<FileObject>(5);
            Enumeration ch = f.getChildren(true);
            while (ch.hasMoreElements()) {
                FileObject fo = (FileObject)ch.nextElement();
                String fileName = fo.getNameExt();
                long fileSize = fo.getSize();
                if (filter.contains(fileName + "." + fileSize)) continue;
                filteredContent.add(fo);
            }
            this.root = f;
            this.it = filteredContent.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return new FSRootRE(this.root, this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

