/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import java.security.Provider;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BouncyCastleHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BouncyCastleHelper.class);
    private final boolean isProviderInstalled = Security.getProvider("BC") != null || Security.getProvider("BCFIPS") != null;
    private final Provider bouncyCastleProvider;

    private BouncyCastleHelper() {
        try {
            Class<?> bouncyCastleProviderClass = BouncyCastleHelper.getBouncyCastleProviderClass();
            this.bouncyCastleProvider = (Provider)bouncyCastleProviderClass.newInstance();
            LOG.info("Instantiated provider: " + bouncyCastleProviderClass.getName());
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOG.error("Failed to instantiate any BouncyCastle provider", (Throwable)ex);
            throw new BouncyCastleHelperException(ex);
        }
    }

    static BouncyCastleHelper getInstance() {
        return Holder.INSTANCE;
    }

    boolean isProviderInstalled() {
        return this.isProviderInstalled;
    }

    Provider getBouncyCastleProvider() {
        return this.bouncyCastleProvider;
    }

    private static Class<?> getBouncyCastleProviderClass() {
        LOG.debug("Trying to get BouncyCastleProvider");
        try {
            return Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
        }
        catch (ClassNotFoundException e) {
            LOG.info("Did not find BouncyCastleProvider");
            LOG.debug("Trying to get BouncyCastleFipsProvider");
            try {
                return Class.forName("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
            }
            catch (ClassNotFoundException e2) {
                LOG.info("Did not find BouncyCastleFipsProvider");
                throw new IllegalStateException("No matching BouncyCastle provider found.");
            }
        }
    }

    public static class BouncyCastleHelperException
    extends RuntimeException {
        public BouncyCastleHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public BouncyCastleHelperException(Throwable cause) {
            super(cause);
        }
    }

    private static class Holder {
        private static final BouncyCastleHelper INSTANCE = new BouncyCastleHelper();

        private Holder() {
        }
    }
}

