/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gradle.GradleModuleFileCache21;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleConfiguration;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.loaders.GradleArtifactStore;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.ProjectInfoExtractor;

class GradleBaseProjectBuilder
implements ProjectInfoExtractor.Result {
    static final Map<String, List<String>> DEPENDENCY_TO_PLUGIN = new LinkedHashMap<String, List<String>>();
    static final Logger LOG = Logger.getLogger(GradleBaseProjectBuilder.class.getName());
    final Map<String, Object> info;
    final GradleBaseProject prj = new GradleBaseProject();
    final Set<String> problems = new LinkedHashSet<String>();
    final GradleArtifactStore artifactSore = GradleArtifactStore.getDefault();
    private static final String DEPENDENCY_PROJECT_PREFIX = "*project;";

    private static void addDependencyPlugin(String dependency, String ... plugins) {
        DEPENDENCY_TO_PLUGIN.put(dependency, Arrays.asList(plugins));
    }

    GradleBaseProjectBuilder(Map<String, Object> info) {
        this.info = new TreeMap<String, Object>(info);
    }

    void build() {
        if (LOG.isLoggable(Level.FINE)) {
            for (Map.Entry<String, Object> entry : this.info.entrySet()) {
                LOG.log(Level.FINE, entry.getKey() + " = " + String.valueOf(entry.getValue()));
            }
        }
        this.processBasicInfo();
        this.processTasks();
        this.processDependencies();
        this.processDependencyPlugins();
    }

    void processBasicInfo() {
        this.prj.name = (String)this.info.get("project_name");
        this.prj.path = (String)this.info.get("project_path");
        this.prj.status = (String)this.info.get("project_status");
        this.prj.parentName = (String)this.info.get("project_parent_name");
        this.prj.displayName = (String)this.info.get("project_display_name");
        this.prj.description = (String)this.info.get("project_description");
        this.prj.group = (String)this.info.get("project_group");
        this.prj.buildDir = (File)this.info.get("project_buildDir");
        this.prj.projectDir = (File)this.info.get("project_projectDir");
        this.prj.rootDir = (File)this.info.get("project_rootDir");
        this.prj.version = (String)this.info.get("project_version");
        this.prj.license = (String)this.info.get("license");
        this.prj.plugins = new TreeSet(this.createSet((Set)this.info.get("plugins")));
        Map rawSubprojects = (Map)this.info.get("project_subProjects");
        Map refinedSubprojects = (Map)this.info.get("project_subProjects");
        for (Map.Entry entry : rawSubprojects.entrySet()) {
            refinedSubprojects.put((String)entry.getKey(), ((File)entry.getValue()).isAbsolute() ? (File)entry.getValue() : new File(this.prj.rootDir, ((File)entry.getValue()).toString()));
        }
        this.prj.subProjects = Collections.unmodifiableMap(refinedSubprojects);
        this.prj.includedBuilds = (Map)this.info.get("project_includedBuilds");
        if (this.info.containsKey("buildClassPath")) {
            this.prj.buildClassPath = (Set)this.info.get("buildClassPath");
        }
        if (this.info.containsKey("nbprops")) {
            HashMap props = new HashMap((Map)this.info.get("nbprops"));
            this.prj.netBeansProperties = Collections.unmodifiableMap(props);
        }
    }

    void processTasks() {
        Set tasks = (Set)this.info.get("tasks");
        if (tasks != null) {
            for (String[] arr : tasks) {
                GradleTask task = new GradleTask(arr[0], arr[1], arr[2], arr[3]);
                this.prj.tasksByName.put(task.getName(), task);
                List<GradleTask> group = this.prj.tasksByGroup.get(task.getGroup());
                if (group == null) {
                    group = new ArrayList<GradleTask>();
                    this.prj.tasksByGroup.put(task.getGroup(), group);
                }
                group.add(task);
            }
        }
        Map taskInfos = this.info.getOrDefault("taskDetails", Collections.emptyMap());
        for (String tn : this.prj.getTaskNames()) {
            Map tinfo = (Map)taskInfos.get(tn);
            if (tinfo == null) continue;
            this.prj.taskDependencies.put(tn, Arrays.asList(tinfo.getOrDefault("taskDependencies", "").split(",")));
            LinkedHashSet<String> inherited = new LinkedHashSet<String>(Arrays.asList(tinfo.getOrDefault("inherits", "").split(",")));
            this.prj.taskTypes.put(tn, inherited);
        }
    }

    /*
     * WARNING - void declaration
     */
    void processDependencies() {
        Map unresolvedProblems;
        Map javadocs;
        Map sources;
        File gradleUserHome = (File)this.info.get("gradle_user_home");
        gradleUserHome = gradleUserHome != null ? gradleUserHome : GradleSettings.getDefault().getGradleUserHome();
        HashSet<File> sourceSetOutputs = new HashSet<File>();
        Set sourceSetNames = (Set)this.info.get("sourcesets");
        if (sourceSetNames != null) {
            for (String name : sourceSetNames) {
                Set dirs = (Set)this.info.get("sourceset_" + name + "_output_classes");
                sourceSetOutputs.addAll(dirs);
                sourceSetOutputs.add((File)this.info.get("sourceset_" + name + "_output_resources"));
            }
        }
        this.prj.outputPaths = this.createSet(sourceSetOutputs);
        Set configurationNames = this.createSet((Set)this.info.get("configurations"));
        Map prjs = (Map)this.info.get("project_dependencies");
        prjs = prjs != null ? prjs : Collections.emptyMap();
        Map arts = (Map)this.info.get("resolved_jvm_artifacts");
        Map map = arts = arts != null ? arts : Collections.emptyMap();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Resolved JVM artifacts: {0}", arts.toString().replace(",", "\n\t"));
        }
        Map map2 = sources = (sources = (Map)this.info.get("resolved_sources_artifacts")) != null ? sources : Collections.emptyMap();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Resolved source artifacts: {0}", sources.toString().replace(",", "\n\t"));
        }
        Map map3 = javadocs = (javadocs = (Map)this.info.get("resolved_javadoc_artifacts")) != null ? javadocs : Collections.emptyMap();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Resolved javadoc artifacts: {0}", javadocs.toString().replace(",", "\n\t"));
        }
        unresolvedProblems = (unresolvedProblems = (Map)this.info.get("unresolved_problems")) != null ? unresolvedProblems : Collections.emptyMap();
        HashMap<Object, Object> components = new HashMap<Object, Object>();
        GradleArtifactStore store = GradleArtifactStore.getDefault();
        for (Map.Entry entry : arts.entrySet()) {
            void var15_21;
            String string = (String)entry.getKey();
            LOG.log(Level.FINER, "Resolving JVM artifact {0}", string);
            GradleDependency.ModuleDependency moduleDependency = this.resolveModuleDependency(gradleUserHome, string);
            if (!moduleDependency.getArtifacts().equals(entry.getValue())) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Created component {0} from JVM artifacts: {1}", new Object[]{string, entry.getValue()});
                }
                GradleDependency.ModuleDependency moduleDependency2 = new GradleDependency.ModuleDependency(string, (Set)entry.getValue());
            }
            components.put(string, var15_21);
            if (LOG.isLoggable(Level.FINER) && var15_21.sources != null && !var15_21.sources.isEmpty()) {
                LOG.log(Level.FINER, "Replacing sources for {0} sources from {1}, used to be {2}", new Object[]{string, sources.containsKey(string) ? "resolvedSources" : "artifactStore", var15_21.sources});
            }
            var15_21.sources = sources.containsKey(string) ? (Set<Object>)sources.get(entry.getKey()) : store.getSources((Set)entry.getValue());
            if (LOG.isLoggable(Level.FINER) && var15_21.javadoc != null && !var15_21.javadoc.isEmpty()) {
                LOG.log(Level.FINER, "Replacing javadocs for {0} from {1}, used to be {2}", new Object[]{string, javadocs.containsKey(string) ? "resolvedJavadocs" : "artifactStore", var15_21.javadoc});
            }
            var15_21.javadoc = javadocs.containsKey(string) ? (Set<Object>)javadocs.get(entry.getKey()) : store.getJavadocs((Set)entry.getValue());
            if (!LOG.isLoggable(Level.FINER)) continue;
            LOG.log(Level.FINER, "Done component: {0} -> {1}", new Object[]{string, var15_21});
        }
        HashMap<String, GradleDependency.ProjectDependency> projects = new HashMap<String, GradleDependency.ProjectDependency>();
        for (Map.Entry entry : prjs.entrySet()) {
            GradleDependency.ProjectDependency projectDependency = new GradleDependency.ProjectDependency((String)entry.getKey(), (File)entry.getValue());
            projects.put((String)entry.getKey(), projectDependency);
            if (!LOG.isLoggable(Level.FINER)) continue;
            LOG.log(Level.FINER, "Added project dependency: {0} -> {1} ", new Object[]{entry.getKey(), projectDependency});
        }
        HashMap<String, GradleDependency.UnresolvedDependency> hashMap = new HashMap<String, GradleDependency.UnresolvedDependency>();
        for (Map.Entry entry : unresolvedProblems.entrySet()) {
            GradleDependency.UnresolvedDependency dep2 = new GradleDependency.UnresolvedDependency((String)entry.getKey());
            dep2.problem = (String)entry.getValue();
            hashMap.put((String)entry.getKey(), dep2);
            if (!LOG.isLoggable(Level.FINER)) continue;
            LOG.log(Level.FINER, "Adding UNRESOLVED dependency: {0} -> {1}", new Object[]{entry.getKey(), dep2});
        }
        GradleDependency.ProjectDependency projectDependency = new GradleDependency.ProjectDependency(this.prj.getPath(), this.prj.getProjectDir());
        this.prj.projectDependencyNode = projectDependency;
        if (configurationNames != null) {
            GradleConfiguration conf;
            for (String name : configurationNames) {
                HashSet files;
                conf = this.prj.createConfiguration(name);
                conf.modules = new HashSet<GradleDependency.ModuleDependency>();
                Boolean nonResolvingConf = (Boolean)this.info.get("configuration_" + name + "_non_resolving");
                conf.canBeResolved = nonResolvingConf != null ? !nonResolvingConf.booleanValue() : true;
                Set requiredComponents = (Set)this.info.get("configuration_" + name + "_components");
                if (requiredComponents != null) {
                    for (Object c : requiredComponents) {
                        GradleDependency.ModuleDependency dep3 = (GradleDependency.ModuleDependency)components.get(c);
                        if (dep3 != null) {
                            LOG.log(Level.FINER, "Configuration {0}, known component {1}", new Object[]{conf.getName(), dep3});
                            conf.modules.add(dep3);
                            continue;
                        }
                        dep3 = this.resolveModuleDependency(gradleUserHome, (String)c);
                        LOG.log(Level.FINER, "Configuration {0}, resolved to {1}", new Object[]{conf.getName(), dep3});
                        if (dep3 == null) continue;
                        components.put(c, dep3);
                        conf.modules.add(dep3);
                    }
                }
                conf.projects = new HashSet<GradleDependency.ProjectDependency>();
                Set requiredProjects = (Set)this.info.get("configuration_" + name + "_projects");
                if (requiredProjects != null) {
                    Object c;
                    c = requiredProjects.iterator();
                    while (c.hasNext()) {
                        String p = (String)c.next();
                        conf.projects.add((GradleDependency.ProjectDependency)projects.get(p));
                    }
                }
                HashMap<String, GradleDependency.UnresolvedDependency> unresolved2 = new HashMap<String, GradleDependency.UnresolvedDependency>(hashMap);
                conf.unresolved = new HashSet<GradleDependency.UnresolvedDependency>();
                Set unresolvedComp = (Set)this.info.get("configuration_" + name + "_unresolved");
                if (unresolvedComp != null) {
                    for (String u : unresolvedComp) {
                        GradleDependency.UnresolvedDependency dep4 = (GradleDependency.UnresolvedDependency)unresolved2.get(u);
                        if (dep4 == null) {
                            dep4 = new GradleDependency.UnresolvedDependency(u);
                            unresolved2.put(u, dep4);
                        }
                        conf.unresolved.add(dep4);
                    }
                }
                if ((files = (HashSet)this.info.get("configuration_" + name + "_files")) != null) {
                    files = new HashSet(files);
                    files.removeAll(sourceSetOutputs);
                }
                conf.files = new GradleDependency.FileCollectionDependency(this.createSet(files));
                Boolean transitive = (Boolean)this.info.get("configuration_" + name + "_transitive");
                conf.transitive = transitive == null ? true : transitive;
                Boolean canBeConsumed = (Boolean)this.info.get("configuration_" + name + "_canBeConsumed");
                conf.canBeConsumed = canBeConsumed == null ? false : canBeConsumed;
                conf.attributes = (Map)this.info.get("configuration_" + name + "_attributes");
                conf.description = (String)this.info.get("configuration_" + name + "_description");
                Map directDependencies = (Map)this.info.get("configuration_" + name + "_dependencies");
                Set<String> childSpecs = (Set<String>)this.info.get("configuration_" + name + "_directChildren");
                if (childSpecs == null) {
                    childSpecs = Collections.emptySet();
                }
                if (directDependencies == null) {
                    directDependencies = Collections.emptyMap();
                }
                HashMap<GradleDependency, Collection<GradleDependency>> deps = new HashMap<GradleDependency, Collection<GradleDependency>>();
                LinkedHashSet<GradleDependency> children = new LinkedHashSet<GradleDependency>();
                for (String parentId : directDependencies.keySet()) {
                    GradleDependency parentD;
                    if (parentId.equals("")) {
                        parentD = GradleConfiguration.SELF_DEPENDENCY;
                    } else if (parentId.startsWith(DEPENDENCY_PROJECT_PREFIX)) {
                        int sep1 = parentId.indexOf(58, DEPENDENCY_PROJECT_PREFIX.length());
                        parentD = (GradleDependency)projects.get(parentId.substring(DEPENDENCY_PROJECT_PREFIX.length(), sep1));
                    } else {
                        parentD = (GradleDependency)components.get(parentId);
                        if (parentD == null) {
                            parentD = (GradleDependency)hashMap.get(parentId);
                        }
                    }
                    if (parentD == null) continue;
                    if (childSpecs.remove(parentId)) {
                        children.add(parentD);
                    }
                    for (String cid : (Collection)directDependencies.get(parentId)) {
                        GradleDependency childD;
                        if (cid.startsWith(DEPENDENCY_PROJECT_PREFIX)) {
                            int sep1 = cid.indexOf(58, DEPENDENCY_PROJECT_PREFIX.length());
                            childD = (GradleDependency)projects.get(cid.substring(DEPENDENCY_PROJECT_PREFIX.length(), sep1));
                        } else {
                            childD = (GradleDependency)components.get(cid);
                            if (childD == null) {
                                childD = (GradleDependency)hashMap.get(cid);
                            }
                        }
                        if (childD == null) continue;
                        deps.computeIfAbsent(parentD, x -> new ArrayList()).add(childD);
                    }
                }
                for (String s : childSpecs) {
                    GradleDependency ud = (GradleDependency)unresolved2.get(s);
                    if (ud == null) continue;
                    children.add(ud);
                }
                conf.directChildren = children;
                conf.dependencyMap = deps;
            }
            for (String name : configurationNames) {
                conf = this.prj.configurations.get(name);
                Set extendsFrom = (Set)this.info.get("configuration_" + name + "_extendsFrom");
                HashSet<GradleConfiguration> parents = new HashSet<GradleConfiguration>();
                if (extendsFrom != null) {
                    for (String n : extendsFrom) {
                        parents.add(this.prj.configurations.get(n));
                    }
                }
                conf.extendsFrom = this.createSet(parents);
            }
        }
        this.prj.projectIds = this.info.getOrDefault("project_ids", Collections.emptyMap());
        for (GradleDependency.ModuleDependency dep : components.values()) {
            for (File f : dep.getArtifacts()) {
                this.prj.componentsByFile.put(f, dep);
            }
            for (File f : dep.getSources()) {
                this.prj.componentsByFile.put(f, dep);
            }
            for (File f : dep.getJavadoc()) {
                this.prj.componentsByFile.put(f, dep);
            }
        }
        this.problems.addAll(unresolvedProblems.values());
    }

    private GradleDependency.ModuleDependency resolveModuleDependency(File gradleUserHome, String c) {
        GradleModuleFileCache21 moduleCache = GradleModuleFileCache21.getGradleFileCache(gradleUserHome.toPath());
        try {
            GradleModuleFileCache21.CachedArtifactVersion artVersion = moduleCache.resolveModule(c);
            Set<File> binaries = this.artifactSore.getBinaries(c);
            if ((binaries == null || binaries.isEmpty()) && artVersion.getBinary() != null) {
                LOG.log(Level.FINER, "Resolving component {0} from module21: {0}", artVersion.getBinary());
                binaries = Collections.singleton(artVersion.getBinary().getPath().toFile());
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Resolving component {0} from artifactstore: {0}", new Object[]{c, binaries});
            }
            GradleDependency.ModuleDependency ret = new GradleDependency.ModuleDependency(c, binaries);
            if (artVersion.getSources() != null) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Resolving sources {0} from module21: {0}", new Object[]{c, artVersion.getSources().getPath()});
                }
                ret.sources = Collections.singleton(artVersion.getSources().getPath().toFile());
            }
            if (artVersion.getJavaDoc() != null) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Resolving javadoc {0} from module21: {0}", new Object[]{c, artVersion.getJavaDoc().getPath()});
                }
                ret.javadoc = Collections.singleton(artVersion.getJavaDoc().getPath().toFile());
            }
            return ret;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private void processDependencyPlugins() {
        GradleConfiguration compile = this.prj.configurations.get("compile");
        if (compile != null) {
            Set<GradleConfiguration> parents = compile.getAllParents();
            for (GradleConfiguration config : parents) {
                for (String dependency : DEPENDENCY_TO_PLUGIN.keySet()) {
                    if (config.findModules(dependency).isEmpty()) continue;
                    this.prj.plugins.addAll((Collection<String>)DEPENDENCY_TO_PLUGIN.get(dependency));
                }
            }
        }
    }

    private <T> Set<T> createSet(Set<T> origin) {
        if (origin == null) {
            return Collections.emptySet();
        }
        switch (origin.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(origin.iterator().next());
            }
        }
        return Collections.unmodifiableSet(origin);
    }

    @Override
    public Set getExtract() {
        return Collections.singleton(this.prj);
    }

    @Override
    public Set<String> getProblems() {
        return Collections.unmodifiableSet(this.problems);
    }

    static {
        GradleBaseProjectBuilder.addDependencyPlugin("javax:javaee-api:.*", "ejb", "jpa");
        GradleBaseProjectBuilder.addDependencyPlugin("javax:javaee-web-api:.*", "ejb", "jpa");
        GradleBaseProjectBuilder.addDependencyPlugin("javaee:javaee-api:.*", "ejb");
        GradleBaseProjectBuilder.addDependencyPlugin("org.hibernate.javax.persistence:hibernate-jpa-2.0-api:.*", "jpa");
        GradleBaseProjectBuilder.addDependencyPlugin("org.hibernate.javax.persistence:hibernate-jpa-2.1-api:.*", "jpa");
        GradleBaseProjectBuilder.addDependencyPlugin("org.eclipse.persistence:javax.persistence:.*", "jpa");
    }

    public static final class Extractor
    implements ProjectInfoExtractor {
        @Override
        public ProjectInfoExtractor.Result extract(Map<String, Object> props, Map<Class, Object> otherInfo) {
            GradleBaseProjectBuilder result = new GradleBaseProjectBuilder(props);
            result.build();
            return result;
        }

        @Override
        public ProjectInfoExtractor.Result fallback(GradleFiles files) {
            return new ProjectInfoExtractor.DefaultResult((Object)GradleBaseProject.getFallback(files), new String[0]);
        }
    }
}

