/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websocket.editor;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Position;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebSocketMethodsTask
implements CancellableTask<CompilationInfo> {
    private static final String ON_ERROR_ANNOTATION = "javax.websocket.OnError";
    private final AtomicReference<WebSocketTask> runTask = new AtomicReference();

    public void run(CompilationInfo compilationInfo) throws Exception {
        FileObject fileObject = compilationInfo.getFileObject();
        if (!this.isApplicable(fileObject)) {
            return;
        }
        WebSocketTask task = new WebSocketTask(compilationInfo);
        this.runTask.set(task);
        task.run();
        this.runTask.compareAndSet(task, null);
        HintsController.setErrors((FileObject)fileObject, (String)"WebSocket Methods Scanner", task.getDescriptions());
    }

    public void cancel() {
        WebSocketTask scanTask = this.runTask.getAndSet(null);
        if (scanTask != null) {
            scanTask.stop();
        }
    }

    private boolean isApplicable(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return Profile.JAVA_EE_7_WEB.equals(profile) || Profile.JAVA_EE_7_FULL.equals(profile) || Profile.JAVA_EE_8_WEB.equals(profile) || Profile.JAVA_EE_8_FULL.equals(profile) || Profile.JAKARTA_EE_8_FULL.equals(profile) || Profile.JAKARTA_EE_9_FULL.equals(profile) || Profile.JAKARTA_EE_9_1_FULL.equals(profile);
    }

    private boolean hasAnnotation(Element element, String ... annotationFqns) {
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (!(annotationElement instanceof TypeElement)) continue;
            String fqn = ((TypeElement)annotationElement).getQualifiedName().toString();
            for (String annotationFqn : annotationFqns) {
                if (!fqn.equals(annotationFqn)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, String> suggestWebSocketMethod() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("javax.websocket.OnMessage", "onMessage");
        result.put("javax.websocket.OnOpen", "onOpen");
        result.put("javax.websocket.OnClose", "onClose");
        result.put(ON_ERROR_ANNOTATION, "onError");
        return result;
    }

    private Collection<String> getAnnotationsFqn(Element element) {
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        HashSet<String> result = new HashSet<String>();
        for (AnnotationMirror annotationMirror : annotations) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (!(annotationElement instanceof TypeElement)) continue;
            String fqn = ((TypeElement)annotationElement).getQualifiedName().toString();
            result.add(fqn);
        }
        return result;
    }

    private List<Integer> getElementPosition(CompilationInfo info, Tree tree) {
        SourcePositions srcPos = info.getTrees().getSourcePositions();
        int startOffset = (int)srcPos.getStartPosition(info.getCompilationUnit(), tree);
        int endOffset = (int)srcPos.getEndPosition(info.getCompilationUnit(), tree);
        Tree startTree = null;
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
            startTree = ((ClassTree)tree).getModifiers();
        } else if (tree.getKind() == Tree.Kind.METHOD) {
            startTree = ((MethodTree)tree).getReturnType();
        } else if (tree.getKind() == Tree.Kind.VARIABLE) {
            startTree = ((VariableTree)tree).getType();
        }
        if (startTree != null) {
            int searchStart = (int)srcPos.getEndPosition(info.getCompilationUnit(), startTree);
            TokenSequence tokenSequence = info.getTreeUtilities().tokensFor(tree);
            if (tokenSequence != null) {
                boolean eob = false;
                tokenSequence.move(searchStart);
                do {
                    boolean bl = eob = !tokenSequence.moveNext();
                } while (!eob && tokenSequence.token().id() != JavaTokenId.IDENTIFIER);
                if (!eob) {
                    Token identifier = tokenSequence.token();
                    startOffset = identifier.offset(info.getTokenHierarchy());
                    endOffset = startOffset + identifier.length();
                }
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>(2);
        result.add(startOffset);
        result.add(endOffset);
        return result;
    }

    private class AddMethod
    implements Fix {
        private final FileObject myFileObject;
        private final ElementHandle<TypeElement> myHandle;
        private final String myAnnotation;
        private final String myMethodName;
        private final Set<String> myExistedMethods;

        AddMethod(FileObject fileObject, ElementHandle<TypeElement> endpointClass, String annotation, String methodName, Set<String> existedMethodNames) {
            this.myFileObject = fileObject;
            this.myHandle = endpointClass;
            this.myAnnotation = annotation;
            this.myMethodName = methodName;
            this.myExistedMethods = existedMethodNames;
        }

        public ChangeInfo implement() throws Exception {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.myFileObject);
            if (javaSource == null) {
                return null;
            }
            ModificationResult modificationTask = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement clazz = (TypeElement)AddMethod.this.myHandle.resolve((CompilationInfo)copy);
                    TreeMaker maker = copy.getTreeMaker();
                    ClassTree classTree = copy.getTrees().getTree(clazz);
                    AnnotationTree annotation = maker.Annotation((Tree)maker.QualIdent(AddMethod.this.myAnnotation), Collections.emptyList());
                    ModifiersTree modifiers = maker.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.singletonList(annotation));
                    VariableTree par1 = null;
                    if (WebSocketMethodsTask.ON_ERROR_ANNOTATION.equals(AddMethod.this.myAnnotation)) {
                        ModifiersTree parMods = maker.Modifiers(Collections.emptySet(), Collections.emptyList());
                        par1 = maker.Variable(parMods, (CharSequence)"t", (Tree)maker.QualIdent("java.lang.Throwable"), null);
                    }
                    MethodTree method = maker.Method(modifiers, (CharSequence)AddMethod.this.getMethodName(), maker.Type("void"), Collections.emptyList(), par1 != null ? Collections.singletonList(par1) : Collections.emptyList(), Collections.emptyList(), "{}", null);
                    ClassTree newTree = maker.addClassMember(classTree, (Tree)method);
                    copy.rewrite((Tree)classTree, (Tree)newTree);
                }
            });
            List differences = modificationTask.getDifferences(this.myFileObject);
            ChangeInfo changeInfo = new ChangeInfo();
            for (ModificationResult.Difference difference : differences) {
                Position start = difference.getStartPosition();
                Position end = difference.getEndPosition();
                changeInfo.add(this.myFileObject, start, end);
            }
            modificationTask.commit();
            return changeInfo;
        }

        public String getText() {
            return NbBundle.getMessage(WebSocketMethodsTask.class, (String)"TXT_AddWebScoketMethod", (Object)this.getDisplayName());
        }

        private String getMethodName() {
            return this.getMethodName(this.myMethodName, 0);
        }

        private String getMethodName(String name, int i) {
            String suggestName = name;
            suggestName = i == 0 ? name : name + i;
            if (this.myExistedMethods.contains(suggestName)) {
                return this.getMethodName(name, i + 1);
            }
            return suggestName;
        }

        private String getDisplayName() {
            int index = this.myAnnotation.lastIndexOf(46);
            return "@" + this.myAnnotation.substring(index + 1);
        }
    }

    private class WebSocketTask {
        private final Collection<ErrorDescription> descriptions;
        private volatile boolean stop;
        private final CompilationInfo myInfo;

        private WebSocketTask(CompilationInfo info) {
            this.myInfo = info;
            this.descriptions = new LinkedList<ErrorDescription>();
        }

        void run() {
            List classes = this.myInfo.getTopLevelElements();
            for (TypeElement clazz : classes) {
                if (this.stop) {
                    return;
                }
                List<ExecutableElement> methods = ElementFilter.methodsIn(clazz.getEnclosedElements());
                if (!this.isEndpoint(clazz)) continue;
                Map webSocketMethod = WebSocketMethodsTask.this.suggestWebSocketMethod();
                Set wsAnnotations = webSocketMethod.keySet();
                HashSet<String> existedMethods = new HashSet<String>();
                for (ExecutableElement executableElement : methods) {
                    if (this.stop) {
                        return;
                    }
                    wsAnnotations.removeAll(WebSocketMethodsTask.this.getAnnotationsFqn(executableElement));
                    existedMethods.add(executableElement.getSimpleName().toString());
                }
                LinkedList<AddMethod> fixes = new LinkedList<AddMethod>();
                for (Map.Entry entry : webSocketMethod.entrySet()) {
                    AddMethod fix = new AddMethod(this.myInfo.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)clazz), (String)entry.getKey(), (String)entry.getValue(), existedMethods);
                    fixes.add(fix);
                }
                if (fixes.isEmpty()) continue;
                ClassTree classTree = this.myInfo.getTrees().getTree(clazz);
                List positions = WebSocketMethodsTask.this.getElementPosition(this.myInfo, classTree);
                ErrorDescription description = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)NbBundle.getMessage(WebSocketMethodsTask.class, (String)"TXT_AddWebSocketMethods"), fixes, (FileObject)this.myInfo.getFileObject(), (int)((Integer)positions.get(0)), (int)((Integer)positions.get(1)));
                this.getDescriptions().add(description);
            }
        }

        private boolean isEndpoint(TypeElement clazz) {
            return WebSocketMethodsTask.this.hasAnnotation(clazz, new String[]{"javax.websocket.server.ServerEndpoint"});
        }

        Collection<ErrorDescription> getDescriptions() {
            return this.descriptions;
        }

        void stop() {
            this.stop = true;
        }
    }
}

