/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.ExadataInfrastructure;
import com.oracle.bmc.database.requests.ActivateExadataInfrastructureRequest;
import com.oracle.bmc.database.responses.ActivateExadataInfrastructureResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateExadataInfrastructureConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ActivateExadataInfrastructureConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ActivateExadataInfrastructureRequest interceptRequest(ActivateExadataInfrastructureRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ActivateExadataInfrastructureRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getExadataInfrastructureId(), (String)"exadataInfrastructureId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getActivateExadataInfrastructureDetails(), (String)"activateExadataInfrastructureDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("exadataInfrastructures").path(HttpUtils.encodePathSegment((String)request.getExadataInfrastructureId())).path("actions").path("activate");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ActivateExadataInfrastructureResponse> fromResponse() {
        Function<Response, ActivateExadataInfrastructureResponse> transformer = new Function<Response, ActivateExadataInfrastructureResponse>(){

            public ActivateExadataInfrastructureResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.ActivateExadataInfrastructureResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ExadataInfrastructure.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ActivateExadataInfrastructureResponse.Builder builder = ActivateExadataInfrastructureResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.exadataInfrastructure((ExadataInfrastructure)response.getItem());
                Optional opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id");
                if (opcWorkRequestIdHeader.isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ActivateExadataInfrastructureResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

