/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.support.FixFactory;

public class AbstractMethodCannotHaveBody
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.abstract.meth.cant.have.body"));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (treePath.getLeaf().getKind() != Tree.Kind.METHOD) {
            return null;
        }
        MethodTree mt = (MethodTree)treePath.getLeaf();
        Fix removeAbstractFix = FixFactory.removeModifiersFix((CompilationInfo)compilationInfo, (TreePath)new TreePath(treePath, mt.getModifiers()), EnumSet.of(Modifier.ABSTRACT), (String)Bundle.FIX_AbstractMethodCannotHaveBodyRemoveAbstract());
        Fix removeBodyFix = new RemoveBodyFix(compilationInfo, treePath).toEditorFix();
        return Arrays.asList(removeAbstractFix, removeBodyFix);
    }

    public void cancel() {
    }

    public String getId() {
        return AbstractMethodCannotHaveBody.class.getName();
    }

    public String getDisplayName() {
        return Bundle.DN_AbstractMethodCannotHaveBody();
    }

    public String getDescription() {
        return Bundle.DESC_AbstractMethodCannotHaveBody();
    }

    private static final class RemoveBodyFix
    extends JavaFix {
        public RemoveBodyFix(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_AbstractMethodCannotHaveBodyRemoveBody();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            MethodTree mt = (MethodTree)ctx.getPath().getLeaf();
            MethodTree nue = ctx.getWorkingCopy().getTreeMaker().Method(mt.getModifiers(), (CharSequence)mt.getName(), mt.getReturnType(), mt.getTypeParameters(), mt.getParameters(), mt.getThrows(), (BlockTree)null, (ExpressionTree)mt.getDefaultValue());
            ctx.getWorkingCopy().rewrite((Tree)mt, (Tree)nue);
        }
    }
}

