/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.project.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.javaee.specs.support.api.JpaProvider;
import org.netbeans.modules.javaee.specs.support.api.JpaSupport;

public final class PersistenceProviderSupplierImpl
implements PersistenceProviderSupplier {
    private final Project project;

    public PersistenceProviderSupplierImpl(Project project) {
        this.project = project;
    }

    public List<Provider> getSupportedProviders() {
        try {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            String serverInstanceId = j2eeModuleProvider.getServerInstanceID();
            ServerInstance si = serverInstanceId != null ? Deployment.getDefault().getServerInstance(serverInstanceId) : null;
            J2eePlatform platform = null;
            if (si != null) {
                platform = si.getJ2eePlatform();
            }
            return this.findPersistenceProviders(platform);
        }
        catch (InstanceRemovedException ex) {
            return this.findPersistenceProviders(null);
        }
    }

    private List<Provider> findPersistenceProviders(J2eePlatform platform) {
        ArrayList<Provider> providers = new ArrayList<Provider>();
        boolean lessEE7 = true;
        if (platform != null) {
            Map<String, JpaProvider> jpaProviderMap = this.createProviderMap(platform);
            boolean defaultFound = false;
            lessEE7 = !platform.getSupportedProfiles().contains(Profile.JAKARTA_EE_9_1_WEB) && !platform.getSupportedProfiles().contains(Profile.JAKARTA_EE_9_1_FULL) && !platform.getSupportedProfiles().contains(Profile.JAKARTA_EE_9_WEB) && !platform.getSupportedProfiles().contains(Profile.JAKARTA_EE_9_FULL) && !platform.getSupportedProfiles().contains(Profile.JAKARTA_EE_8_WEB) && !platform.getSupportedProfiles().contains(Profile.JAKARTA_EE_8_FULL) && !platform.getSupportedProfiles().contains(Profile.JAVA_EE_8_WEB) && !platform.getSupportedProfiles().contains(Profile.JAVA_EE_8_FULL) && !platform.getSupportedProfiles().contains(Profile.JAVA_EE_7_WEB) && !platform.getSupportedProfiles().contains(Profile.JAVA_EE_7_FULL);
            for (Provider provider : ProviderUtil.getAllProviders()) {
                String version;
                JpaProvider jpa = jpaProviderMap.get(provider.getProviderClass());
                if (jpa == null || !((version = ProviderUtil.getVersion((Provider)provider)) == null || version.equals("2.1") && jpa.isJpa21Supported() || version.equals("2.0") && jpa.isJpa2Supported() && lessEE7) && (!version.equals("1.0") || !jpa.isJpa1Supported() || !lessEE7)) continue;
                if (jpa.isDefault() && !defaultFound) {
                    providers.add(0, provider);
                    defaultFound = true;
                    continue;
                }
                providers.add(provider);
            }
        }
        for (Provider each : PersistenceLibrarySupport.getProvidersFromLibraries()) {
            boolean found = false;
            for (int i = 0; i < providers.size(); ++i) {
                Object elem = providers.get(i);
                if (!(elem instanceof Provider) || !each.equals(elem)) continue;
                found = true;
                break;
            }
            if (found) continue;
            String version = ProviderUtil.getVersion((Provider)each);
            if (!lessEE7 && version != null && !version.equals("2.1")) continue;
            providers.add(each);
        }
        return providers;
    }

    private Map<String, JpaProvider> createProviderMap(J2eePlatform platform) {
        JpaSupport jpaSupport = JpaSupport.getInstance((J2eePlatform)platform);
        HashMap<String, JpaProvider> providerMap = new HashMap<String, JpaProvider>();
        for (JpaProvider provider : jpaSupport.getProviders()) {
            providerMap.put(provider.getClassName(), provider);
        }
        JpaProvider defaultProvider = jpaSupport.getDefaultProvider();
        if (defaultProvider != null) {
            providerMap.put(defaultProvider.getClassName(), defaultProvider);
        }
        return providerMap;
    }

    public boolean supportsDefaultProvider() {
        J2eeProjectCapabilities capabilities = J2eeProjectCapabilities.forProject((Project)this.project);
        if (capabilities != null) {
            return capabilities.hasDefaultPersistenceProvider();
        }
        return false;
    }
}

