/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.Collection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTable;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.TableNode;

public class JoinTableNode
implements JoinTable {
    private String _joinType;
    private TableNode _table;
    private Expression _condition;

    public JoinTableNode() {
    }

    public JoinTableNode(TableNode table, String joinType, Expression condition) {
        this._table = table;
        this._joinType = joinType;
        this._condition = condition;
    }

    public JoinTableNode(TableNode table) {
        this(table, null, null);
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter) {
        String res = (this._joinType == null || this._joinType.equals("CROSS") ? ", " : "          " + this._joinType + " JOIN ") + this._table.genText(quoter, true);
        if (this._condition != null) {
            res = res + " ON " + this._condition.genText(quoter);
        }
        return res;
    }

    public String genText(SQLIdentifiers.Quoter quoter, boolean first) {
        return first ? this._table.genText(quoter, true) : this.genText(quoter);
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    @Override
    public String getTableName() {
        return this._table.getTableName();
    }

    @Override
    public String getCorrName() {
        return this._table.getCorrName();
    }

    @Override
    public String getTableSpec() {
        return this._table.getTableSpec();
    }

    @Override
    public String getFullTableName() {
        return this._table.getFullTableName();
    }

    @Override
    public String getJoinType() {
        return this._joinType;
    }

    @Override
    public void setJoinType(String joinType) {
        this._joinType = joinType;
    }

    @Override
    public Expression getExpression() {
        return this._condition;
    }

    @Override
    public void setExpression(Expression condition) {
        this._condition = condition;
    }

    @Override
    public void getReferencedColumns(Collection columns) {
        if (this._condition != null) {
            this._condition.getReferencedColumns(columns);
        }
    }

    void renameTableSpec(String oldTableSpec, String corrName) {
        ((TableNode)this.getTable()).renameTableSpec(oldTableSpec, corrName);
        if (this._condition instanceof Predicate) {
            ((Predicate)this._condition).renameTableSpec(oldTableSpec, corrName);
        }
    }

    void setTableSpec(String oldTableSpec, String newTableSpec) {
        ((TableNode)this.getTable()).setTableSpec(oldTableSpec, newTableSpec);
    }

    @Override
    public void addJoinCondition(String[] rel) {
        ColumnNode col1 = new ColumnNode(rel[0], rel[1]);
        ColumnNode col2 = new ColumnNode(rel[2], rel[3]);
        Predicate pred = new Predicate(col1, col2);
        this.setJoinType("INNER");
        this.setExpression(pred);
    }
}

