/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output.dataexport;

import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

abstract class DataExporter {
    protected final Set<String> SUFFIXES;
    protected final String SUFFIX_DESCRIPTION;
    protected final FileFilter FILE_FILTER;

    public DataExporter(String[] suffixes, String suffixDescription) {
        this.SUFFIXES = Stream.of(suffixes).collect(Collectors.toSet());
        this.SUFFIX_DESCRIPTION = suffixDescription;
        this.FILE_FILTER = new FileNameExtensionFilter(this.SUFFIX_DESCRIPTION, this.SUFFIXES.toArray(new String[this.SUFFIXES.size()]));
    }

    public boolean handlesFileFormat(File file) {
        return this.SUFFIXES.stream().anyMatch(suffix -> file.getName().toLowerCase().matches("^.*\\." + suffix + "$"));
    }

    public FileFilter getFileFilter() {
        return this.FILE_FILTER;
    }

    public abstract void exportData(String[] var1, Object[][] var2, File var3);

    public String getDefaultFileExtension() {
        return this.SUFFIXES.iterator().next();
    }
}

