/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandDeploy;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.admin.RunnerHttp;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.utils.Utils;

public class RunnerHttpDeploy
extends RunnerHttp {
    private static final Logger LOGGER = new Logger(RunnerHttpDeploy.class);
    private static final String DEFAULT_PARAM = "DEFAULT";
    private static final String TARGET_PARAM = "target";
    private static final String NAME_PARAM = "name";
    private static final String CTXROOT_PARAM = "contextroot";
    private static final String FORCE_PARAM = "force";
    private static final String PROPERTIES_PARAM = "properties";
    private static final String LIBRARIES_PARAM = "libraries";
    private static final String HOT_DEPLOY_PARAM = "hotDeploy";
    private static final boolean FORCE_VALUE = true;
    final CommandDeploy command;

    private static String query(PayaraServer server, Command command) {
        String path;
        String name;
        CommandDeploy deploy;
        String force = Boolean.toString(true);
        if (command instanceof CommandDeploy) {
            deploy = (CommandDeploy)command;
            if (deploy.path == null) {
                throw new CommandException("Value shall not be null");
            }
            name = Utils.sanitizeName(deploy.name);
            path = deploy.path.getAbsolutePath();
            if (server.isDocker() && server.getHostPath() != null && !server.getHostPath().isEmpty() && server.getContainerPath() != null && !server.getContainerPath().isEmpty()) {
                Path relativePath = Paths.get(server.getHostPath(), new String[0]).relativize(deploy.path.toPath());
                path = Paths.get(server.getContainerPath(), relativePath.toString()).toString();
                if (server.getContainerPath().startsWith("/")) {
                    path = path.replace("\\", "/");
                }
            }
        } else {
            throw new CommandException("Illegal command instance provided");
        }
        String target = deploy.target;
        String ctxRoot = deploy.contextRoot;
        String hotDeploy = Boolean.toString(deploy.hotDeploy);
        StringBuilder sb = new StringBuilder(DEFAULT_PARAM.length() + 1 + path.length() + 1 + FORCE_PARAM.length() + 1 + force.length() + RunnerHttpDeploy.queryPropertiesLength(deploy.properties, PROPERTIES_PARAM) + RunnerHttpDeploy.queryLibrariesLength(deploy.libraries, LIBRARIES_PARAM) + (name != null && name.length() > 0 ? 1 + NAME_PARAM.length() + 1 + name.length() : 0) + (target != null ? 1 + TARGET_PARAM.length() + 1 + target.length() : 0) + (ctxRoot != null && ctxRoot.length() > 0 ? 1 + CTXROOT_PARAM.length() + 1 + ctxRoot.length() : 0));
        sb.append(DEFAULT_PARAM).append('=').append(path);
        sb.append('&');
        sb.append(FORCE_PARAM).append('=').append(force);
        if (name != null && name.length() > 0) {
            sb.append('&');
            sb.append(NAME_PARAM).append('=').append(name);
        }
        if (target != null) {
            sb.append('&');
            sb.append(TARGET_PARAM).append('=').append(target);
        }
        if (ctxRoot != null && ctxRoot.length() > 0) {
            sb.append('&');
            sb.append(CTXROOT_PARAM).append('=').append(ctxRoot);
        }
        if (((CommandDeploy)command).hotDeploy) {
            sb.append('&');
            sb.append(HOT_DEPLOY_PARAM);
            sb.append('=').append(hotDeploy);
        }
        RunnerHttpDeploy.queryPropertiesAppend(sb, deploy.properties, PROPERTIES_PARAM, true);
        RunnerHttpDeploy.queryLibrariesAppend(sb, deploy.libraries, LIBRARIES_PARAM, true);
        return sb.toString();
    }

    public RunnerHttpDeploy(PayaraServer server, Command command) {
        super(server, command, RunnerHttpDeploy.query(server, command));
        this.command = (CommandDeploy)command;
    }

    @Override
    public boolean getDoOutput() {
        return !this.command.dirDeploy;
    }

    @Override
    public String getRequestMethod() {
        return this.command.dirDeploy ? super.getRequestMethod() : "POST";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
        String METHOD = "handleSend";
        InputStream istream = this.getInputStream();
        if (istream != null) {
            ZipOutputStream ostream = null;
            try {
                int n;
                ostream = new ZipOutputStream(new BufferedOutputStream(hconn.getOutputStream(), 0x100000));
                ZipEntry e = new ZipEntry(this.command.path.getName());
                e.setExtra(this.getExtraProperties());
                ostream.putNextEntry(e);
                byte[] buffer = new byte[0x100000];
                while ((n = istream.read(buffer)) >= 0) {
                    ostream.write(buffer, 0, n);
                }
                ostream.closeEntry();
                ostream.flush();
            }
            finally {
                try {
                    istream.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "handleSend", "ioException", ex);
                }
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, "handleSend", "ioException", ex);
                    }
                }
            }
        }
        if ("POST".equalsIgnoreCase(this.getRequestMethod())) {
            LOGGER.log(Level.INFO, "handleSend", "noData");
        }
    }

    @Override
    public String getContentType() {
        return this.command.dirDeploy ? null : "application/zip";
    }

    @Override
    public String getLastModified() {
        return Long.toString(this.command.path.lastModified());
    }

    public InputStream getInputStream() {
        String METHOD = "getInputStream";
        if (this.command.dirDeploy) {
            return null;
        }
        try {
            return new FileInputStream(this.command.path);
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.log(Level.INFO, "getInputStream", "fileNotFound", fnfe);
            return null;
        }
    }
}

